//
//  CRCIImagePart.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 6/17/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

//////////////////////////////////////////////////////////////////////
// CIImage part. This class stores some part of the image, flushes
// it to the HDD and is able to reload the part and restore source image
// original state.
//
// It is used in mask undo/redo system
//////////////////////////////////////////////////////////////////////
@interface CRCIImagePart : NSObject
{
	NSString*	imagePath;
	NSRect		rect;
	CGRect		area;
}

@property (readonly) NSString*	imagePath;
@property (readonly) NSRect		rect;

- (id)initWithBuffer:(CIImage *)ciBuffer andRect:(NSRect)aRect;
- (void)applyToAccumulator:(CIImageAccumulator *)accumulator;

+ (id)imagePartWithBuffer:(CIImage *)ciBuffer andRect:(NSRect)rcSource;

@end