//
//  CRBatchProcessorWindowController.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 12/9/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

@class CRPreset;
@class CRBatchProcessor;
@class CRImagesBatchProcessor;
@class CRBatchCollectionView;

extern NSString* const CRBatchImagesThumbnailsSize;
//extern NSString* const CRBatchImagesOutputFolder;
extern NSString* const CRBatchImagesPrefix;
extern NSString* const CRBatchImagesSuffix;
extern NSString* const CRBatchImagesFileFormat;
extern NSString* const CRBatchImagesCompressionRatio;
extern NSString* const CRBatchImagesExportMode;

//////////////////////////////////////////////////////////////////////
// Batch processing window controller
//////////////////////////////////////////////////////////////////////
@interface CRBatchProcessorWindowController : NSWindowController
{
	CRPreset*	preset;
	
@protected
	BOOL		aspectIsDirty;
	NSLock*		thumbnailsLock;
	CGFloat		currentThumbnailsAspect;
}

@property (nonatomic, copy)	CRPreset* preset;

// Outlets
@property (nonatomic, assign) IBOutlet CRBatchProcessor*		processor;
@property (nonatomic, assign) IBOutlet CRImagesBatchProcessor*	imagesProcessor;
@property (nonatomic, assign) IBOutlet CRBatchCollectionView*	collectionView;
@property (nonatomic, assign) IBOutlet NSSlider*				thumbnailsSizeSlider;
@property (nonatomic, assign) IBOutlet NSPanel*					previewPanel;

@property (nonatomic, assign) IBOutlet NSImageView* zoomMinImage;
@property (nonatomic, assign) IBOutlet NSImageView* zoomMaxImage;

+ (id)sharedProcessor;

// Actions
- (IBAction)delete:(id)sender;
- (IBAction)toggleFullPreview:(id)sender;
- (IBAction)changeThumbnailsSize:(id)sender;
- (IBAction)loadImages:(id)sender;

- (IBAction)export:(id)sender;

@end