//
//  CRBatchProcessor.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 12/8/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

@class CRBatchProcessor;

//////////////////////////////////////////////////////////////////////
// Batch processing delegate
//////////////////////////////////////////////////////////////////////
@protocol CRBatchProcessingDelegate

- (BOOL)processor:(CRBatchProcessor *)processor willExport:(NSUInteger)filesCount;
- (BOOL)processor:(CRBatchProcessor *)processor putSource:(NSString *)sourceFile ofIndex:(NSUInteger)index toDestination:(NSString *)destinationFile;
- (BOOL)processorDidExport:(CRBatchProcessor *)processor;

@end

//////////////////////////////////////////////////////////////////////
// Batch processing manager
//////////////////////////////////////////////////////////////////////
typedef enum {
	CRBatchProcessAll = 0,
	CRBatchProcessSelected,
} CRBatchProcessorMode;

@interface CRBatchProcessor : NSObject
{
	NSOperationQueue*	queueExport;
	BOOL				forcedCancel;
}

// Processing delegate
@property (nonatomic, assign) id<CRBatchProcessingDelegate>	delegate;

// Options
@property (nonatomic, strong) NSArray*				inputFiles;
@property (nonatomic, assign) CRBatchProcessorMode	mode;
@property (nonatomic, strong) NSIndexSet*			selectedFiles;
@property (nonatomic, strong) NSString*				outputFolder;
@property (nonatomic, strong) NSString*				outputExtension;
@property (nonatomic, strong) NSString*				prefix;
@property (nonatomic, strong) NSString*				suffix;

// File management
- (void)addFiles:(NSArray *)files;
- (void)removeFiles:(NSArray *)files;

// Actions
- (IBAction)removeSelectedFiles:(id)sender;
- (IBAction)export:(id)sender;
- (IBAction)cancel:(id)sender;

@end