using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Data;

namespace ReadSample
{
    public class FH_Read
    {
        public FH_Read()
        {
        }

        private int m_MaxRows = 10000;
        public int MaxRows
        {
            get
            {
                return m_MaxRows;
            }
            set
            {                
                m_MaxRows = value;
                if (m_MaxRows > 50000)
                    m_MaxRows = 10000;
            }
        }

        public DataTable FlowHeater_GetDataTable(int rows)
        {
            // your own code
            // create DataTable
            DataTable dt = new DataTable("ReadSample");
            
            // add columns
            dt.Columns.Add("ID", typeof(int));
            dt.Columns.Add("Text", typeof(string));
            dt.Columns.Add("Date", typeof(DateTime));            

            for (int i = 1; i <= MaxRows; i++)
            {
                // have we already enough rows?
                if (rows > 0 && i > rows)
                    break;

                DataRow dr = dt.NewRow();                

                dr["ID"] = i;
                dr["Text"] = i.ToString() + ". Row";
                dr["Date"] = DateTime.Now.AddSeconds(i * 1234.56789);
                
                dt.Rows.Add(dr);
            }

            // return to FlowHeater
            return dt;
        }

        public DataTable FlowHeater_GetDataTable(int rows, StringDictionary parameter)
        {
            string key = "MaxRows";

            if (parameter.ContainsKey(key))
            {
                string s = parameter[key];
                int i = 0;
                if (Int32.TryParse(s, out i))
                    MaxRows = i;
            }

            return FlowHeater_GetDataTable(rows);
        }
    }
}
