using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Data;
using System.Windows.Forms;

namespace WriteSample
{
    public class FH_Write
    {
        public FH_Write()
        {
        }

        public void FlowHeater_SetDataTable(DataTable dt)
        {
            /*
             * Diese Funktion wird gerufen wenn auf der WRITE Seite
             * keine Parameter angegeben wurden!
             */
            MessageBox.Show("WriteSample, " + dt.Rows.Count.ToString() + " Datenstze erhalten", "WriteSample.DLL", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        public void FlowHeater_SetDataTable(DataTable dt, StringDictionary parameter)
        {
            /*
             * Diese Funktion wird gerufen wenn auf der WRITE Seite
             * Parameter angegeben wurden!
             */

            StringBuilder sb = new StringBuilder();
            sb.AppendLine("WriteSample, " + dt.Rows.Count.ToString() + " Datenstze erhalten");
            sb.AppendLine();
            sb.AppendLine("Parameter:");

            string server = parameter["Server"];

            foreach (string key in parameter.Keys)
                sb.AppendLine(key + " = " + parameter[key]);            

            MessageBox.Show(sb.ToString(), "WriteSample.DLL", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }
    }
}
