using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Data;

namespace ReadSample
{
    public class FH_Read
    {
        public FH_Read()
        {
        }

        private int m_MaxRows = 10000;
        public int MaxRows
        {
            get
            {
                return m_MaxRows;
            }
            set
            {                
                m_MaxRows = value;
                if (m_MaxRows > 50000)
                    m_MaxRows = 10000;
            }
        }

        public DataTable FlowHeater_GetDataTable(int rows)
        {
            // ihr eigener Code
            // DataTable erzeugen
            DataTable dt = new DataTable("ReadSample");
            
            // Columns hinzufgen
            dt.Columns.Add("ID", typeof(int));
            dt.Columns.Add("Text", typeof(string));
            dt.Columns.Add("Datum", typeof(DateTime));            

            for (int i = 1; i <= MaxRows; i++)
            {
                // haben wir schon genug Datensatze erzeugt
                if (rows > 0 && i > rows)
                    break;

                DataRow dr = dt.NewRow();                

                dr["ID"] = i;
                dr["Text"] = i.ToString() + ". Zeile";
                dr["Datum"] = DateTime.Now.AddSeconds(i * 1234.56789);
                
                dt.Rows.Add(dr);
            }

            // und das ganze zurck zum FlowHeater
            return dt;
        }

        public DataTable FlowHeater_GetDataTable(int rows, StringDictionary parameter)
        {
            string key = "MaxRows";

            if (parameter.ContainsKey(key))
            {
                string s = parameter[key];
                int i = 0;
                if (Int32.TryParse(s, out i))
                    MaxRows = i;
            }

            return FlowHeater_GetDataTable(rows);
        }
    }
}
