-- ==========================================================================
-- \file   const.lua
-- \brief  ゲーム固定値
-- \author Seiichi YAMAGUCHI
-- ==========================================================================
charas = {
    {
        ['code']   = 'RYU',
        ['name']   = 'Ryu',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.0,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.12,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'KEN',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_RYU_J',
        ['localize_id_e'] = 'ID_BSC_CHA_RYU_E',
        ['title_base'] = 168,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = 0.0,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.52
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['gadget_1'] = { --- SACK
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'KEN',
        ['name']   = 'Ken',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.0,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.12,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'RYU',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_KEN_J',
        ['localize_id_e'] = 'ID_BSC_CHA_KEN_E',
        ['title_base'] = 178,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = -0.02,
            ['front_base_z'] = -0.04,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.5
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['gadget_1'] = { --- BAG
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'CNL',
        ['name']   = 'Chun-Li',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 900,
        ['waist_rate'] = 1.07,
        ['sight_coef_x'] = 0.50,
        ['sight_coef_y'] = 0.50,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.09,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'CMY',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_CNL_J',
        ['localize_id_e'] = 'ID_BSC_CHA_CNL_E',
        ['title_base'] = 188,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 1.0,
            ['front_base_x'] = 0.03,
            ['front_base_y'] = -0.02,
            ['front_base_z'] = -0.04,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.55
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'CMY',
        ['name']   = 'Cammy',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 900,
        ['waist_rate'] = 1.01,
        ['sight_coef_x'] = 0.55,
        ['sight_coef_y'] = 0.60,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.14,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'CNL',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_CMY_J',
        ['localize_id_e'] = 'ID_BSC_CHA_CMY_E',
        ['title_base'] = 198,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 1.0,
            ['front_base_x'] = -0.04,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = -0.02,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.47
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'GUL',
        ['name']   = 'Guile',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 950,
        ['vital_5'] = 900,
        ['waist_rate'] = 1.02,
        ['sight_coef_x'] = 0.8,
        ['sight_coef_y'] = 1.2,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.1,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'ABL',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_GUL_J',
        ['localize_id_e'] = 'ID_BSC_CHA_GUL_E',
        ['title_base'] = 208,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = -10,
            ['front_base_x'] = -0.07,
            ['front_base_y'] = 0.02,
            ['front_base_z'] = -0.03,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.50
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'ABL',
        ['name']   = 'Abel',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1050,
        ['waist_rate'] = 1.1,
        ['col_scale_x'] = 1.1,
        ['col_scale_y'] = 1.12,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.14,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'GUL',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_ABL_J',
        ['localize_id_e'] = 'ID_BSC_CHA_ABL_E',
        ['title_base'] = 238,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = -0.05,
            ['front_base_y'] = 0.00,
            ['front_base_z'] = -0.23,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.68
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'DSM',
        ['name']   = 'Dhalsim',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 900,
        ['waist_rate'] = 0.99,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.09,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'SGT',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_DSM_J',
        ['localize_id_e'] = 'ID_BSC_CHA_DSM_E',
        ['title_base'] = 218,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0.1,
            ['front_base_x'] = -0.02,
            ['front_base_y'] = -0.03,
            ['front_base_z'] = -0.07,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.42
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'SGT',
        ['name']   = 'Sagat',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1050,
        ['waist_rate'] = 1.15,
        ['col_scale_x'] = 1.1,
        ['col_scale_y'] = 1.12,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'NECK',
        ['ikfoot_radius'] = 0.15,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'DSM',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_SGT_J',
        ['localize_id_e'] = 'ID_BSC_CHA_SGT_E',
        ['title_base'] = 228,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] =-4.2,
            ['front_base_x'] = -0.08,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = -0.02,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.72
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'RLN',
        ['name']   = 'Rolento',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['vital_5'] = 930,
        ['waist_rate'] = 1.05,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.14,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'IBK',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_RLN_J',
        ['localize_id_e'] = 'ID_BSC_CHA_RLN_E',
        ['title_base'] = 248,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = -0.03,
            ['front_base_y'] = -0.07,
            ['front_base_z'] = -0.2,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.57
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'IBK',
        ['name']   = 'Ibuki',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 900,
        ['waist_rate'] = 1.0,
        ['sight_coef_x'] = 0.50,
        ['sight_coef_y'] = 0.50,
        ['sight_target'] = 'STOMACH',
        ['ikfoot_radius'] = 0.13,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'RLN',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_IBK_J',
        ['localize_id_e'] = 'ID_BSC_CHA_IBK_E',
        ['title_base'] = 258,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = -1.4,
            ['front_base_x'] = 0.00,
            ['front_base_y'] = -0.02,
            ['front_base_z'] = -0.07,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.48
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'PSN',
        ['name']   = 'Poison',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 950,
        ['waist_rate'] = 1.1,
        ['sight_coef_x'] = 0.60,
        ['sight_coef_y'] = 0.60,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.15,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'HUG',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_PSN_J',
        ['localize_id_e'] = 'ID_BSC_CHA_PSN_E',
        ['title_base'] = 268,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0.3,
            ['front_base_x'] = -0.02,
            ['front_base_y'] = -0.02,
            ['front_base_z'] = -0.07,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.54
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'HUG',
        ['name']   = 'Hugo',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1150,
        ['waist_rate'] = 1.3,
        ['col_scale_x'] = 1.3,
        ['col_scale_y'] = 1.25,
        ['sight_coef_x'] = 0.6,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.19,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'PSN',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_HUG_J',
        ['localize_id_e'] = 'ID_BSC_CHA_HUG_E',
        ['title_base'] = 278,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = -3,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = 0.0,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.70
        },
        ['costume_1'] = {
            ['foot'] = 'super_giant',
        },
        ['costume_2'] = {
            ['foot'] = 'super_giant',
        },
        ['costume_3'] = {
            ['foot'] = 'super_giant',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'RFS',
        ['name']   = 'Rufus',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 0.81,
        ['sight_coef_x'] = 0.8,
        ['sight_coef_y'] = 1.1,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.12,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'ZGF',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_RFS_J',
        ['localize_id_e'] = 'ID_BSC_CHA_RFS_E',
        ['title_base'] = 288,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = 0.21,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.48
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'ZGF',
        ['name']   = 'Zangief',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1100,
        ['waist_rate'] = 1.19,
        ['col_scale_x'] = 1.1,
        ['col_scale_y'] = 1.12,
        ['sight_coef_x'] = 0.5,
        ['sight_coef_y'] = 0.7,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.17,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'RFS',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_ZGF_J',
        ['localize_id_e'] = 'ID_BSC_CHA_ZGF_E',
        ['title_base'] = 298,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = -3.3,
            ['front_base_x'] = -0.06,
            ['front_base_y'] = -0.07,
            ['front_base_z'] = -0.4,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.74
        },
        ['costume_1'] = {
            ['foot'] = 'giant',
        },
        ['costume_2'] = {
            ['foot'] = 'giant',
        },
        ['costume_3'] = {
            ['foot'] = 'giant',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'VEG',
        ['name']   = 'Vega',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.1,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.15,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'JRI',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_VEG_J',
        ['localize_id_e'] = 'ID_BSC_CHA_VEG_E',
        ['title_base'] = 328,
        ['compatible_group'] = 'B',
        ['comment'] = {
            ['front_rotate'] = -1.8,
            ['front_base_x'] = -0.04,
            ['front_base_y'] = -0.02,
            ['front_base_z'] = -0.15,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.66
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'JRI',
        ['name']   = 'Juri',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 900,
        ['waist_rate'] = 0.98,
        ['sight_coef_x'] = 0.15,
        ['sight_coef_y'] = 1.15,
        ['sight_target'] = 'CHEST',
        ['ikfoot_radius'] = 0.11,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'VEG',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_JRI_J',
        ['localize_id_e'] = 'ID_BSC_CHA_JRI_E',
        ['title_base'] = 338,
        ['compatible_group'] = 'B',
        ['comment'] = {
            ['front_rotate'] = 0.9,
            ['front_base_x'] = -0.06,
            ['front_base_y'] = -0.04,
            ['front_base_z'] = -0.31,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.41
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'GKI',
        ['name']   = 'Gouki',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 850,
        ['waist_rate'] = 1.02,
        ['sight_coef_x'] = 0.85,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.13,
        ['ikhand_radius'] = 0.05,
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_GKI_J',
        ['localize_id_e'] = 'ID_BSC_CHA_GKI_E',
        ['title_base'] = 348,
        ['compatible_group'] = 'B',
        ['comment'] = {
            ['front_rotate'] = -4.2,
            ['front_base_x'] = -0.07,
            ['front_base_y'] = -0.03,
            ['front_base_z'] = -0.11,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.50
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'SKR',
        ['name']   = 'Sakura',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 950,
        ['waist_rate'] = 0.99,
        ['sight_coef_x'] = 0.50,
        ['sight_coef_y'] = 0.50,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.12,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'BLK',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_SKR_J',
        ['localize_id_e'] = 'ID_BSC_CHA_SKR_E',
        ['title_base'] = 598,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = -0.04,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = -0.1,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.40
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'BLK',
        ['name']   = 'Blanka',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 0.96,
        ['sight_coef_x'] = 0.6,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.12,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'SKR',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_BLK_J',
        ['localize_id_e'] = 'ID_BSC_CHA_BLK_E',
        ['title_base'] = 608,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = -1,
            ['front_base_x'] = -0.04,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = 0.07,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.29
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'BLR',
        ['name']   = 'Balrog',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 950,
        ['item_1'] = { --- CLAW
            ['endurance'] = 100,
            ['pickup_radius'] = 0.25,
        },
        ['item_2'] = { --- MASK
            ['endurance'] = 150,
            ['pickup_radius'] = 0.25,
        },
        ['waist_rate'] = 1.1,
        ['col_scale_x'] = 1.1,
        ['col_scale_y'] = 1.12,
        ['sight_coef_x'] = 0.8,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.09,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'BSN',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_BLR_J',
        ['localize_id_e'] = 'ID_BSC_CHA_BLR_E',
        ['title_base'] = 308,
        ['compatible_group'] = 'B',
        ['comment'] = {
            ['front_rotate'] = -1.9,
            ['front_base_x'] = -0.08,
            ['front_base_y'] = -0.04,
            ['front_base_z'] = -0.23,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.62
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'BSN',
        ['name']   = 'M.Bison',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1050,
        ['waist_rate'] = 1.09,
        ['col_scale_x'] = 1.1,
        ['col_scale_y'] = 1.12,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.12,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'BLR',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_BSN_J',
        ['localize_id_e'] = 'ID_BSC_CHA_BSN_E',
        ['title_base'] = 318,
        ['compatible_group'] = 'B',
        ['comment'] = {
            ['front_rotate'] = -1.4,
            ['front_base_x'] = -0.04,
            ['front_base_y'] = -0.04,
            ['front_base_z'] = -0.08,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.55
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'GUY',
        ['name']   = 'Guy',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 0.99,
        ['sight_coef_x'] = 0.15,
        ['sight_coef_y'] = 0.45,
        ['sight_target'] = 'STOMACH',
        ['ikfoot_radius'] = 0.13,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'CDY',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_GUY_J',
        ['localize_id_e'] = 'ID_BSC_CHA_GUY_E',
        ['title_base'] = 618,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = -1.1,
            ['front_base_x'] = -0.08,
            ['front_base_y'] = 0.02,
            ['front_base_z'] = -0.12,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.51
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'CDY',
        ['name']   = 'Cody',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['item_1'] = { --- KNIFE
            ['endurance'] = 0,
            ['pickup_radius'] = 0.75,
        },
        ['waist_rate'] = 1.01,
        ['sight_coef_x'] = 0.15,
        ['sight_coef_y'] = 0.45,
        ['sight_target'] = 'CHEST',
        ['ikfoot_radius'] = 0.17,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'GUY',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_CDY_J',
        ['localize_id_e'] = 'ID_BSC_CHA_CDY_E',
        ['title_base'] = 628,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = -1.3,
            ['front_base_x'] = -0.04,
            ['front_base_y'] = -0.01,
            ['front_base_z'] = -0.14,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.51
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'ELN',
        ['name']   = 'Elena',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 900,
        ['waist_rate'] = 1.09,
        ['sight_coef_x'] = 0.60,
        ['sight_coef_y'] = 0.60,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.15,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'DDL',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_ELN_J',
        ['localize_id_e'] = 'ID_BSC_CHA_ELN_E',
        ['title_base'] = 638,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = -0.02,
            ['front_base_z'] = -0.12,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.56
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'DDL',
        ['name']   = 'Dudley',
        ['series'] = 'SF',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1050,
        ['waist_rate'] = 1.04,
        ['sight_coef_x'] = 0.15,
        ['sight_coef_y'] = 0.50,
        ['sight_target'] = 'CHEST',
        ['ikfoot_radius'] = 0.14,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'ELN',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_DDL_J',
        ['localize_id_e'] = 'ID_BSC_CHA_DDL_E',
        ['title_base'] = 648,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = -0.02,
            ['front_base_z'] = 0.06,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.65
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'KAZ',
        ['name']   = 'Kazuya',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.02,
        ['sight_coef_x'] = 1.13876534,
        ['sight_coef_y'] = 0.45,
        ['sight_target'] = 'CHEST',
        ['ikfoot_radius'] = 0.12,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'NIN',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_KAZ_J',
        ['localize_id_e'] = 'ID_BSC_CHA_KAZ_E',
        ['title_base'] = 358,
        ['compatible_group'] = 'B',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.03,
            ['front_base_y'] = -0.03,
            ['front_base_z'] = -0.1,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.45
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'NIN',
        ['name']   = 'Nina',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 900,
        ['waist_rate'] = 1.06,
        ['sight_coef_x'] = 0.15,
        ['sight_coef_y'] = 1.15,
        ['sight_target'] = 'CHEST',
        ['ikfoot_radius'] = 0.14,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'KAZ',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_NIN_J',
        ['localize_id_e'] = 'ID_BSC_CHA_NIN_E',
        ['title_base'] = 368,
        ['compatible_group'] = 'B',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = -0.02,
            ['front_base_z'] = 0.0,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.56
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'ASK',
        ['name']   = 'Asuka',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 950,
        ['waist_rate'] = 0.99,
        ['sight_coef_x'] = 0.6,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.12,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'LIL',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_ASK_J',
        ['localize_id_e'] = 'ID_BSC_CHA_ASK_E',
        ['title_base'] = 378,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = -0.01,
            ['front_base_z'] = 0.09,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.48
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'LIL',
        ['name']   = 'Lili',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 900,
        ['waist_rate'] = 0.99,
        ['sight_coef_x'] = 0.3,
        ['sight_coef_y'] = 0.5,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.14,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'ASK',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_LIL_J',
        ['localize_id_e'] = 'ID_BSC_CHA_LIL_E',
        ['title_base'] = 388,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = 0.04,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.52
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'HEI',
        ['name']   = 'Heihachi',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.02,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'STOMACH',
        ['ikfoot_radius'] = 0.13,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'KUM',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_HEI_J',
        ['localize_id_e'] = 'ID_BSC_CHA_HEI_E',
        ['title_base'] = 398,
        ['compatible_group'] = 'B',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = 0.03,
            ['front_base_z'] = 0.1,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.51
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'KUM',
        ['name']   = 'Kuma',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'animal',
        ['vital']  = 1100,
        ['waist_rate'] = 0.925,
        ['col_scale_x'] = 1.1,
        ['col_scale_y'] = 1.12,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.16,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'HEI',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_KUM_J',
        ['localize_id_e'] = 'ID_BSC_CHA_KUM_E',
        ['title_base'] = 408,
        ['compatible_group'] = 'B',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.02,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = 0.15,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.32
        },
        ['costume_1'] = {
            ['foot'] = 'giant',
        },
        ['costume_2'] = {
            ['foot'] = 'giant',
        },
        ['costume_3'] = {
            ['foot'] = 'giant',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'PAU',
        ['name']   = 'Paul',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1050,
        ['waist_rate'] = 1.0,
        ['sight_coef_x'] = 0.65,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.12,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'LAW',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_PAU_J',
        ['localize_id_e'] = 'ID_BSC_CHA_PAU_E',
        ['title_base'] = 418,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = -2.9,
            ['front_base_x'] = -0.07,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = -0.06,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.47
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'LAW',
        ['name']   = 'Law',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.0,
        ['sight_coef_x'] = 0.70,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.13,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'PAU',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_LAW_J',
        ['localize_id_e'] = 'ID_BSC_CHA_LAW_E',
        ['title_base'] = 428,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = -2.1,
            ['front_base_x'] = -0.04,
            ['front_base_y'] = 0.04,
            ['front_base_z'] = -0.01,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.46
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'KIN',
        ['name']   = 'King',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.06,
        ['col_scale_x'] = 1.1,
        ['col_scale_y'] = 1.12,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.14,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'MAR',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_KIN_J',
        ['localize_id_e'] = 'ID_BSC_CHA_KIN_E',
        ['title_base'] = 438,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = 0.01,
            ['front_base_z'] = 0.11,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.39
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'MAR',
        ['name']   = 'Marduk',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1050,
        ['waist_rate'] = 1.06,
        ['col_scale_x'] = 1.1,
        ['col_scale_y'] = 1.12,
        ['sight_coef_x'] = 0.70,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'CHEST',
        ['ikfoot_radius'] = 0.16,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'KIN',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_MAR_J',
        ['localize_id_e'] = 'ID_BSC_CHA_MAR_E',
        ['title_base'] = 448,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 1.3,
            ['front_base_x'] = 0.05,
            ['front_base_y'] = -0.02,
            ['front_base_z'] = -0.04,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.58
        },
        ['costume_1'] = {
            ['foot'] = 'giant',
        },
        ['costume_2'] = {
            ['foot'] = 'giant',
        },
        ['costume_3'] = {
            ['foot'] = 'giant',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'HWO',
        ['name']   = 'Hwoarang',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.01,
        ['sight_coef_x'] = 0.50,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.08,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'STE',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_HWO_J',
        ['localize_id_e'] = 'ID_BSC_CHA_HWO_E',
        ['title_base'] = 458,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = -0.02,
            ['front_base_y'] = -0.035,
            ['front_base_z'] = -0.19,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.56
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'STE',
        ['name']   = 'Steve',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.08,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.14,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'HWO',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_STE_J',
        ['localize_id_e'] = 'ID_BSC_CHA_STE_E',
        ['title_base'] = 468,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = -0.03,
            ['front_base_z'] = 0.01,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.62
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'BOB',
        ['name']   = 'Bob',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1050,
        ['waist_rate'] = 0.83,
        ['sight_coef_x'] = 0.50,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.11,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'JUL',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_BOB_J',
        ['localize_id_e'] = 'ID_BSC_CHA_BOB_E',
        ['title_base'] = 478,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = 0.16,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.51
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'JUL',
        ['name']   = 'Julia',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 1000,
        ['vital_5']  = 950,
        ['waist_rate'] = 1.01,
        ['sight_coef_x'] = 0.55,
        ['sight_coef_y'] = 0.50,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.14,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'BOB',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_JUL_J',
        ['localize_id_e'] = 'ID_BSC_CHA_JUL_E',
        ['title_base'] = 488,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = -1,
            ['front_base_x'] = -0.03,
            ['front_base_y'] = 0.01,
            ['front_base_z'] = 0.0,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.48
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'JIN',
        ['name']   = 'Jin',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.0,
        ['sight_coef_x'] = 0.50,
        ['sight_coef_y'] = 0.50,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.13,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'XIA',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_JIN_J',
        ['localize_id_e'] = 'ID_BSC_CHA_JIN_E',
        ['title_base'] = 518,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = -0.06,
            ['front_base_z'] = -0.11,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.52
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'XIA',
        ['name']   = 'Xiaoyu',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 900,
        ['waist_rate'] = 0.99,
        ['sight_coef_x'] = 0.60,
        ['sight_coef_y'] = 0.60,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.12,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'JIN',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_XIA_J',
        ['localize_id_e'] = 'ID_BSC_CHA_XIA_E',
        ['title_base'] = 528,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = 0.02,
            ['front_base_z'] = -0.08,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.40
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'OGR',
        ['name']   = 'Ogre',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.06,
        ['col_scale_x'] = 1.1,
        ['col_scale_y'] = 1.12,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.15,
        ['ikhand_radius'] = 0.05,
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_OGR_J',
        ['localize_id_e'] = 'ID_BSC_CHA_OGR_E',
        ['title_base'] = 538,
        ['compatible_group'] = 'B',
        ['comment'] = {
            ['front_rotate'] = -1.7,
            ['front_base_x'] = -0.1,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = -0.37,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.83
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'LRS',
        ['name']   = 'Lars',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.015,
        ['sight_coef_x'] = 0.65,
        ['sight_coef_y'] = 0.90,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.14,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'ALS',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_LRS_J',
        ['localize_id_e'] = 'ID_BSC_CHA_LRS_E',
        ['title_base'] = 658,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = -2.5,
            ['front_base_x'] = -0.04,
            ['front_base_y'] = 0.01,
            ['front_base_z'] = -0.37,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.51
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'ALS',
        ['name']   = 'Alisa',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 1000,
        ['vital_5']  = 950,
        ['waist_rate'] = 0.99,
        ['sight_coef_x'] = 0.3,
        ['sight_coef_y'] = 0.7,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.12,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'LRS',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_ALS_J',
        ['localize_id_e'] = 'ID_BSC_CHA_ALS_E',
        ['title_base'] = 668,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = -0.7,
            ['front_base_x'] = -0.06,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = -0.03,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.38
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'YOS',
        ['name']   = 'Yoshimitsu',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.05,
        ['sight_coef_x'] = 1.0,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.14,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'RAV',
        ['default_voice'] = 'JPN',
        ['localize_id_j'] = 'ID_BSC_CHA_YOS_J',
        ['localize_id_e'] = 'ID_BSC_CHA_YOS_E',
        ['title_base'] = 498,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.01,
            ['front_base_y'] = -0.01,
            ['front_base_z'] = -0.14,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.40
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'bare',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'RAV',
        ['name']   = 'Raven',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 1.05,
        ['sight_coef_x'] = 0.5,
        ['sight_coef_y'] = 0.9,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.135,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'YOS',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_RAV_J',
        ['localize_id_e'] = 'ID_BSC_CHA_RAV_E',
        ['title_base'] = 508,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = -0.06,
            ['front_base_z'] = -0.05,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.55
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'JAC',
        ['name']   = 'JACK-X',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1150,
        ['vital_5']  = 1100,
        ['waist_rate'] = 1.09,
        ['col_scale_x'] = 1.3,
        ['col_scale_y'] = 1.25,
        ['sight_coef_x'] = 0.65,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.20,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'BRY',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_JAC_J',
        ['localize_id_e'] = 'ID_BSC_CHA_JAC_E',
        ['title_base'] = 678,
        ['compatible_group'] = 'B',
        ['comment'] = {
            ['front_rotate'] = 0,
            ['front_base_x'] = 0.0,
            ['front_base_y'] = -0.03,
            ['front_base_z'] = -0.41,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.83
        },
        ['costume_1'] = {
            ['foot'] = 'giant',
        },
        ['costume_2'] = {
            ['foot'] = 'giant',
        },
        ['costume_3'] = {
            ['foot'] = 'giant',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'BRY',
        ['name']   = 'Bryan',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1050,
        ['waist_rate'] = 1.09,
        ['sight_coef_x'] = 0.4,
        ['sight_coef_y'] = 1.1,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.13,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'JAC',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_BRY_J',
        ['localize_id_e'] = 'ID_BSC_CHA_BRY_E',
        ['title_base'] = 688,
        ['compatible_group'] = 'B',
        ['comment'] = {
            ['front_rotate'] = -3.4,
            ['front_base_x'] = -0.03,
            ['front_base_y'] = -0.03,
            ['front_base_z'] = -0.35,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.50
        },
        ['costume_1'] = {
            ['foot'] = 'shoes',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'CHR',
        ['name']   = 'Christie',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'female',
        ['vital']  = 900,
        ['vital_5']  = 950,
        ['waist_rate'] = 1.08,
        ['sight_coef_x'] = 0.50,
        ['sight_coef_y'] = 0.60,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.13,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'LEI',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_CHR_J',
        ['localize_id_e'] = 'ID_BSC_CHA_CHR_E',
        ['title_base'] = 698,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = 0.4,
            ['front_base_x'] = -0.04,
            ['front_base_y'] = -0.03,
            ['front_base_z'] = -0.25,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.54
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'shoes',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['costume_num'] = 3,
    },
    {
        ['code']   = 'LEI',
        ['name']   = 'Lei',
        ['series'] = 'TK',
        ['package'] = 'STD',
        ['unlock'] = 'default',
        ['chara']  = 'male',
        ['vital']  = 1000,
        ['waist_rate'] = 0.98,
        ['sight_coef_x'] = 0.6,
        ['sight_coef_y'] = 1.0,
        ['sight_target'] = 'HEAD',
        ['ikfoot_radius'] = 0.13,
        ['ikhand_radius'] = 0.05,
        ['official_partner'] = 'CHR',
        ['default_voice'] = 'ENG',
        ['localize_id_j'] = 'ID_BSC_CHA_LEI_J',
        ['localize_id_e'] = 'ID_BSC_CHA_LEI_E',
        ['title_base'] = 708,
        ['compatible_group'] = 'A',
        ['comment'] = {
            ['front_rotate'] = -1.6,
            ['front_base_x'] = -0.02,
            ['front_base_y'] = 0.0,
            ['front_base_z'] = -0.1,
            ['back_rotate'] = 15,
            ['back_base_x'] = 0.7,
            ['back_base_y'] = 0.0,
            ['back_base_z'] = 1.0,
        },
        ['customize'] = {
            ['camera_max_height'] = 1.57
        },
        ['costume_1'] = {
            ['foot'] = 'bare',
        },
        ['costume_2'] = {
            ['foot'] = 'bare',
        },
        ['costume_3'] = {
            ['foot'] = 'shoes',
        },
        ['gadget_1'] = { --- PHONE
        },
        ['costume_num'] = 3,
    },
}

fields = {
    {
        ['code']          = 'TRN',
        ['name']          = 'Training Stage',
        ['floor_count']   = 1,
        ['type']          = 'TRAINING',
        ['localize_id_j'] = 'ID_BSC_STG_TRN_J',
        ['localize_id_e'] = 'ID_BSC_STG_TRN_E',
    },
    {
        ['code']          = 'UWZ',
        ['name']          = 'Urban War Zone',
        ['floor_count']   = 1,
        ['type']          = 'NORMAL',
        ['localize_id_j'] = 'ID_BSC_STG_UWZ_J',
        ['localize_id_e'] = 'ID_BSC_STG_UWZ_E',
    },
    {
        ['code']          = 'JUR',
        ['name']          = 'Jurassic Era Research Facility',
        ['floor_count']   = 2,
        ['type']          = 'NORMAL',
        ['localize_id_j'] = 'ID_BSC_STG_JUR_J',
        ['localize_id_e'] = 'ID_BSC_STG_JUR_E',
    },
    {
        ['code']          = 'ELV',
        ['name']          = 'Cosmic Elevator',
        ['floor_count']   = 1,
        ['type']          = 'NORMAL',
        ['localize_id_j'] = 'ID_BSC_STG_ELV_J',
        ['localize_id_e'] = 'ID_BSC_STG_ELV_E',
    },
    {
        ['code']          = 'DET',
        ['name']          = 'The Pitstop 109',
        ['floor_count']   = 1,
        ['type']          = 'NORMAL',
        ['localize_id_j'] = 'ID_BSC_STG_DET_J',
        ['localize_id_e'] = 'ID_BSC_STG_DET_E',
    },
    {
        ['code']          = 'HFP',
        ['name']          = 'The Half Pipe',
        ['floor_count']   = 2,
        ['type']          = 'NORMAL',
        ['localize_id_j'] = 'ID_BSC_STG_HFP_J',
        ['localize_id_e'] = 'ID_BSC_STG_HFP_E',
    },
    {
        ['code']          = 'BFU',
        ['name']          = 'Blast Furnace',
        ['floor_count']   = 1,
        ['type']          = 'NORMAL',
        ['localize_id_j'] = 'ID_BSC_STG_BFU_J',
        ['localize_id_e'] = 'ID_BSC_STG_BFU_E',
    },
    {
        ['code']          = 'MAD',
        ['name']          = 'Mad Gear Hideout',
        ['floor_count']   = 1,
        ['type']          = 'NORMAL',
        ['localize_id_j'] = 'ID_BSC_STG_MAD_J',
        ['localize_id_e'] = 'ID_BSC_STG_MAD_E',
    },
    {
        ['code']          = 'MSR',
        ['name']          = 'Mishima Estate',
        ['floor_count']   = 3,
        ['type']          = 'NORMAL',
        ['localize_id_j'] = 'ID_BSC_STG_MSR_J',
        ['localize_id_e'] = 'ID_BSC_STG_MSR_E',
    },
    {
        ['code']          = 'ANT',
        ['name']          = 'Antarctica',
        ['floor_count']   = 1,
        ['type']          = 'MBOSS',
        ['localize_id_j'] = 'ID_BSC_STG_ANT_J',
        ['localize_id_e'] = 'ID_BSC_STG_ANT_E',
    },
    {
        ['code']          = 'PDB',
        ['name']          = "Pandora's Box",
        ['floor_count']   = 1,
        ['type']          = 'LBOSS',
        ['localize_id_j'] = 'ID_BSC_STG_PDB_J',
        ['localize_id_e'] = 'ID_BSC_STG_PDB_E',
    },
}

bgms = {
    {
        ['code'] = 'TRN',
        ['name'] = 'Stage - Training Stage',
        ['cue_num'] = 1,
        ['cue_volume'] = {
          ['cue_0'] = 0.32,
        },
    },
    {
        ['code'] = 'UWZ',
        ['name'] = 'Stage - Urban War Zone',
        ['cue_num'] = 1,
        ['cue_volume'] = {
          ['cue_0'] = 0.28,
        },
    },
    {
        ['code'] = 'JUR',
        ['name'] = 'Stage - Jurassic Era Research Facility',
        ['cue_num'] = 2,
        ['cue_volume'] = {
          ['cue_0'] = 0.36,
          ['cue_1'] = 0.36,
        },
    },
    {
        ['code'] = 'ELV',
        ['name'] = 'Stage - Cosmic Elevator',
        ['cue_num'] = 1,
        ['cue_volume'] = {
          ['cue_0'] = 0.30,
        },
    },
    {
        ['code'] = 'DET',
        ['name'] = 'Stage - The Pitstop 109',
        ['cue_num'] = 2,
        ['cue_volume'] = {
          ['cue_0'] = 0.38,
          ['cue_1'] = 0.36,
        },
    },
    {
        ['code'] = 'HFP',
        ['name'] = 'Stage - The Half Pipe',
        ['cue_num'] = 2,
        ['cue_volume'] = {
          ['cue_0'] = 0.42,
          ['cue_1'] = 0.60,
        },
    },
    {
        ['code'] = 'BFU',
        ['name'] = 'Stage - Blast Furnace',
        ['cue_num'] = 2,
        ['cue_volume'] = {
          ['cue_0'] = 0.33,
          ['cue_1'] = 0.40,
        },
    },
    {
        ['code'] = 'MAD',
        ['name'] = 'Stage - Mad Gear Hideout',
        ['cue_num'] = 3,
        ['cue_volume'] = {
          ['cue_0'] = 0.36,
          ['cue_1'] = 0.30,
          ['cue_2'] = 0.36,
        },
    },
    {
        ['code'] = 'MSR',
        ['name'] = 'Stage - Mishima Estate',
        ['cue_num'] = 3,
        ['cue_volume'] = {
          ['cue_0'] = 0.28,
          ['cue_1'] = 0.36,
          ['cue_2'] = 0.33,
        },
    },
    {
        ['code'] = 'ANT',
        ['name'] = 'Stage - Antarctica',
        ['cue_num'] = 1,
        ['cue_volume'] = {
          ['cue_0'] = 0.36,
        },
    },
    {
        ['code'] = 'PDB',
        ['name'] = "Stage - Pandora's Box",
        ['cue_num'] = 2,
        ['cue_volume'] = {
          ['cue_0'] = 0.36,
          ['cue_1'] = 0.36,
        },
    },
    {
        ['code'] = 'SFM',
        ['name'] = 'Boss Battle - Miniboss(SF)',
        ['cue_num'] = 1,
        ['cue_volume'] = {
          ['cue_0'] = 0.50,
        },
    },
    {
        ['code'] = 'SFB',
        ['name'] = "Boss Battle - Superboss(SF)",
        ['cue_num'] = 1,
        ['cue_volume'] = {
          ['cue_0'] = 0.42,
        },
    },
    {
        ['code'] = 'TKM',
        ['name'] = 'Boss Battle - Miniboss(TK)',
        ['cue_num'] = 1,
        ['cue_volume'] = {
          ['cue_0'] = 0.30,
        },
    },
    {
        ['code'] = 'TKB',
        ['name'] = "Boss Battle - Superboss(TK)",
        ['cue_num'] = 1,
        ['cue_volume'] = {
          ['cue_0'] = 0.27,
        },
    },
    {
        ['code'] = 'RSF',
        ['name'] = 'Rival Battle (SF)',
        ['cue_num'] = 1,
        ['cue_volume'] = {
          ['cue_0'] = 0.38,
        },
    },
    {
        ['code'] = 'RSX',
        ['name'] = 'Rival Battle 2 (SF)',
        ['cue_num'] = 1,
        ['cue_volume'] = {
          ['cue_0'] = 0.38,
        },
    },
    {
        ['code'] = 'RTK',
        ['name'] = "Rival Battle (TK)",
        ['cue_num'] = 1,
        ['cue_volume'] = {
          ['cue_0'] = 0.25,
        },
    },
    {
        ['code'] = 'RTX',
        ['name'] = "Rival Battle 2 (TK)",
        ['cue_num'] = 1,
        ['cue_volume'] = {
          ['cue_0'] = 0.35,
        },
    },
    {
        ['code'] = 'DAN',
        ['name'] = "Tutorial Stage",
        ['cue_num'] = 1,
        ['cue_volume'] = {
          ['cue_0'] = 0.25,
        },
    },
}

countries = {
    {
        ['code'] = 'JPN',
        ['name'] = 'Japan',
    },
    {
        ['code'] = 'USA',
        ['name'] = 'United States of America'
    },
};

battle_config = {
    ['region_dist_x'] = 2.5,
    ['region_dist_y'] = 2.5,

    ['camera_aspect']    = 16.0 / 9.0,
    ['camera_fov_y']     = 40.0,
    ['camera_dist_min']  = 4.0,
    ['camera_dist_max']  = 4.5,
    ['camera_roll']      = 15.0,
    ['camera_dof_coeff'] = 2.5,

    ['command_multi_check_time']          = 1,
    ['command_quick_standing_check_time'] = 6,
    ['command_reversal_precede_time']     = 3,

    ['action_reversal_time']         = 1,
    ['action_throw_invincible_time'] = 3,
    ['action_guard_impossible_time'] = 3,

    ['system_assault_time_min'] = 60 * 3,
    ['system_assault_time_max'] = 60 * 5,
    ['system_assault_time_ext'] = 60 * 0,

    ['system_pandora_vital_rate']      = 0.25,
    ['system_pandora_time']            = 60 * 7,
    ['system_pandora_attack_rate_min'] = 0.125,
    ['system_pandora_attack_rate_max'] = 0.15,

    ['system_cancel_change_special'] = 400,
    ['system_quick_combo_special']   = 400,
    
    ['ai_arcade_lv_revises']	= {-1, -1, 0, 1, 0, 0, 1, 1, 2,},
};

battle_config_v5 = {
    ['region_dist_x'] = 2.5,
    ['region_dist_y'] = 2.5,

    ['camera_aspect']    = 16.0 / 9.0,
    ['camera_fov_y']     = 40.0,
    ['camera_dist_min']  = 4.0,
    ['camera_dist_max']  = 4.5,
    ['camera_roll']      = 15.0,
    ['camera_dof_coeff'] = 2.5,

    ['command_multi_check_time']          = 1,
    ['command_quick_standing_check_time'] = 6,
    ['command_reversal_precede_time']     = 3,

    ['action_reversal_time']         = 1,
    ['action_throw_invincible_time'] = 3,
    ['action_guard_impossible_time'] = 3,

    ['system_assault_time_min'] = 60 * 3,
    ['system_assault_time_max'] = 60 * 5,
    ['system_assault_time_ext'] = 60 * 0,

    ['system_pandora_vital_rate']      = 0.25,
    ['system_pandora_time']            = 60 * 10,
    ['system_pandora_attack_rate_min'] = 0.15,
    ['system_pandora_attack_rate_max'] = 0.15,

    ['system_cancel_change_special'] = 400,
    ['system_quick_combo_special']   = 400,
    
    ['ai_arcade_lv_revises']	= {-1, -1, 0, 1, 0, 0, 1, 1, 2,},
    
    ['system_recovery_frames_per_vital'] = 12,
};

sound_config = {
    ['memory_voice_max'] = 64,
    ['stream_voice_max'] = 12,
    ['master_volume']    = 5.0,
    ['movie_volume']     = 1.25,
};

