require("recipe")

local MakePlayerCharacter = require "prefabs/player_common"
--[[
local attack_name = {"bee", "killerbee", "flies", "mosquito", "frog", "beefalo", "lightninggoat", "pigman", "pigguard",
 "bunnyman", "merm", "spider_hider", "spider_spitter", "spider", "spider_warrior", "spiderqueen", "spider_dropper", "hound",
 "firehound", "icehound", "tentacle", "leif", "leif_sparse", "walrus", "teenbird", "tallbird", "koalefant_summer",
 "koalefant_winDter", "penguin", "slurtle", "snurtle", "bat", "rocky", "monkey", "slurper", "buzzard", "knight", "bishop",
 "rook", "crawlinghorror", "terrorbeak", "deerclops", "minotaur", "worm", "abigail", "ghost", "shadowwaxwell", "krampus",
 "glommer", "lureplant", "eyeplant", "moose", "mossling", "dragonfly", "warg", "bearger", "birchnutdrake"
}
]]
local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/yasuo.zip" ),
}
local prefabs = {}

local start_inv =
{
        "log",
        "log",
        "log",
        "log",
}

local max_upgrades = 15
local function applyupgrades(inst)

        
        local upgrades = math.min(inst.level, max_upgrades)

        local hunger_percent = inst.components.hunger:GetPercent()
        local health_percent = inst.components.health:GetPercent()
        local sanity_percent = inst.components.sanity:GetPercent()

        inst.components.hunger.max = math.ceil (90 + upgrades * 4)
        inst.components.health.maxhealth = math.ceil (60 + upgrades * 2)
        inst.components.sanity.max = math.ceil (90 + upgrades * 2)
        inst.components.locomotor.walkspeed =  math.ceil (4 * (upgrades/100+1.05))
        inst.components.locomotor.runspeed = math.ceil (6 * (upgrades/100+1.05))        
       
        if inst.components.combat.attack_damage_modifiers then
        inst.components.combat.attack_damage_modifiers[1] = (upgrades/100*4/3)
        else
        inst.components.combat.damagemultiplier = (1 * (upgrades/100*2+0.9))
        end
        inst.components.talker:Say("Wind Up! : ".. (inst.level))
         
        if inst.level > 14 then
                inst.components.talker:Say("Wind : Max!")
        end
--3级回复生命值
        if inst.level > 2 then
        inst.components.health:StartRegen((60 + upgrades * 4)*0.1/16, 30) 
        end
--5级回复精神值
        if inst.level > 4 then        
        TUNING.SANITY_DAY_GAIN=(60 + upgrades * 4)*0.1/480--100/(day_time*32),
        
        TUNING.SANITY_NIGHT_LIGHT=-100/(60*20)+(60 + upgrades * 4)*0.1/480
        TUNING.SANITY_NIGHT_MID=-100/(60*20)+(60 + upgrades * 4)*0.1/480
        TUNING.SANITY_NIGHT_DARK=-100/(60*2)+(60 + upgrades * 4)*0.1/480
        end
--[[        
        if inst.level > 1 then
           
local function onattack(inst,data)   

  if not inst.active  then
      if not inst:HasTag("forcefield") then
          inst:AddTag("forcefield")
      end
        local player = GetPlayer()
        inst.active = true   
        --player:DoTaskInTime(5, function()
            if inst:IsValid() then
                inst:RemoveTag("forcefield")
                player:DoTaskInTime(15, function() inst.active = false end)
            end
        --end)   
    end 
end
        inst:ListenForEvent("onattackother", onattack)
       end
]] 

        inst.components.hunger:SetPercent(hunger_percent)
        inst.components.health:SetPercent(health_percent)
        inst.components.sanity:SetPercent(sanity_percent)
end






--[[   
local function TornadoFn(inst)

    if inst:HasTag("playerghost")
      then return end
    if inst.level < 15 
      then return end

    if inst.transformed then
    inst.AnimState:SetBuild("yasuo")
    inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/catcoon/pounce")
    inst.components.locomotor.walkspeed = (4 * 1.25)
    inst.components.locomotor.runspeed = (6 * 1.25)
    inst.components.health.absorb = 0
    inst.components.combat.damagemultiplier = 1.2
    else
    inst.AnimState:SetBuild("yasuo")
    inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/catcoon/pounce")
    inst.components.locomotor.walkspeed = 4
    inst.components.locomotor.runspeed = 6
    inst.components.health.absorb = 0.20
    inst.components.combat.damagemultiplier = 1.5
    end

    inst.transformed = not inst.transformed
-- inst.components.health:SetCurrentHealth(1)
-- inst.components.health:DoDelta(0)
    return true 
end

AddModRPCHandler("yasuo", "freezetime", TornadoFn)

]] 







local function onkill(inst, data)
    local chance1 = 1    
    local chance2 = 0.05
    local iflevelup = false
    if data.cause == inst.prefab and not data.inst:HasTag("companion") then
        if math.random() < chance1
            and data.inst:HasTag("moose") 
            or data.inst:HasTag("dragonfly")
            or data.inst:HasTag("bearger")
            or data.inst:HasTag("deerclops") 
            then
            iflevelup = true
        elseif math.random() < chance2 
            and not data.inst:HasTag("insect") 
            and not data.inst:HasTag("eyeplant") 
            then
            iflevelup = true
        end
    end

    if iflevelup and inst.level < max_upgrades then
        inst.level = inst.level + 1
        applyupgrades(inst) 

        inst.components.sanity:DoDelta(inst.components.sanity.max*0.2)
        inst.components.health:DoDelta(inst.components.health.maxhealth*0.15)
        inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")

        --icon pulse while upgrading
        inst.HUD.controls.status.heart:PulseGreen()
        inst.HUD.controls.status.stomach:PulseGreen()
        inst.HUD.controls.status.brain:PulseGreen()
            
        inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
    end
end


local function onpreload(inst, data)
        if data then
                if data.level then
                        inst.level = data.level
                        applyupgrades(inst)
                        --re-set these from the save data, because of load-order clipping issues
                        if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
                        if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
                        if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
                        inst.components.health:DoDelta(0)
                        inst.components.hunger:DoDelta(0)
                        inst.components.sanity:DoDelta(0)
                end
        end

end

local function onsave(inst, data)
        data.level = inst.level
end
--[[
local function common_postinit(inst)

        inst.MiniMapEntity:SetIcon( "yasuo.tex" )
        if not inst.components.keyhandler then inst:AddComponent("keyhandler") end
        inst.components.keyhandler:AddActionListener("yasuo", 122, "freezetime") -- [Z]
        
end
]]

local fn = function(inst)
    inst.soundsname = "wolfgang"
    inst.MiniMapEntity:SetIcon( "yasuo.tex" )

        
        inst.level = 0
        applyupgrades(inst)

    -- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 0.9
    
    -- Movement speed (optional)
    inst.components.locomotor.walkspeed = 4.2
    inst.components.locomotor.runspeed = 6.3

    inst.OnSave = onsave
    inst.OnPreLoad = onpreload

    -- lower profit from non-meat food

    inst:ListenForEvent("entity_death", function(wrld, data) onkill(inst, data) end, GetWorld())

    local woodsword = Recipe("woodsword", {Ingredient("log", 4)}, RECIPETABS.WAR, {SCIENCE = 0})
    woodsword.atlas = "images/inventoryimages/woodsword.xml"

    local woodsword = Ingredient( "woodsword", 1)
    woodsword.atlas = "images/inventoryimages/woodsword.xml"

    local bloodsword = Recipe("bloodsword", {woodsword, Ingredient("monstermeat", 4)}, RECIPETABS.WAR, {SCIENCE = 0})
    bloodsword.atlas = "images/inventoryimages/bloodsword.xml"

    local trialsword = Recipe("trialsword", {woodsword, Ingredient("goldnugget", 4)}, RECIPETABS.WAR, {SCIENCE = 0})
    trialsword.atlas = "images/inventoryimages/trialsword.xml"

    local trialsword = Ingredient( "trialsword", 1)
    trialsword.atlas = "images/inventoryimages/trialsword.xml"

    local galesword = Recipe("galesword", {trialsword, Ingredient("livinglog", 4)}, RECIPETABS.WAR, {SCIENCE = 0})
    galesword.atlas = "images/inventoryimages/galesword.xml"

end


return MakePlayerCharacter("yasuo", prefabs, assets, fn, start_inv)
