local assets=
{
    Asset("ANIM", "anim/trialsword.zip"),
    Asset("ANIM", "anim/swap_trialsword.zip"),
  
    Asset("ATLAS", "images/inventoryimages/trialsword.xml"), 
    Asset("IMAGE", "images/inventoryimages/trialsword.tex"),
}

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_trialsword", "swap_lawsword")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end


local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)


    inst.AnimState:SetBank("lawsword")
    inst.AnimState:SetBuild("trialsword")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")
  
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/trialsword.xml"


    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    inst.hasagi = 0
    local function onattack(inst, owner, target)
        inst.hasagi=inst.hasagi +1        
        if inst.hasagi % 3 == 0 then
        target.components.health:DoDelta(-45)
        end
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(35)
    inst:ListenForEvent("onattacker",onattack)
    inst.components.weapon.onattack = onattack
     inst:AddTag("sharp")

 
	
	
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(180)
    inst.components.finiteuses:SetUses(180)
    inst.components.finiteuses:SetOnFinished(inst.Remove)


	return inst
end
	

return Prefab( "common/inventory/trialsword", fn, assets) 
