local assets=
{
    Asset("ANIM", "anim/tornado.zip"),
    Asset("ANIM", "anim/galesword.zip"),
    Asset("ANIM", "anim/swap_galesword.zip"),
  
    Asset("ATLAS", "images/inventoryimages/galesword.xml"), 
    Asset("IMAGE", "images/inventoryimages/galesword.tex"),
}

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_galesword", "swap_lawsword")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end


-------------------------------
--Attack Tornado
-------------------------------

local function doBlindEffect(inst, owner, target)

    local fx = SpawnPrefab("tornado")
    fx.WINDSTAFF_CASTER = owner
    fx.entity:SetParent(target.entity)
    target.blindEffect = fx
end

local function doBlindEffectEndTask(inst, owner, target)
    if target.blindEffectEndTask ~= nil then
        target.blindEffectEndTask:Cancel()
    end
    
    local time = 1.2
  
    target.blindEffectEndTask = target:DoTaskInTime(time, function(target)
        if target.blindEffect ~= nil then
            target.blindEffect:Remove()
            target.blindEffect = nil
        end
    end, target)
    
end

-------------------------------
--Release Tornado & Blink
-------------------------------

local function getspawnlocation(inst, target)
    local tarPos = target:GetPosition()
    local pos = inst:GetPosition()
    local vec = tarPos - pos
    vec = vec:Normalize()
    local dist = pos:Dist(tarPos)
    return pos + (vec * (dist * .15))
end

local function spawntornado(staff, target, pos)
    local sanitycost = 8
    local hungercost = 10
    local pt = target:GetPosition()
    local owner = staff.components.inventoryitem.owner

    if  owner.components.sanity.current > sanitycost
    and owner.components.hunger.current > hungercost
    and not target:HasTag("FARSELECT") 
    and not target:HasTag("structure")
    then       
----施放旋风
    local tornado = SpawnPrefab("tornado")
    tornado.WINDSTAFF_CASTER = staff.components.inventoryitem.owner
    local spawnPos = staff:GetPosition() + TheCamera:GetDownVec()
    local totalRadius = target.Physics and target.Physics:GetRadius() or 0.5 + tornado.Physics:GetRadius() + 0.5
    local targetPos = target:GetPosition() + (TheCamera:GetDownVec() * totalRadius)
    tornado.Transform:SetPosition(getspawnlocation(staff, target):Get())
    tornado.components.knownlocations:RememberLocation("target", targetPos)
    
----传送
    owner:DoTaskInTime(1.5, function() owner.Transform:SetPosition(pt.x, pt.y, pt.z) end )

----消耗

    owner.components.sanity:DoDelta(-sanitycost)
    owner.components.hunger:DoDelta(-hungercost)    
    else
        owner.components.talker:Say("I'm too stupid", 1, true)   
    end
 
end




local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)


    inst.AnimState:SetBank("lawsword")
    inst.AnimState:SetBuild("galesword")
    inst.AnimState:PlayAnimation("idle")
    --inst.AnimState:PlayAnimation("tornado_pre")
    --inst.AnimState:PushAnimation("tornado_loop")

    inst:AddComponent("inspectable")
    
    inst:AddComponent("spellcaster")
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster.canusefrominventory = false

    inst.components.spellcaster:SetSpellFn(spawntornado)
    inst.components.spellcaster.castingstate = "castspell_tornado"
    inst.components.spellcaster.actiontype = "SCIENCE"
    TUNING.TORNADO_LIFETIME=1.1 

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "galesword"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/galesword.xml"


	inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    inst.components.equippable.walkspeedmult = 1.05
	

    inst.hasagi = 0
    local function onattack(inst, owner, target)

        inst.hasagi=inst.hasagi +1        
        if inst.hasagi % 3 == 0 then
        owner.components.sanity:DoDelta(2)
            if target.blindEffect ~= nil then
                doBlindEffectEndTask(inst, owner, target)
            return
            end
        doBlindEffect(inst, owner, target)
        doBlindEffectEndTask(inst, owner, target)
        owner.components.temperature:DoDelta(-1)
        end
    end

	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(35)
    inst:ListenForEvent("onattacker",onattack)
    inst.components.weapon:SetOnAttack(onattack)

	inst:AddTag("sharp")



	return inst
end
	

return Prefab( "common/inventory/galesword", fn, assets) 
