
local assets=
{
    Asset("ANIM", "anim/bloodsword.zip"),
    Asset("ANIM", "anim/swap_bloodsword.zip"),
  
    Asset("ATLAS", "images/inventoryimages/bloodsword.xml"), 
    Asset("IMAGE", "images/inventoryimages/bloodsword.tex"),
}

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_bloodsword", "swap_lawsword")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal")
        owner.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1.5) 
    end

    local function onunequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
        owner.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)
    end



local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)


    inst.AnimState:SetBank("lawsword")
    inst.AnimState:SetBuild("bloodsword")
    inst.AnimState:PlayAnimation("idle")

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/bloodsword.xml"


	inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
    inst.hasagi = 0
    local function onattack(inst, owner, target)
        if owner.components.health and owner.components.health:GetPercent() < 1 and not target:HasTag("wall") then
           owner.components.health:DoDelta(0.2)
        end
        inst.hasagi=inst.hasagi +1        
        if inst.hasagi % 3 == 0 then
        owner.components.temperature:DoDelta(2)
        end
    end

	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(45)
    inst:ListenForEvent("onattacker",onattack)
    inst.components.weapon:SetOnAttack(onattack)
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(100)
    inst.components.finiteuses:SetUses(100)
    inst.components.finiteuses:SetOnFinished(inst.Remove)

	inst:AddTag("sharp")



	return inst
end
	

return Prefab( "common/inventory/bloodsword", fn, assets) 
