
local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
local TECH = GLOBAL.TECH

PrefabFiles = {
	"yasuo",
        "woodsword",
        "trialsword",
        "galesword",
        "bloodsword",
}

local attack_name = {"bee", "killerbee", "flies", "mosquito", "frog", "beefalo", "lightninggoat", "pigman", "pigguard",
 "bunnyman", "merm", "spider_hider", "spider_spitter", "spider", "spider_warrior", "spiderqueen", "spider_dropper", "hound",
 "firehound", "icehound", "tentacle", "leif", "leif_sparse", "walrus", "teenbird", "tallbird", "koalefant_summer",
 "koalefant_winDter", "penguin", "slurtle", "snurtle", "bat", "rocky", "monkey", "slurper", "buzzard", "knight", "bishop",
 "rook", "crawlinghorror", "terrorbeak", "deerclops", "minotaur", "worm", "abigail", "ghost", "shadowwaxwell", "krampus",
 "glommer", "lureplant", "eyeplant", "moose", "mossling", "dragonfly", "warg", "bearger", "birchnutdrake"
}



Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/yasuo.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/yasuo.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/yasuo.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/yasuo.xml" ),

    Asset( "IMAGE", "bigportraits/yasuo.tex" ),
    Asset( "ATLAS", "bigportraits/yasuo.xml" ),
    
    Asset( "IMAGE", "images/map_icons/yasuo.tex" ),
    Asset( "ATLAS", "images/map_icons/yasuo.xml" ),
    	
    Asset( "IMAGE", "images/avatars/avatar_yasuo.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_yasuo.xml" ),

    Asset("IMAGE", "images/inventoryimages/woodsword.tex"),
    Asset("ATLAS", "images/inventoryimages/woodsword.xml"),

    Asset("IMAGE", "images/inventoryimages/trialsword.tex"),
    Asset("ATLAS", "images/inventoryimages/trialsword.xml"),

    Asset("IMAGE", "images/inventoryimages/galesword.tex"),
    Asset("ATLAS", "images/inventoryimages/galesword.xml"),
    
    Asset("IMAGE", "images/inventoryimages/bloodsword.tex"),
    Asset("ATLAS", "images/inventoryimages/bloodsword.xml"),

}


GLOBAL.STRINGS.NAMES.WOODSWORD = "WoodSword"
GLOBAL.STRINGS.RECIPE_DESC.WOODSWORD = "A legendary sword!"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.WOODSWORD = "WoodSword"

GLOBAL.STRINGS.NAMES.TRIALSWORD = "TrialSword"
GLOBAL.STRINGS.RECIPE_DESC.TRIALSWORD = "An mysterious sword"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TRIALSWORD = "TrialSword"

GLOBAL.STRINGS.NAMES.GALESWORD = "Galesword"
GLOBAL.STRINGS.RECIPE_DESC.GALESWORD = "Fast Wind"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.GALESWORD = "Galesword"

GLOBAL.STRINGS.NAMES.BLOODSWORD = "Bloodsword"
GLOBAL.STRINGS.RECIPE_DESC.BLOODSWORD = "My sword is Hungry"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.BLOODSWORD = "Bloodsword"


GLOBAL.STRINGS.CHARACTER_TITLES.yasuo = "Yasuo"
GLOBAL.STRINGS.CHARACTER_NAMES.yasuo = "Yasuo"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.yasuo = "*Fast-but-easy-to-die \n*An-amazing-sword\n*Sword-can-be-hided"
GLOBAL.STRINGS.CHARACTER_QUOTES.yasuo = "\"Death is like the wind; always by my side\""

function AddMap(inst)
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( inst.prefab .. ".tex" )
end
AddPrefabPostInit("woodsword", AddMap)
AddMinimapAtlas("images/inventoryimages/woodsword.xml")
AddPrefabPostInit("trialsword", AddMap)
AddMinimapAtlas("images/inventoryimages/trialsword.xml")
AddPrefabPostInit("galesword", AddMap)
AddMinimapAtlas("images/inventoryimages/galesword.xml")
AddPrefabPostInit("bloodsword", AddMap)
AddMinimapAtlas("images/inventoryimages/bloodsword.xml")

table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "yasuo")
AddMinimapAtlas("images/map_icons/yasuo.xml")
AddModCharacter("yasuo")

--每15秒可以抵消一次25点以内伤害
local GetPlayer = GLOBAL.GetPlayer
local cooldowntime = 15
local tdamage = 25
local function onattack(inst, data)
  if data.target.prefab == "yasuo" 
  and not inst.cooldown then
  inst.cooldown = true

  if tdamage > inst.components.combat.tempdamage then
     inst.components.combat:SetDefaultDamage(0)
  elseif tdamage > 0 then
     inst.components.combat:SetDefaultDamage(inst.components.combat.tempdamage-tdamage)
   else
     inst.components.combat:SetDefaultDamage(inst.components.combat.tempdamage) 
  end
tdamage = tdamage - inst.components.combat.tempdamage
    

    local fx = GLOBAL.SpawnPrefab("forcefieldfx")
    fx.entity:SetParent(GetPlayer().entity)
    fx.Transform:SetPosition(0, 0, 0)
    fx.AnimState:PlayAnimation("hit",true)
    fx.AnimState:PushAnimation("idle_loop")

    GetPlayer():DoTaskInTime( cooldowntime, function() 
        inst.cooldown = false 
        tdamage = 25
        fx.kill_fx(fx)
        end)

  else
  inst.components.combat:SetDefaultDamage(inst.components.combat.tempdamage)
  end
end
--技能基础函数
local function dodge(inst)
    if GetPlayer().prefab == "yasuo" 
        and inst.components.combat then
        inst.components.combat.tempdamage = inst.components.combat.defaultdamage
        inst:ListenForEvent("onattackother", onattack)
    end
end

--为列表上的生物攻击变为0


for k,v in pairs(attack_name) do
    AddPrefabPostInit (v, dodge)
end
