PrefabFiles = {
	"storeroom",
}

Assets = 
{
	Asset("ATLAS", "minimap/storeroom.xml"),
	Asset("ATLAS", "images/inventoryimages/storeroom.xml"),
}

STRINGS = GLOBAL.STRINGS
RECIPETABS = GLOBAL.RECIPETABS
Recipe = GLOBAL.Recipe
Ingredient = GLOBAL.Ingredient
TECH = GLOBAL.TECH
Vector3 = GLOBAL.Vector3
IsDLCEnabled = GLOBAL.IsDLCEnabled
RoG = GLOBAL.REIGN_OF_GIANTS
SW = GLOBAL.CAPY_DLC

local mod_slots = GetModConfigData("Slots")
local mod_craft = GetModConfigData("Craft")
local sw_DLC = IsDLCEnabled(SW)


-- MAP ICONS --

AddMinimapAtlas("minimap/storeroom.xml")

-- STRINGS --

STRINGS.NAMES.STOREROOM = "Storeroom"
STRINGS.RECIPE_DESC.STOREROOM = "Need more space!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.STOREROOM = "I really like this is a great storeroom!"

-- RECIPES --

local function modrecipe(mod_slots)

	if mod_craft=="Easy" then
		cutstone_value = math.floor(mod_slots / 7)
		boards_value = math.floor(mod_slots / 7)
		limestone_value = math.floor(mod_slots / 20)
		marble_value = math.floor(mod_slots / 20)
	elseif mod_craft=="Hard" then
		cutstone_value = math.floor(mod_slots / 2.6)
		boards_value = math.floor(mod_slots / 2.6)
		limestone_value = math.floor(mod_slots / 8)
		marble_value = math.floor(mod_slots / 10)
	else
		cutstone_value = math.floor(mod_slots / 4)
		boards_value = math.floor(mod_slots / 4)
		limestone_value = math.floor(mod_slots / 16)
		marble_value = math.floor(mod_slots / 20)
	end

end
modrecipe(mod_slots)

if sw_DLC == true then
	storeroom0 = Recipe("storeroom",{ Ingredient("cutstone", cutstone_value), Ingredient("limestone", limestone_value), Ingredient("boards", boards_value) }, RECIPETABS.TOWN, TECH.SCIENCE_TWO, GLOBAL.RECIPE_GAME_TYPE.COMMON, "storeroom_placer")
	storeroom1 = Recipe("storeroom",{ Ingredient("cutstone", cutstone_value), Ingredient("marble", marble_value), Ingredient("boards", boards_value) }, RECIPETABS.TOWN, TECH.SCIENCE_TWO, GLOBAL.RECIPE_GAME_TYPE.ROG, "storeroom_placer")
	storeroom2 = Recipe("storeroom",{ Ingredient("cutstone", cutstone_value), Ingredient("marble", marble_value), Ingredient("boards", boards_value) }, RECIPETABS.TOWN, TECH.SCIENCE_TWO, GLOBAL.RECIPE_GAME_TYPE.VANILLA, "storeroom_placer")
	
	storeroom0.atlas = "images/inventoryimages/storeroom.xml"
	storeroom1.atlas = "images/inventoryimages/storeroom.xml"
	storeroom2.atlas = "images/inventoryimages/storeroom.xml"
else
	storeroom0 = Recipe("storeroom",{ Ingredient("cutstone", cutstone_value), Ingredient("marble", marble_value), Ingredient("boards", boards_value) }, RECIPETABS.TOWN, TECH.SCIENCE_TWO, "storeroom_placer")
	storeroom0.atlas = "images/inventoryimages/storeroom.xml"
end

-- CONTAINER --

AddPrefabPostInit("storeroom", function(inst)
    
	if GetModConfigData("Position")==("Left") then
		inst.components.container.widgetpos = Vector3(-210,230,0)
	elseif GetModConfigData("Position")==("Center") then
		inst.components.container.widgetpos = Vector3(0,190,0)
	end
	
	--set the background of the inventory slots
	if mod_slots == 20 then
		inst.components.container.widgetanimbank = "ui_chest_4x5"
		inst.components.container.widgetanimbuild = "ui_chest_4x5"
	elseif mod_slots == 40 then
		inst.components.container.widgetanimbank = "ui_chest_5x8"
		inst.components.container.widgetanimbuild = "ui_chest_5x8"
	elseif mod_slots == 60 then
		inst.components.container.widgetanimbank = "ui_chest_5x12"
		inst.components.container.widgetanimbuild = "ui_chest_5x12"
	else
		inst.components.container.widgetanimbank = "ui_chest_5x16"
		inst.components.container.widgetanimbuild = "ui_chest_5x16"
	end
	
	--create the inventory slots
	local slotpos = {}
	if mod_slots == 20 then
		for y = 3, 0, -1 do
			for x = 0, 4 do
				table.insert(slotpos, Vector3(80*x-346*2+90, 80*y-100*2+130,0))
			end
		end
	elseif mod_slots == 40 then
		for y = 4, 0, -1 do
			for x = 0, 7 do
				table.insert(slotpos, Vector3(80*x-346*2+109, 80*y-100*2+42,0))
			end
		end
	elseif mod_slots == 60 then
		for y = 4, 0, -1 do
			for x = 0, 11 do
				table.insert(slotpos, Vector3(80*x-346*2+98, 80*y-100*2+42,0))
			end
		end
	else
		for y = 4, 0, -1 do
			for x = 0, 15 do
				table.insert(slotpos, Vector3(80*x-346*2+91, 80*y-100*2+42,0))
			end
		end
	end
	
    inst.components.container:SetNumSlots(#slotpos)
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.side_align_tip = 160
	
end)

-- ON OPEN/CLOSED --

local function onOpen(inst)
	inst.AnimState:PlayAnimation("open")
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")
end 

local function onClose(inst)
	inst.AnimState:PlayAnimation("closed")
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")
end

AddPrefabPostInit("storeroom", function(inst)
    inst.components.container.onopenfn = onOpen
    inst.components.container.onclosefn = onClose
end)