local assets=
{
	Asset("ANIM", "anim/tentaclespots.zip"),
}

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("tentaclespots")
    anim:SetBuild("tentaclespots")
    anim:PlayAnimation("idle")
    
    inst:AddComponent("inspectable")
local function spa(inst)
    local pt = inst:GetPosition()
    local spa = SpawnPrefab("tentaclespots")
    spa.Transform:SetPosition(pt.x, pt.y, pt.z)
    spa.AnimState:SetBank("marsh_tile")
    spa.AnimState:SetBuild("marsh_tile")
    spa.AnimState:PlayAnimation("idle_cave",true)
    spa.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
    spa.AnimState:SetLayer( LAYER_BACKGROUND )
    spa.AnimState:SetSortOrder( 3 )
    spa.Transform:SetScale(1.5, 1.5, 1.5)
    spa:RemoveComponent("inventoryitem")
    spa:RemoveComponent("stackable")
    spa:RemoveComponent("fuel")
    spa:RemoveComponent("burnable")
    spa:RemoveComponent("propagator")
    spa:RemoveComponent("deployable")
    if spa.components.edible then spa:RemoveComponent("edible") end
    spa:AddTag("NOCLICK")
    spa:AddTag("spa")
    spa:AddComponent("heater")
    spa.components.heater.heat = 180
    spa:DoPeriodicTask(math.random(10,20), function(spa)
        local pt1 = spa:GetPosition()
        local names = {"fish","eel"}
        local name = names[math.random(#names)]
        local fish = SpawnPrefab(name)
        fish.Transform:SetPosition(pt1.x+(math.random(4)-math.random(4)), 0, pt1.z+(math.random(4)-math.random(4)))
        SpawnPrefab("splash").Transform:SetPosition(fish.Transform:GetWorldPosition())
        spa:DoTaskInTime(0.5, function(spa)
            local pos = Vector3(spa.Transform:GetWorldPosition())
            local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 5)
            for k,v in pairs(ents) do
                if v.components.inventoryitem and not v.components.inventoryitem:IsHeld() then
                   if v.prefab == "fish" or v.prefab == "eel" then
                      SpawnPrefab("splash").Transform:SetPosition(v.Transform:GetWorldPosition())
                      v:Remove()
                   end
                end
            end
        end )
    end )
    spa:DoPeriodicTask(3, function(spa)
        local pos2 = Vector3(spa.Transform:GetWorldPosition())
        local ents = TheSim:FindEntities(pos2.x,pos2.y,pos2.z, 4.8)
        for k,v in pairs(ents) do
            if v:HasTag("player") then
               v.components.health:DoDelta(v.components.health.maxhealth*.02)
               v.components.sanity:DoDelta(v.components.sanity.max*.02)
            end
        end
    end )
    local rock1 = SpawnPrefab("tentaclespots")
    rock1.Transform:SetPosition(pt.x-3.3-0.5, 0, pt.z-3.3+0.5)
    rock1.AnimState:SetBank("rock")
    rock1.AnimState:SetBuild("rock")
    rock1.AnimState:PlayAnimation("full")
    rock1.Transform:SetScale(2, 2, 2)
    rock1:AddTag("sparock")
    rock1:RemoveComponent("inventoryitem")
    rock1:RemoveComponent("stackable")
    rock1:RemoveComponent("fuel")
    rock1:RemoveComponent("burnable")
    rock1:RemoveComponent("propagator")
    rock1:RemoveComponent("deployable")
    if rock1.components.edible then rock1:RemoveComponent("edible") end
    rock1:AddComponent("workable")
    rock1.components.workable:SetWorkAction(ACTIONS.HAMMER)
    rock1.components.workable:SetWorkLeft(3)
    rock1.components.workable:SetOnFinishCallback(function(rock1)
        SpawnPrefab("collapse_big").Transform:SetPosition(rock1.Transform:GetWorldPosition())
        GetPlayer().SoundEmitter:PlaySound("dontstarve/wilson/rock_break")
        local pos3 = Vector3(rock1.Transform:GetWorldPosition())
        local ents = TheSim:FindEntities(pos3.x,pos3.y,pos3.z, 10)
        for k,v in pairs(ents) do
            if v:HasTag("spa") then
               v:Remove()
            end
            if v:HasTag("sparock") then
               v:Remove()
            end
        end
        rock1:Remove()
    end )
    local rock2 = SpawnPrefab("tentaclespots")
    rock2.Transform:SetPosition(pt.x-2.1-2.8, 0, pt.z-2.1+2.8)
    rock2.AnimState:SetBank("firepit")
    rock2.AnimState:SetBuild("firepit")
    rock2.AnimState:PlayAnimation("idle",false)
    rock2.Transform:SetScale(0.6, 1, 0.6)
    rock2:AddTag("sparock")
    rock2:RemoveComponent("inventoryitem")
    rock2:RemoveComponent("stackable")
    rock2:RemoveComponent("fuel")
    rock2:RemoveComponent("burnable")
    rock2:RemoveComponent("propagator")
    rock2:RemoveComponent("deployable")
    if rock2.components.edible then rock2:RemoveComponent("edible") end
    rock2:AddComponent("burnable")
    rock2.components.burnable:SetFXLevel(5)
    rock2.components.burnable:AddBurnFX("campfirefire", Vector3(0,0.6,0) )
    rock2.components.burnable:Ignite(true)
    rock2:AddComponent("cooker")
    local rock3 = SpawnPrefab("tentaclespots")
    rock3.Transform:SetPosition(pt.x+2.1+2.1, 0, pt.z-2.1+2.1)
    rock3.AnimState:SetBank("flowers")
    rock3.AnimState:SetBuild("flowers")
    rock3.AnimState:PlayAnimation("f10")
    rock3.Transform:SetScale(1.8, 1.8, 1.8)
    rock3:AddTag("sparock")
    rock3:RemoveComponent("inventoryitem")
    rock3:RemoveComponent("stackable")
    rock3:RemoveComponent("fuel")
    rock3:RemoveComponent("burnable")
    rock3:RemoveComponent("propagator")
    rock3:RemoveComponent("deployable")
    if rock3.components.edible then rock3:RemoveComponent("edible") end
end
local function OnDeploy (inst, pt)
    spa(inst)
    inst.components.stackable:Get():Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
local function onsave(inst, data)
    if inst:HasTag("spa") then
        data.spa = true
    end
    if inst:HasTag("sparock") then
        data.sparock = true
    end
end
local function onload(inst, data)
    if data and data.spa then
       spa(inst)
       inst:Remove()
    end
    if data and data.sparock then
       inst:Remove()
    end
end
    inst.OnSave = onsave
    inst.OnLoad = onload
    inst:AddComponent("inventoryitem")
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.SMALL_FUEL
    
	MakeSmallBurnable(inst, TUNING.SMALL_BURNTIME)
    MakeSmallPropagator(inst)
    
    
    return inst
end

return Prefab( "common/inventory/tentaclespots", fn, assets) 
