local assets=
{ 
    Asset("ANIM", "anim/lucasstick.zip"),
    Asset("ANIM", "anim/swap_lucasstick.zip"), 

    Asset("ATLAS", "images/inventoryimages/lucasstick.xml"),
    Asset("IMAGE", "images/inventoryimages/lucasstick.tex"),
}

local prefabs = 
{
}

    local function OnEquip(inst, owner) 
        --owner.AnimState:OverrideSymbol("swap_object", "swap_lucasstick", "purplestaff")
        owner.AnimState:OverrideSymbol("swap_object", "swap_lucasstick", "lucasstick")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end
	
local function fn()
	
    local inst = CreateEntity()
	
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
	
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("lucasstick")
    inst.AnimState:SetBuild("lucasstick")
    inst.AnimState:PlayAnimation("idle")

	inst:AddTag("sharp")
    inst:AddTag("pointy")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()	
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(35)

	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.SPEAR_USES)
    inst.components.finiteuses:SetUses(TUNING.SPEAR_USES)

    inst.components.finiteuses:SetOnFinished(inst.Remove)

	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "lucasstick"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lucasstick.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )

    return inst
end

return  Prefab("common/inventory/lucasstick", fn, assets, prefabs)