local assets=
{ 
    Asset("ANIM", "anim/lucasrealbat.zip"),
    Asset("ANIM", "anim/swap_lucasrealbat.zip"), 

    Asset("ATLAS", "images/inventoryimages/lucasrealbat.xml"),
    Asset("IMAGE", "images/inventoryimages/lucasrealbat.tex"),
}

local prefabs = 
{
}

    local function OnEquip(inst, owner) 
        --owner.AnimState:OverrideSymbol("swap_object", "swap_lucasrealbats", "purplestaff")
        owner.AnimState:OverrideSymbol("swap_object", "swap_lucasrealbat", "lucasrealbat")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end

local function fn()
	
    local inst = CreateEntity()
	
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
	
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("lucasrealbat")
    inst.AnimState:SetBuild("lucasrealbat")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")
    inst:AddTag("pointy")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(100)

	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(200)
    inst.components.finiteuses:SetUses(200)

    inst.components.finiteuses:SetOnFinished(inst.Remove)

	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "lucasrealbat"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lucasrealbat.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )

    return inst
end

return  Prefab("common/inventory/lucasrealbat", fn, assets, prefabs)