PrefabFiles = {
	"lucas", "lucas_none", "lucasrealbat", "lucasstick"
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/lucas.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/lucas.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/lucas.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/lucas.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/lucas_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/lucas_silho.xml" ),

    Asset( "IMAGE", "bigportraits/lucas.tex" ),
    Asset( "ATLAS", "bigportraits/lucas.xml" ),
	
	Asset( "IMAGE", "images/map_icons/lucas.tex" ),
	Asset( "ATLAS", "images/map_icons/lucas.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_lucas.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_lucas.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_lucas.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_lucas.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_lucas.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_lucas.xml" ),
	
	Asset( "IMAGE", "images/names_lucas.tex" ),
    Asset( "ATLAS", "images/names_lucas.xml" ),
	
    Asset( "IMAGE", "bigportraits/lucas_none.tex" ),
    Asset( "ATLAS", "bigportraits/lucas_none.xml" ),

	Asset( "ATLAS", "images/hud/lucastab.xml" ),
	Asset( "IMAGE", "images/hud/lucastab.tex" ),

}

local COOK = GLOBAL.ACTIONS.COOK
local old_cook_fn = COOK.fn
GLOBAL.STRINGS.NAMES.LUCASREALBAT= "Real Bat"
GLOBAL.STRINGS.NAMES.LUCASSTICK= "Stick"
local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local resolvefilepath = GLOBAL.resolvefilepath

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local TECH = GLOBAL.TECH

COOK.fn = function(act, ...)
    local result = old_cook_fn(act)
    local stewer = act.target.components.stewer
    if result and stewer ~= nil and act.doer.prefab == "lucas" then
        local fn = stewer.task.fn
        stewer.task:Cancel()
        fn(act.target, stewer)
    end
end

AddPrefabPostInit("cookpot", function(inst)
    if inst.components.stewer == nil then
        return
    end
    -- using the same harvest logic and repeat the item giving step once
    local old_harvest = inst.components.stewer.Harvest
    inst.components.stewer.Harvest = function(self, harvester)
        if harvester and harvester.prefab == "lucas" then
            if self.done and self.product and harvester.components.inventory then
                local loot = GLOBAL.SpawnPrefab(self.product)
                if loot ~= nil then
                    if self.spoiltime ~= nil and loot.components.perishable ~= nil then
                        local spoilpercent = self:GetTimeToSpoil() / self.spoiltime
                        loot.components.perishable:SetPercent(self.product_spoilage * spoilpercent)
                        loot.components.perishable:StartPerishing()
                    end
                    harvester.components.inventory:GiveItem(loot, nil, self.inst:GetPosition())
                end
            end
        end
        return old_harvest(self, harvester)
    end
end)


local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS


--Lucas' Tab

local lucastab = AddRecipeTab( "Lucas' Tab", 999, "images/hud/lucastab.xml", "lucastab.tex", "lucas_builder")

AddRecipe("lucasstick", 
{GLOBAL.Ingredient("twigs",10), GLOBAL.Ingredient("rope", 1)}, 
lucastab, TECH.NONE, nil, nil, nil, nil, "lucas_builder", 
"images/inventoryimages/lucasstick.xml", "lucasstick.tex" )

AddRecipe("lucasrealbat", 
{GLOBAL.Ingredient("redgem",1), GLOBAL.Ingredient("nightmarefuel", 2), GLOBAL.Ingredient("goldnugget", 1), GLOBAL.Ingredient("cutstone",3)}, 
lucastab, TECH.NONE, nil, nil, nil, nil, "lucas_builder", 
"images/inventoryimages/lucasrealbat.xml", "lucasrealbat.tex" )


-- Custom Recipe Desc
STRINGS.RECIPE_DESC.LUCASREALBAT = "A bat that brims with mystery and courage." 
STRINGS.RECIPE_DESC.LUCASSTICK = "	An undeniably plain stick." 
-- The character select screen lines
STRINGS.CHARACTER_TITLES.lucas = "The younger twin brother. A gentle boy."
STRINGS.CHARACTER_NAMES.lucas = "lucas"
STRINGS.CHARACTER_DESCRIPTIONS.lucas = "*A good(cooking)support \n*A hungry growing boy\n*Starts with a stick and favorite food"
STRINGS.CHARACTER_QUOTES.lucas = "\"...\""

-- Custom speech strings
STRINGS.CHARACTERS.LUCAS = require "speech_lucas"

-- The character's name as appears in-game 
STRINGS.NAMES.LUCAS = "Lucas"

AddMinimapAtlas("images/map_icons/lucas.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("lucas", "MALE")

