PrefabFiles = {
	"asriel",
	"asriel_skins",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/asriel.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/asriel.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/asriel.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/asriel.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/asriel dreemur_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/asriel dreemur_silho.xml" ),

    Asset( "IMAGE", "bigportraits/asriel.tex" ),
    Asset( "ATLAS", "bigportraits/asriel.xml" ),
	
	Asset( "IMAGE", "images/map_icons/asriel.tex" ),
	Asset( "ATLAS", "images/map_icons/asriel.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_asriel.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_asriel.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_asriel.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_asriel.xml" ),

	Asset( "SOUNDPACKAGE", "sound/asriel.fev" ),
    Asset( "SOUND", "sound/asriel.fsb" ),
}
local ImageAssets = {
	{ --Avatars
		"avatar_asriel",
		"avatar_asriel_1",
		"avatar_ghost_asriel",
		"avatar_ghost_asriel_1", 
		"self_inspect_asriel",
		
		"avatar_asriel_formal",
		"avatar_asriel_formal_1",
		"avatar_ghost_asriel_formal",
		"avatar_ghost_asriel_formal_1",
		"self_inspect_asriel_formal",
	},
	{ --Minimap
		"asriel",
	},
	{ --BigPortraits
		"asriel",
		"asriel_none",
		"asriel_formal",
		--"asriel_survivor",
		--"asriel_shadow",
		--"asriel_rose",
		--"asriel_bunnyman",
		--"asriel_spookymovie",
	}
}

local filetypes = {
	{"IMAGE", ".tex"},
	{"ATLAS", ".xml"},
	"images/",
	"images/inventoryimages/",
	"images/avatars/",
	"images/minimap/",
	"bigportraits/"
}
 
RemapSoundEvent( "dontstarve/characters/asriel/death_voice", "asriel/characters/asriel/death_voice" )
RemapSoundEvent( "dontstarve/characters/asriel/hurt", "asriel/characters/asriel/hurt" )
RemapSoundEvent( "dontstarve/characters/asriel/talk_LP", "asriel/characters/asriel/talk_LP" )

GLOBAL.asriel_voice = GetModConfigData("asriel_voice")

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

-- The character select screen lines
STRINGS.CHARACTER_TITLES.asriel = "Asriel Dreemurr"
STRINGS.CHARACTER_NAMES.asriel = "Asriel"
STRINGS.CHARACTER_DESCRIPTIONS.asriel = "*Has an unfortunate past\n*Grade-A crybaby\n*A lover, not a fighter"
STRINGS.CHARACTER_QUOTES.asriel = "\"Don't kill and don't be killed, alright?\""

--skin quotes
GLOBAL.STRINGS.SKIN_QUOTES.asriel_formal = "A prince has to be able to dress appropriately!"
GLOBAL.STRINGS.SKIN_NAMES.asriel_formal = "Guest of Honour"

-- Custom speech strings
STRINGS.CHARACTERS.ASRIEL = require "speech_asriel"

-- This is for rezecib's status announcements mod.
if not GLOBAL.STRINGS._STATUS_ANNOUNCEMENTS then GLOBAL.STRINGS._STATUS_ANNOUNCEMENTS = {} end
GLOBAL.STRINGS._STATUS_ANNOUNCEMENTS.ASRIEL = require "announcestrings_asriel"

-- The character's name as appears in-game 
STRINGS.NAMES.ASRIEL = "Asriel Dreemurr"

-- The default responses of examining the character
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ASRIEL = 
{
	GENERIC = "It's %s!",
	ATTACKER = "That goat sure looks shifty...",
	MURDERER = "Villain!",
	REVIVER = "That monster, %s, seems to know what he's doing!",
	GHOST = "I don't like the look of that flower...",
	FIRESTARTER = "Is that ash on your fur, %s?",
}
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.ASRIEL = 
{
	GENERIC = "Hi there, %s!",
	ATTACKER = "Hey! That's not very nice, %s!",
	MURDERER = "I should burn you, little flower!",
	REVIVER = "You're no monster, %s!",
	GHOST = "Must. Resist. Burning...",
	FIRESTARTER = "Did you light a fire? Nice!",
}
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.ASRIEL = 
{
	GENERIC = "Is little goat! Hello!",
	ATTACKER = "Is little goat angry?",
	MURDERER = "Is scary goat monster!",
	REVIVER = "%s does good job!",
	GHOST = "Is little scary flower!",
	FIRESTARTER = "Is little goat lighting fires?",
}
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.ASRIEL = 
{
	GENERIC = "How do you do, %s?",
	ATTACKER = "You are hiding something, aren't you %s?",
	MURDERER = "You have returned to violence, haven't you?",
	REVIVER = "Don't worry, %s. Abigail is only curious.",
	GHOST = "What a curious flower you are, %s.",
	FIRESTARTER = "Do you wish to take revenge on plant life?",
}
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.ASRIEL = 
{
	GENERIC = "DETECTING... %s!",
	ATTACKER = "DO YOU WISH TO DESTROY AGAIN, %s?",
	MURDERER = "YOU HAVE TURNED TO EVIL ONCE MORE, %s!",
	REVIVER = "YOU ARE OK FOR A MONSTER, %s.",
	GHOST = "EVIL ORGANIC MATTER DETECTED.",
	FIRESTARTER = "%s IS HELPING DESTROY THE WORLD.",
}
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.ASRIEL = 
{
	GENERIC = "Ah, greetings dear %s!",
	ATTACKER = "Most curious, is there a reason to this violence?",
	MURDERER = "I knew we shouldn't have trusted a monster!",
	REVIVER = "\"Howdy\" to you too, %s.",
	GHOST = "A flower sustained by soul fragments, most interesting.",
	FIRESTARTER = "Willow has been teaching the children rather unsafe things...",
}
GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.ASRIEL = 
{
	GENERIC = "It's the monster, %s!",
	ATTACKER = "%s isn't being very nice...",
	MURDERER = "I knew I shouldn't have trusted you!",
	REVIVER = "You're an alright monster, %s",
	GHOST = "I should stomp that weed before it gets too the trees...",
	FIRESTARTER = "Careful around the trees, %s!",
}
GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.ASRIEL = 
{
	GENERIC = "Grettings... Young monster.",
	ATTACKER = "I should never have trusted a monster...",
	MURDERER = "Do you really think you can get away with this?!",
	REVIVER = "I never heard of a monster like you, %s.",
	GHOST = "Why is it always a flower?",
	FIRESTARTER = "Is that ash in your fur, monster?.",
}
GLOBAL.STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.ASRIEL = 
{
	GENERIC = "Blessings apon you, goatchild %s!",
	ATTACKER = "There is a new fire in the monster's eyes!",
	MURDERER = "I have felled greater monsters than you, %s!",
	REVIVER = "%s has proven himself a great ally!",
	GHOST = "Are you a messenger of the gods, yellow flower?",
	FIRESTARTER = "A monster, forged by flames!",
}
GLOBAL.STRINGS.CHARACTERS.WEBBER.DESCRIBE.ASRIEL = 
{
	GENERIC = "Hi %s! Your fur looks nice today!",
	ATTACKER = "%s, what's the matter?",
	MURDERER = "We aren't friends any more, %s!",
	REVIVER = "%s soul is stronger than any monsters!",
	GHOST = "What a nice colour you have, mr flower!",
	FIRESTARTER = "%s, no!! Only we can prevent forest fires!",
}
GLOBAL.STRINGS.CHARACTERS.ASRIEL.DESCRIBE.ASRIEL = 
{
	GENERIC = "Is someone messing with the timeline again?",
	ATTACKER = "I don't like that look...",
	MURDERER = "No! This can't be happening again!",
	REVIVER = "Hah, don't you have anything better to do?",
	GHOST = "F-Flowey?",
	FIRESTARTER = "Do I always look that...singed?",
}

AddPrefabPostInit("flower", function(inst)

local function OnPickedfn(inst, picker)
	if picker and picker.components.sanity and picker.prefab ~= "asriel" then
        picker.components.sanity:DoDelta(TUNING.SANITY_MED)
	elseif picker and picker.components.sanity and picker.prefab == "asriel" then
		picker.components.sanity:DoDelta(10, false)
    end
	if inst.animname == ROSE_NAME and picker.components.combat ~= nil then
        picker.components.combat:GetAttacked(inst, TUNING.ROSE_DAMAGE)
        picker:PushEvent("thorns")
    end
    GLOBAL.TheWorld:PushEvent("beginregrowth", inst)
    inst:Remove()	
end
inst.components.pickable.onpickedfn = OnPickedfn

end)
AddMinimapAtlas("images/map_icons/asriel.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("asriel", "MALE")
modimport("scripts/asrielmod_skins.lua")
