--[[
BY
 _____   _____   __   _  
|  _  \ /  _  \ |  \ | | 
| | | | | | | | |   \| | 
| | | | | | | | | |\   | 
| |_| | | |_| | | | \  | 
|_____/ \_____/ |_|  \_| 

]]

require("stategraphs/commonstates")
require("stategraphs/SGpetsdon_common") --bydon

local actionhandlers =
{
	ActionHandler(ACTIONS.CHOP, "chop"),
	ActionHandler(ACTIONS.MINE, "mine"),
	--ActionHandler(ACTIONS.PICK, "action"),
}

local events =
{
SGCritterEvents.OnEat(),

CommonHandlers.OnSleepEx(),
CommonHandlers.OnWakeEx(),
CommonHandlers.OnLocomote(false,true),
	EventHandler("doaction", function(inst, data)
        if data.action == ACTIONS.CHOP and not (inst.sg:HasStateTag("busy"))  then
            inst.sg:GoToState("chop", data.target)
        end
		if data.action == ACTIONS.MINE and not (inst.sg:HasStateTag("busy")) then
            inst.sg:GoToState("mine", data.target)
        end
		
	end),

}

local states =
{
	State{
        name = "chop",
        tags = { "chopping" },

        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("idle_loop")
			
        end,

        timeline =
        {
            TimeEvent(3 * FRAMES, function(inst)
                inst:PerformBufferedAction()
            end),
        },

        events =
        {
            EventHandler("animover", function(inst)
                inst.sg:GoToState("idle")
            end),
        },
    },
	State{
        name = "mine",
        tags = { "mining" },

        onenter = function(inst)
            inst.Physics:Stop()
			inst.AnimState:PlayAnimation("idle_loop")
			inst.SoundEmitter:PlaySound("dontstarve/wilson/use_pick_rock")  
        end,

        timeline =
        {
            TimeEvent(6 * FRAMES, function(inst)
                inst:PerformBufferedAction()
            end),
        },

        events =
        {
            EventHandler("animover", function(inst)
              inst.sg:GoToState("idle")
            end),
        },
    },
}

SGCritterStates.AddIdle(states)


SGCritterStates.AddPetEmote(states,
{
TimeEvent(10*FRAMES, function(inst) inst.SoundEmitter:PlaySound(inst.soundsdon.yell) end),
})

SGCritterStates.AddPlayWithOtherCritter(states, events, nil)


SGCritterStates.AddEat(states,
{


TimeEvent(6*FRAMES, function(inst) inst.SoundEmitter:PlaySound(inst.soundsdon.eat, "peteatsd") end),
TimeEvent((22+16)*FRAMES, function(inst) inst.SoundEmitter:PlaySound(inst.soundsdon.chew, "petchewsd") end),

TimeEvent(70 * FRAMES, function(inst)
inst.SoundEmitter:KillSound("peteatsd") 
inst.SoundEmitter:KillSound("petchewsd")
end),


})


SGCritterStates.AddHungry(states,
{
TimeEvent(0*FRAMES, function(inst) inst.SoundEmitter:PlaySound(inst.soundsdon.angry) end),
})


SGCritterStates.AddNuzzle(states, actionhandlers,
{
TimeEvent(19*FRAMES, function(inst) inst.SoundEmitter:PlaySound(inst.soundsdon.grunt) end),
})


SGCritterStates.AddWalkStates(states, 
{

starttimeline = 
{
--buzz
TimeEvent(0*FRAMES, function(inst) if inst.walktype == "flybuzz" then inst.SoundEmitter:PlaySound(inst.soundsdon.walk, "petbeebuzz") end end),
},


walktimeline =
{

--normal walk:
TimeEvent(0*FRAMES, function(inst) if inst.walktype == "walk" then inst.SoundEmitter:PlaySound(inst.soundsdon.walk) end end),

--walkbounce
TimeEvent(5*FRAMES, function(inst) if inst.walktype == "walkbounce" then inst.SoundEmitter:PlaySound(inst.soundsdon.walk) end end),
TimeEvent(20*FRAMES, function(inst) if inst.walktype == "walkbounce" then inst.SoundEmitter:PlaySound(inst.soundsdon.walk) end end),

--walkfly1
TimeEvent(0*FRAMES, function(inst) if inst.walktype == "walkfly1" then inst.SoundEmitter:PlaySound(inst.soundsdon.bodyfall) end end),
TimeEvent(3*FRAMES, function(inst) if inst.walktype == "walkfly1" then inst.SoundEmitter:PlaySound(inst.soundsdon.walk) end end),
TimeEvent(11*FRAMES, function(inst) if inst.walktype == "walkfly1" then inst.SoundEmitter:PlaySound(inst.soundsdon.walk) end end),
TimeEvent(18*FRAMES, function(inst) if inst.walktype == "walkfly1" then inst.SoundEmitter:PlaySound(inst.soundsdon.bodyfall) end end),
TimeEvent(19*FRAMES, function(inst) if inst.walktype == "walkfly1" then inst.SoundEmitter:PlaySound(inst.soundsdon.walk) end end),
TimeEvent(27*FRAMES, function(inst) if inst.walktype == "walkfly1" then inst.SoundEmitter:PlaySound(inst.soundsdon.walk) end end),
TimeEvent(35*FRAMES, function(inst) if inst.walktype == "walkfly1" then inst.SoundEmitter:PlaySound(inst.soundsdon.walk) end end),

--walkfly2
TimeEvent(1*FRAMES, function(inst) if inst.walktype == "walkfly2" then inst.SoundEmitter:PlaySound(inst.soundsdon.walk) end end),
TimeEvent(9*FRAMES, function(inst) if inst.walktype == "walkfly2" then inst.SoundEmitter:PlaySound(inst.soundsdon.walk) end end),

--walkbounce2
TimeEvent(12*FRAMES, function(inst) if inst.walktype == "walkbounce2" then inst.SoundEmitter:PlaySound(inst.soundsdon.walk) end end),
},


endtimeline =
{
--normal walk
TimeEvent(0*FRAMES, function(inst) if inst.walktype == "walk" then inst.SoundEmitter:PlaySound(inst.soundsdon.walk) end end),

--not normal walk
TimeEvent(0*FRAMES, function(inst) if inst.walktype ~= "walk" then inst.SoundEmitter:PlaySound(inst.soundsdon.bodyfall) end end),

--buzz
TimeEvent(0*FRAMES, function(inst) if inst.walktype == "flybuzz" then inst.SoundEmitter:KillSound("petbeebuzz") end end),
},

}, true)


SGCritterStates.AddSleepExStates(states,
{
starttimeline = 
{
TimeEvent(22*FRAMES, function(inst) inst.SoundEmitter:PlaySound(inst.soundsdon.bodyfall) end),
},
sleeptimeline = 
{
TimeEvent(25*FRAMES, function(inst) inst.SoundEmitter:PlaySound(inst.soundsdon.sleep) end),
TimeEvent(57*FRAMES, function(inst) inst.SoundEmitter:PlaySound(inst.soundsdon.sleep) end),
},
})

return StateGraph("SGpetsdon", states, events, "idle", actionhandlers)
