local assets =
{
    Asset("ANIM", "anim/huifustaff.zip"),
    Asset("ANIM", "anim/swap_huifustaff.zip"),
	Asset("ATLAS", "images/inventoryimages/renew_staff.xml"),
    Asset("IMAGE", "images/inventoryimages/renew_staff.tex"),
}


local prefabs =
{
    "sleepcloud_extra",
}



local function createlight(staff, target, pos)
    local light = SpawnPrefab("sleepcloud_extra")
    light.Transform:SetPosition(pos:Get())
    staff.components.finiteuses:Use(1)

    local caster = staff.components.inventoryitem.owner
    if caster ~= nil and caster.components.sanity ~= nil then
        caster.components.sanity:DoDelta(-TUNING.SANITY_MEDLARGE)
    end
end

local function light_reticuletargetfn()
    return Vector3(ThePlayer.entity:LocalToWorldSpace(5, 0, 0))
end

local function onhauntlight(inst)
    if math.random() <= TUNING.HAUNT_CHANCE_RARE then
        local pos = inst:GetPosition()
        local start_angle = math.random() * 2 * PI
        local offset = FindWalkableOffset(pos, start_angle, math.random(3, 12), 60, false, true, NoHoles)
        if offset ~= nil then
            createlight(inst, nil, pos + offset)
            inst.components.hauntable.hauntvalue = TUNING.HAUNT_LARGE
            return true
        end
    end
    return false
end

---------COMMON FUNCTIONS---------

local function onfinished(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/gem_shatter")
    inst:Remove()
end



local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_huifustaff", "swap_huifustaff_0")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end




local function fn()
    local inst = CreateEntity()
	inst.entity:AddMiniMapEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("huifustaff")
    inst.AnimState:SetBuild("huifustaff")
	inst.MiniMapEntity:SetIcon("renew_staff.tex")
    inst.AnimState:PlayAnimation("idle")

	inst:AddTag("nopunch")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end


	
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "renew_staff"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/renew_staff.xml"
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    --inst.components.equippable.walkspeedmult = 1.15
	
	inst:AddComponent("reticule")
	inst.components.reticule.targetfn = light_reticuletargetfn
    inst.components.reticule.ease = true
	inst:AddComponent("spellcaster")
    inst.components.spellcaster:SetSpellFn(createlight)
    inst.components.spellcaster.canuseonpoint = true


	


    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(20)
    inst.components.finiteuses:SetUses(20)
	inst.components.finiteuses:SetOnFinished(onfinished)
	
    
    MakeHauntableLaunch(inst)
	AddHauntableCustomReaction(inst, onhauntlight, true, false, true)
	
    return inst
end

return Prefab("common/inventory/renew_staff", fn, assets) 