local assets=
{
	Asset("ANIM", "anim/lfy_wing.zip"),
  Asset("ATLAS", "images/inventoryimages/lfy_wing.xml"),
  Asset("IMAGE", "images/inventoryimages/lfy_wing.tex")

}

--------------
local function OnRefuseItem(inst, item)
    if item and item.prefab ~= "greengem" and item.prefab ~= "yellowgem" and item.prefab ~= "orangegem" and item.prefab ~= "thulecite" and item.prefab ~= "thulecite_pieces" then
        inst.sg:GoToState("refuse")
		return false
    end
end

local function acceptItem(item, giver)
	if item and item.prefab == "greengem" or item.prefab == "yellowgem" or item.prefab == "orangegem" or item.prefab == "thulecite" or item.prefab == "thulecite_pieces" then
        return true
	else
		return false
    end
	
end

--人物说话
local function talkSpeech(player, speechString)
	if player and player.components.talker then 
		player:DoTaskInTime(0, function ()
			player.components.talker:Say(speechString,6)
		end)
	end
end 
--local mdzz = inst.greenCount
--获取添加的物品
local function OnGetItemFromPlayer(inst, giver, item, player)
	if TheWorld.state.issummer then
		inst.components.insulator:SetSummer()
	elseif not TheWorld.state.issummer then
		inst.components.insulator:SetWinter()
    end	

	if item ~= nil and item.prefab == "bluegem" then
		if inst.blueCount<20 then
			inst.blueCount=inst.blueCount+1
			inst.components.insulator:SetInsulation(60+9*inst.blueCount)
			inst.components.talker:Say("蓝宝石数量:"..inst.blueCount.."/20")
		else
			inst.components.talker:Say("蓝宝石已满")
		end
		SpawnPrefab("splash").Transform:SetPosition(inst:GetPosition():Get())
	end
	if item ~= nil and item.prefab == "redgem" then
		if inst.redCount<20 then
			inst.redCount=inst.redCount+1
			inst.components.waterproofer:SetEffectiveness(0.2+0.04*redCount)
			inst.components.talker:Say("红宝石数量:"..inst.redCount.."/20")
		else
			inst.components.talker:Say("红宝石已满")
		end
		SpawnPrefab("splash").Transform:SetPosition(inst:GetPosition():Get())
	end
	if item ~= nil and item.prefab == "thulecite" then
		if inst.thuleCount<20 then
			inst.thuleCount=inst.thuleCount+1
			inst.components.armor:SetAbsorption(0.7+inst.thuleCount*0.01)
			inst.components.talker:Say("铥矿数量:"..inst.thuleCount.."/20")
		else
			inst.components.talker:Say("铥矿已满")
		end
		SpawnPrefab("splash").Transform:SetPosition(inst:GetPosition():Get())
	end
	if inst.thuleCount and inst.thuleCount>=20 and	inst.redCount>=20 and inst.blueCount>=20 then
		inst.components.equippable.walkspeedmult = 1.25	
	end
end

local function onequip(inst, owner) 

	OnGetItemFromPlayer(inst)
    owner.AnimState:OverrideSymbol("swap_body", "lfy_wing", "swap_body")


end

local function onunequip(inst, owner) 
	OnGetItemFromPlayer(inst)
    owner.AnimState:ClearOverrideSymbol("swap_body")
    owner.AnimState:ClearOverrideSymbol("backpack")

end
local function onpreload(inst, data)

	if data then
		if data.blueCount then
			inst.blueCount = data.blueCount
			inst.components.insulator:SetInsulation(60+9*inst.blueCount)
		end
		if data.redCount then
			inst.redCount = data.redCount
			inst.components.waterproofer:SetEffectiveness(0.2+0.04*redCount)
		end
		if data.thuleCount then
			inst.thuleCount = data.thuleCount
			inst.components.armor:SetAbsorption(0.7+inst.thuleCount*0.01)
		end
		OnGetItemFromPlayer(inst)
	end
end

local function onsave(inst, data)
	data.blueCount = inst.blueCount
	data.redowCount = inst.redCount
	data.thuleCount = inst.thuleCount


end
local function OnRefuseItem(inst, giver, item)
	if item then
		inst.components.talker:Say("洛菲雅之翼".."\n蓝:"..inst.blueCount.."/20".."\n红:"..inst.redCount.."/20".."\n铥:"..inst.thuleCount.."/20")
	end
end

local function AcceptTest(inst, item)
    return item.prefab == "bluegem" or item.prefab == "redgem" or item.prefab == "thulecite" 
end
local function OnDurability(inst, data)
	inst.broken = true
	inst.components.fueled:StopConsuming()        
 end
local function fn()
	local inst = CreateEntity()
	
	inst.entity:AddTransform()
    inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)  

    inst.AnimState:SetBank("lfy_wing")
    inst.AnimState:SetBuild("lfy_wing")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddTag("metal")

	    inst:AddTag("backpack")
	inst:AddTag("waterproofer")


			
    inst.entity:SetPristine()
	
	    if not TheWorld.ismastersim then
        return inst
    end
	inst.blueCount =0
	inst.redCount = 0
	inst.thuleCount = 0
	
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.imagename = "images/inventoryimages/lfy_wing.tex"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/lfy_wing.xml"

	inst:AddComponent("talker")
    inst.components.talker.fontsize = 20
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(1, 0.8, 0.95, 1)
    inst.components.talker.offset = Vector3(0,-200,0)
    inst.components.talker.symbol = "swap_object"	
	
    inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(0.2)


	
    inst:AddComponent("insulator")
	inst.components.insulator:SetInsulation(60)


 -------------------------   
    inst:AddComponent("armor")
	inst.components.armor:InitCondition(99999999999999999999999999999, 0.7)
 
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    inst.components.equippable:SetOnEquip( onequip )
	
    inst.components.equippable:SetOnUnequip( onunequip )
	inst.components.equippable.walkspeedmult = 1.10
	
    inst:AddComponent("trader")
	inst.components.trader:SetAcceptTest(AcceptTest)
	inst.components.trader.onaccept = OnGetItemFromPlayer
	inst.components.trader.onrefuse = OnRefuseItem
	

	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
    return inst
end

return Prefab( "common/inventory/lfy_wing", fn, assets) 
