local assets =
{
	Asset("ANIM", "anim/sword_extra_build.zip"),
	Asset("ANIM", "anim/swap_sword_extra.zip"),
	Asset("ATLAS", "images/inventoryimages/bianhuaspear.xml"),
	Asset("IMAGE", "images/inventoryimages/bianhuaspear.tex"),

}


local function fireattack(inst, attacker, target)
	target:PushEvent("attacked", {attacker = attacker, damage = 0})

		if target.SoundEmitter then
			target.SoundEmitter:PlaySound("dontstarve/wilson/blowdart_impact_fire")
		end
		if target.components.burnable then
			target.components.burnable:Ignite()
		end
		if target.components.health then
			target.components.health:DoFireDamage(0)
		end

	if target.components.freezable then
		target.components.freezable:Unfreeze()
	end
	if target.components.combat then
		target.components.combat:SuggestTarget(attacker)
	end
	if target.sg and target.sg.sg.states.hit then
		target.sg:GoToState("hit")
	end
end
local function overridesymbol(inst, owner)
	local percentage = inst.components.finiteuses:GetPercent()
	--[[inst:DoTaskInTime(0.2, function()
		if percentage>0.5 then
			if percentage>0.5 and percentage<=0.625 then
			owner.AnimState:OverrideSymbol("swap_object", "swap_spear_obsidian", "swap_spear_yellow")
			elseif percentage>0.625 and percentage<=0.75 then
				owner.AnimState:OverrideSymbol("swap_object", "swap_spear_obsidian", "swap_spear_orange")
			elseif percentage>0.75 and percentage<=0.875 then
				owner.AnimState:OverrideSymbol("swap_object", "swap_spear_obsidian", "swap_spear_red")
			elseif percentage>0.875  then
				owner.AnimState:OverrideSymbol("swap_object", "swap_spear_obsidian", "swap_spear")		
			end
		
		elseif percentage<=0.5 then
			if percentage<=0.5 and percentage>0.375 then
				owner.AnimState:OverrideSymbol("swap_object", "swap_spear_obsidian", "swap_spear_yellow")
			elseif  percentage<=0.375  and percentage>0.25 then
				owner.AnimState:OverrideSymbol("swap_object", "swap_spear_obsidian", "swap_spear_orange")
			elseif  percentage<=0.25  and percentage>0.125 then
				owner.AnimState:OverrideSymbol("swap_object", "swap_spear_obsidian", "swap_spear_red")
			elseif  percentage<=0.125 then
				owner.AnimState:OverrideSymbol("swap_object", "swap_spear_obsidian", "swap_spear")		
			end
		end
	end)--]]
	inst:DoTaskInTime(0.2, function()
		if percentage then
			if percentage<=0.25  then
			owner.AnimState:OverrideSymbol("swap_object", "swap_sword_extra", "swap_spear-3")
			elseif percentage>0.25  and percentage<=0.5  then
				owner.AnimState:OverrideSymbol("swap_object", "swap_sword_extra", "swap_spear-2")
			elseif percentage>0.5 and percentage<=0.75  then
				owner.AnimState:OverrideSymbol("swap_object", "swap_sword_extra", "swap_spear-1")
			elseif percentage>0.75  then
				owner.AnimState:OverrideSymbol("swap_object", "swap_sword_extra", "swap_spear-0")		
			end
		end
	end)

end
local function onequip(inst, owner)
    overridesymbol(inst, owner)
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
	local currentperc = inst.components.finiteuses:GetPercent()
	if currentperc<0.01 then
		inst.components.weapon:SetDamage(51)
	elseif currentperc>=0.01  then
		inst.components.weapon:SetDamage((51+51*(1-currentperc)))
	elseif currentperc>=0.01  then
		inst.components.weapon:SetDamage(51)
	end
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end
local function animground(inst)
	local percentage = inst.components.finiteuses:GetPercent()
    inst:DoTaskInTime(0.2, function()
    	local anim = inst.entity:AddAnimState()
    	anim:SetBuild("sword_extra_build")
	    local bank = "sword_extra-0"
		if percentage then
			if percentage<=0.25  then
				bank = "sword_extra-3"
			end
			if percentage>0.25  and percentage<=0.5  then
				bank = "sword_extra-2"
			end
			if percentage>0.5 and percentage<=0.75  then
				bank = "sword_extra-1"
			end
			if percentage>0.75  then
				bank = "sword_extra-0"
			end
		end
	    anim:SetBank(bank)
	    anim:PlayAnimation("idle")
    end)
end
local function onattack(inst, attacker, target, skipsanity, owner)
	
	local percentage = inst.components.finiteuses:GetPercent()

	if inst.components.inventoryitem.owner ~= nil then
		overridesymbol(inst, inst.components.inventoryitem.owner)
		animground(inst)
	end
	--[[if percentage>0.5 then
		inst.components.weapon:SetDamage((51+102-102*percentage))
	else
		inst.components.weapon:SetDamage((51+102*percentage))
	end--]]

		inst.components.weapon:SetDamage((51+51*(1-percentage)))
		inst.components.finiteuses:Use(2)

end

local function onfinished(inst) 
	inst.components.weapon:SetDamage(51)
end


local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
	inst.entity:AddSoundEmitter()
	
	
	inst.entity:AddLight()
    inst.Light:SetFalloff(0.5)
    inst.Light:SetIntensity(0.75)
	inst.Light:Enable(false)
    MakeInventoryPhysics(inst)
	



    inst:AddTag("sharp")
	inst:AddTag("spear")
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end





	inst:AddComponent("tradable")
	

	-------

	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(100)
	inst.components.finiteuses:SetUses(100)

	inst.components.finiteuses:SetOnFinished(onfinished)
	
	inst:DoPeriodicTask(0.8, function()
		if  inst.components.finiteuses.current<100  then
			local currentperc = inst.components.finiteuses.current
			inst.components.finiteuses.current=currentperc+1
		end
	end)

	inst:AddComponent("inspectable")
	


    -------
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "bianhuaspear"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/bianhuaspear.xml"

	
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    MakeHauntableLaunch(inst)
	
	inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(0)
	

	

    animground(inst)
	
	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(51)
	inst.components.weapon:SetOnAttack(onattack)
	inst.components.weapon.attackwear = 1 / 2.5

	inst.speartype = "obsidian"



    return inst
end


STRINGS.DONOBSIDIANSPEAR = "黑曜石长矛"
STRINGS.NAMES.DONOBSIDIANSPEAR = "黑曜石长矛"
STRINGS.RECIPE_DESC.DONOBSIDIANSPEAR = "How 'bout a lil' fire with your spear?"

return Prefab("bianhuaspear", fn, assets)