local assets =
{
	Asset( "ANIM", "anim/wx78.zip" ),
	Asset( "ANIM", "anim/ghost_wx78_build.zip" ),
	
    Asset("ATLAS", "images/inventoryimages/wx78_switch.xml"),
    Asset("IMAGE", "images/inventoryimages/wx78_switch.tex"),
}

local function onbuilt(inst, builder)
	-- builder:MakeWillow()
	SetSkinMode(builder.AnimState, "wx78", "wx78", builder.components.skinner:GetClothing(), nil, "wx78")
	inst:Remove()
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	inst:AddTag("CLASSIFIED")

	inst.persists = false

	inst:DoTaskInTime(0, inst.Remove)

	if not TheWorld.ismastersim then
		return inst
	end
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wx78_switch"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wx78_switch.xml"

	inst.OnBuiltFn = onbuilt

	return inst
end

return Prefab("wx78_switch", fn, assets)