local assets =
{
	Asset( "ANIM", "anim/woodie.zip" ),
	Asset( "ANIM", "anim/ghost_woodie_build.zip" ),
	
    Asset("ATLAS", "images/inventoryimages/woodie_switch.xml"),
    Asset("IMAGE", "images/inventoryimages/woodie_switch.tex"),
}

local function onbuilt(inst, builder)
	-- builder:MakeWillow()
	SetSkinMode(builder.AnimState, "woodie", "woodie", builder.components.skinner:GetClothing(), nil, "woodie")
	inst:Remove()
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	inst:AddTag("CLASSIFIED")

	inst.persists = false

	inst:DoTaskInTime(0, inst.Remove)

	if not TheWorld.ismastersim then
		return inst
	end
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "woodie_switch"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/woodie_switch.xml"

	inst.OnBuiltFn = onbuilt

	return inst
end

return Prefab("woodie_switch", fn, assets)