local assets =
{
	Asset( "ANIM", "anim/winona.zip" ),
	Asset( "ANIM", "anim/ghost_winona_build.zip" ),
	
    Asset("ATLAS", "images/inventoryimages/winona_switch.xml"),
    Asset("IMAGE", "images/inventoryimages/winona_switch.tex"),
}

local function onbuilt(inst, builder)
	-- builder:MakeWillow()
	SetSkinMode(builder.AnimState, "winona", "winona", builder.components.skinner:GetClothing(), nil, "winona")
	inst:Remove()
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	inst:AddTag("CLASSIFIED")

	inst.persists = false

	inst:DoTaskInTime(0, inst.Remove)

	if not TheWorld.ismastersim then
		return inst
	end
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "winona_switch"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/winona_switch.xml"

	inst.OnBuiltFn = onbuilt

	return inst
end

return Prefab("winona_switch", fn, assets)