local assets =
{
	Asset( "ANIM", "anim/wickerbottom.zip" ),
	Asset( "ANIM", "anim/ghost_wickerbottom_build.zip" ),
	
    Asset("ATLAS", "images/inventoryimages/wickerbottom_switch.xml"),
    Asset("IMAGE", "images/inventoryimages/wickerbottom_switch.tex"),
}

local function onbuilt(inst, builder)
	-- builder:MakeWillow()
	SetSkinMode(builder.AnimState, "wickerbottom", "wickerbottom", builder.components.skinner:GetClothing(), nil, "wickerbottom")
	inst:Remove()
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	inst:AddTag("CLASSIFIED")

	inst.persists = false

	inst:DoTaskInTime(0, inst.Remove)

	if not TheWorld.ismastersim then
		return inst
	end
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wickerbottom_switch"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wickerbottom_switch.xml"

	inst.OnBuiltFn = onbuilt

	return inst
end

return Prefab("wickerbottom_switch", fn, assets)