local assets =
{
	Asset( "ANIM", "anim/wes.zip" ),
	Asset( "ANIM", "anim/ghost_wes_build.zip" ),
	
    Asset("ATLAS", "images/inventoryimages/wes_switch.xml"),
    Asset("IMAGE", "images/inventoryimages/wes_switch.tex"),
}

local function onbuilt(inst, builder)
	-- builder:MakeWillow()
	SetSkinMode(builder.AnimState, "wes", "wes", builder.components.skinner:GetClothing(), nil, "wes")
	inst:Remove()
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	inst:AddTag("CLASSIFIED")

	inst.persists = false

	inst:DoTaskInTime(0, inst.Remove)

	if not TheWorld.ismastersim then
		return inst
	end
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wes_switch"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wes_switch.xml"

	inst.OnBuiltFn = onbuilt

	return inst
end

return Prefab("wes_switch", fn, assets)