local assets =
{
	Asset( "ANIM", "anim/wendy.zip" ),
	Asset( "ANIM", "anim/ghost_wendy_build.zip" ),
	
    Asset("ATLAS", "images/inventoryimages/wendy_switch.xml"),
    Asset("IMAGE", "images/inventoryimages/wendy_switch.tex"),
}

local function onbuilt(inst, builder)
	-- builder:MakeWillow()
	SetSkinMode(builder.AnimState, "wendy", "wendy", builder.components.skinner:GetClothing(), nil, "wendy")
	inst:Remove()
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	inst:AddTag("CLASSIFIED")

	inst.persists = false

	inst:DoTaskInTime(0, inst.Remove)

	if not TheWorld.ismastersim then
		return inst
	end
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wendy_switch"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wendy_switch.xml"

	inst.OnBuiltFn = onbuilt

	return inst
end

return Prefab("wendy_switch", fn, assets)