local assets =
{
	Asset( "ANIM", "anim/wathgrithr.zip" ),
	Asset( "ANIM", "anim/ghost_wathgrithr_build.zip" ),
	
    Asset("ATLAS", "images/inventoryimages/wathgrithr_switch.xml"),
    Asset("IMAGE", "images/inventoryimages/wathgrithr_switch.tex"),
}

local function onbuilt(inst, builder)
	-- builder:MakeWillow()
	SetSkinMode(builder.AnimState, "wathgrithr", "wathgrithr", builder.components.skinner:GetClothing(), nil, "wathgrithr")
	inst:Remove()
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	inst:AddTag("CLASSIFIED")

	inst.persists = false

	inst:DoTaskInTime(0, inst.Remove)

	if not TheWorld.ismastersim then
		return inst
	end
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wathgrithr_switch"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wathgrithr_switch.xml"

	inst.OnBuiltFn = onbuilt

	return inst
end

return Prefab("wathgrithr_switch", fn, assets)