local assets=
{
	Asset("ANIM", "anim/shadowbombactive.zip"),

	

}

local prefabs =
{
    "explode_small",
}


local FADE_FRAMES = 5
local FADE_INTENSITY = .8
local FADE_RADIUS = 1.5
local FADE_FALLOFF = .5

local function OnUpdateFade(inst)
    local k
    if inst._fade:value() <= FADE_FRAMES then
        inst._fade:set_local(math.min(inst._fade:value() + 1, FADE_FRAMES))
        k = inst._fade:value() / FADE_FRAMES
    else
        inst._fade:set_local(math.min(inst._fade:value() + 1, FADE_FRAMES * 2 + 1))
        k = (FADE_FRAMES * 2 + 1 - inst._fade:value()) / FADE_FRAMES
    end

    inst.Light:SetIntensity(FADE_INTENSITY * k)
    inst.Light:SetRadius(FADE_RADIUS * k)
    inst.Light:SetFalloff(1 - (1 - FADE_FALLOFF) * k)

    if TheWorld.ismastersim then
        inst.Light:Enable(inst._fade:value() > 0 and inst._fade:value() <= FADE_FRAMES * 2)
    end

    if inst._fade:value() == FADE_FRAMES or inst._fade:value() > FADE_FRAMES * 2 then
        inst._fadetask:Cancel()
        inst._fadetask = nil
    end
end

local function OnFadeDirty(inst)
    if inst._fadetask == nil then
        inst._fadetask = inst:DoPeriodicTask(FRAMES, OnUpdateFade)
    end
    OnUpdateFade(inst)
end

local function FadeOut(inst)
    inst._fade:set(FADE_FRAMES + 1)
    if inst._fadetask == nil then
        inst._fadetask = inst:DoPeriodicTask(FRAMES, OnUpdateFade)
    end
end


local function CreateGroundFX(bomb)
    local inst = CreateEntity()

    inst:AddTag("FX")
    --[[Non-networked entity]]
    inst.entity:SetCanSleep(false)
    inst.persists = false

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
	    inst.AnimState:SetMultColour(0.1, 0.1, 0.1, 0.8)

    inst.AnimState:SetBank("mushroombomb_base")
    inst.AnimState:SetBuild("mushroombomb_base")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
    inst.AnimState:SetLayer(LAYER_BACKGROUND)
    inst.AnimState:SetSortOrder(3)
    inst.AnimState:SetFinalOffset(-1)
    inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")


    inst:ListenForEvent("animover", inst.Remove)

    inst.Transform:SetPosition(bomb.Transform:GetWorldPosition())
end


local function OnIgniteFn(inst)
  inst._fx = SpawnPrefab("shadowbombsmoke")
    inst._fx.entity:SetParent(inst.entity)
            inst._fx.entity:AddFollower()
            inst._fx.Follower:FollowSymbol(inst.GUID, "shadowbomb", 0, 0, 0)

    inst.SoundEmitter:PlaySound("dontstarve/sanity/bishop/taunt", "hiss")
end

local function OnExtinguishFn(inst)
    inst.SoundEmitter:KillSound("hiss")
end


local function OnExplodeFn(inst)

local x, y, z = inst.Transform:GetWorldPosition()
local ents = TheSim:FindEntities(x, y, z, 3)
		 for i, v in ipairs(ents) do
		 
		 if v:HasTag("irreplaceable") then
		 
		 else
		  if v.components.hauntable ~= nil then
		  v.components.hauntable:DoHaunt(v)
		  end
		  
		  if v.components.combat ~= nil then
				 if v:HasTag("player") then
				         v.components.sanity:DoDelta(-25)
				 else

					end
					end				
	
end
    inst.SoundEmitter:KillSound("hiss")
	
	    inst.SoundEmitter:PlaySound("dontstarve/sanity/death_pop")
		inst.SoundEmitter:PlaySound("dontstarve/sanity/bishop/dissappear")
		
  local x, y, z = inst.Transform:GetWorldPosition()
 local prefab = "statue_transition_2"
       local fx = SpawnPrefab(prefab)
	fx.Transform:SetPosition(x, y, z)


    fx.persists = false



	
	    if not TheNet:IsDedicated() then
        CreateGroundFX(fx)
		end

    SpawnPrefab("shadow_despawn").Transform:SetPosition(inst.Transform:GetWorldPosition())
end
end

local function Explode(inst)
    inst.SoundEmitter:KillSound("hiss")
  inst.components.explosive:OnBurnt()
end





	
local function fn(Sim)
    local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()

	inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("shadowbombactive")
    anim:SetBuild("shadowbombactive")
    anim:PlayAnimation("idle",true)
        inst:AddTag("explosive")
						        inst:AddTag("SCARYTOPREY")
      inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

	


        inst:AddComponent("explosive")
    inst.components.explosive:SetOnExplodeFn(OnExplodeFn)
    inst.components.explosive.explosivedamage = 100
		  	      inst.components.explosive.buildingdamage = 0
  inst.components.explosive.lightonexplode = false
	
  inst._light = nil

		  inst:DoTaskInTime(0, OnIgniteFn)
	  inst:DoTaskInTime(1.5, Explode)



	


	 




    
    return inst
end

return Prefab( "common/inventory/shadowbombactive", fn, assets) 
