local assets=
{
	Asset("ANIM", "anim/icebombinventory.zip"),
		Asset("ANIM", "anim/swap_icebomb.zip"),
	Asset("ATLAS", "images/inventoryimages/icebomb.xml"),
	Asset("IMAGE", "images/inventoryimages/icebomb.tex"),
	

}

local prefabs = 
{

}	

local function OnHitWater(inst, attacker, target)
	local pt = inst:GetPosition()    
  local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 3)
    for i, v in ipairs(ents) do

	if v.components.health ~= nil then
v.components.combat:SuggestTarget(attacker)
	end
	end


    inst.SoundEmitter:KillSound("hiss")
	SpawnPrefab("icebombactive").Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst.SoundEmitter:PlaySound("dontstarve/common/gem_shatter")

	
	

	

	
    inst:Remove()
end


local function onthrown(inst)
  inst._fx = SpawnPrefab("coldfirefire")
    inst._fx.entity:SetParent(inst.entity)
            inst._fx.entity:AddFollower()
            inst._fx.Follower:FollowSymbol(inst.GUID, "icebomb", 0, 0, 0)
    inst.AnimState:PlayAnimation("thrown")
    inst:AddTag("NOCLICK")
    inst.persists = false

  inst.SoundEmitter:PlaySound("dontstarve/common/blackpowder_fuse_LP", "hiss")
    inst.Physics:SetMass(1)
    inst.Physics:SetCapsule(0.2, 0.2)
    inst.Physics:SetFriction(0)
    inst.Physics:SetDamping(0)
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.ITEMS)
end


local function ReticuleTargetFn()
    local player = ThePlayer
    local ground = TheWorld.Map
    local x, y, z
    --Attack range is 8, leave room for error
    --Min range was chosen to not hit yourself (2 is the hit range)
    for r = 8.5, 6.5, -.25 do
        x, y, z = player.entity:LocalToWorldSpace(r, 0, 0)
        if ground:IsPassableAtPoint(x, y, z) then
            return Vector3(x, y, z)
        end
    end
    return Vector3(x, y, z)
end

local function OnIgniteFn(inst)
	SpawnPrefab("icebombactive").Transform:SetPosition(inst.Transform:GetWorldPosition())
	   inst:Remove()
end
	
local function onequip(inst, owner) 
     owner.AnimState:OverrideSymbol("swap_object", "swap_icebomb", "swap_icebomb")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end
	
local function fn(Sim)
    local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()

	inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("icebombinventory")
    anim:SetBuild("icebombinventory")
    anim:PlayAnimation("idle")
    


	      inst:AddComponent("reticule")
    inst.components.reticule.targetfn = ReticuleTargetFn
    inst.components.reticule.ease = true
	  
		inst.entity:SetPristine()
	  
    if not TheWorld.ismastersim then
        return inst
    end
	
		
    inst:AddComponent("inventoryitem")
	
	inst:AddComponent("locomotor")


    inst:AddComponent("complexprojectile")
	
    inst.components.complexprojectile:SetHorizontalSpeed(15)
    inst.components.complexprojectile:SetGravity(-35)
    inst.components.complexprojectile:SetLaunchOffset(Vector3(.25, 1, 0))
    inst.components.complexprojectile:SetOnLaunch(onthrown)
    inst.components.complexprojectile:SetOnHit(OnHitWater)
	


	
    inst:AddComponent("inspectable")
	


	inst.components.inventoryitem.imagename = "icebomb"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/icebomb.xml"
	

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(10)
    inst.components.weapon:SetRange(12, 15)
	
	    MakeSmallBurnable(inst, 3 + math.random() * 3)

    --V2C: Remove default OnBurnt handler, as it conflicts with
    --explosive component's OnBurnt handler for removing itself
    inst.components.burnable:SetOnBurntFn(nil)
    inst.components.burnable:SetOnIgniteFn(OnIgniteFn)

	 inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	    inst.components.equippable.equipstack = true

	 inst:AddComponent("stackable")

    
    return inst
end

return Prefab( "common/inventory/icebomb", fn, assets) 
