require "prefabutil"

local containers = require("containers")

local prefabs =
{
    "collapse_big",
}

local assets =
{
    Asset("ANIM", "anim/dragonfly_furnace.zip"),
    Asset("MINIMAP_IMAGE", "dragonfly_furnace"),
}

local function getstatus(inst)
    return "HIGH"
end

local function onworkfinished(inst)
	inst.components.lootdropper:DropLoot()	
	inst.components.container:DropEverything()
    inst.components.container:Close()	
	local fx = SpawnPrefab("collapse_big")
    fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
    fx:SetMaterial("metal")
    inst:Remove()
end

local function onworked(inst)
    if inst._task2 ~= nil then
        inst._task2:Cancel()
        inst._task2 = nil

        inst.SoundEmitter:PlaySound("dontstarve/common/together/dragonfly_furnace/fire_LP", "loop")

        if inst._task1 ~= nil then
            inst._task1:Cancel()
            inst._task1 = nil
        end
    end
    inst.AnimState:PlayAnimation("hi_hit")
    inst.AnimState:PushAnimation("hi")
end

local scaledfurnace =
{
    widget =
    {
        slotpos =
        {
            Vector3(-37.5, 32 + 4, 0), 
            Vector3(37.4, 32 + 4, 0),
            Vector3(-37.5, -(32 + 4), 0), 
            Vector3(37.5, -(32 + 4), 0),
        },
        animbank = "ui_bundle_2x2",
        animbuild = "ui_bundle_2x2",
        pos = Vector3(0, 200, 0),
        side_align_tip = 120,
		buttoninfo  =
		{
			text = STRINGS.ACTIONS.COOK, --"Burn",
			position = Vector3(0, -100, 0),
			fn = function(inst)
				if inst.components.container ~= nil then
        			inst.components.container:Close()
    			elseif inst.replica.container ~= nil and not inst.replica.container:IsBusy() then
        			inst.replica.container:Close() --doesn't trigger burn function :\
    			end
			end,
			validfn = function(inst)
				local button_check = false
				if inst.components.container ~= nil then
        			for i = 1, inst.components.container:GetNumSlots() do
	        			local item = inst.components.container:GetItemInSlot(i)
	     				if item then 
	     					if item.components.cookable or item.components.burnable then 
		     					button_check = true
		     				end  
						end
					end
    			elseif inst.replica.container ~= nil and not inst.replica.container:IsBusy() then
        			button_check = false --button always unavaliable for client (HOW TO trigger this sh..?)
    			end
    			return inst.replica.container ~= nil and button_check
			end,
		}
    },
    type = "chest",
	itemtestfn = function(container, item, slot)
	    if item.prefab == "rabbit" then --there some problems with attempt to cook rabbits, so..
	        return false
	    end
		
		if item.components.cookable or item.components.burnable then
	        return true
	    end
		
		for k, v in pairs(FOODTYPE) do --keep burned things inside
	        if item:HasTag("edible_"..v) then
	            return true
	        end
	    end
				
	    return false
	end,
}

local oldwidgetsetup = containers.widgetsetup
function containers.widgetsetup(container, prefab, data, ...)
	if container.inst.prefab == "dragonflyfurnace" or prefab == "dragonflyfurnace" then
        for k, v in pairs(scaledfurnace) do
            container[k] = v
        end
        container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
        return
	end
	
    return oldwidgetsetup(container, prefab, data, ...)
end

local function onopen(inst)
    inst.AnimState:PlayAnimation("hi_hit")
	inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/dragonling/angry")
end
	
local function onclose(inst)
    local play_burn_animation = false
				
	for i = 1, inst.components.container:GetNumSlots() do --stealed from packim (shipwrecked dlc)
        local item = inst.components.container:GetItemInSlot(i)
     	if item then 
     		local replacement = nil 
	     	if item.components.cookable then 
	     		replacement = item.components.cookable.product --GetProduct unavaliable for DST
	     	elseif item.components.burnable then 
	     		replacement = "ash"
	     	end  
	     	if replacement then 
     			local stacksize = 1 
     			if item.components.stackable then 
     				stacksize = item.components.stackable:StackSize()
     			end 
     			local newprefab = SpawnPrefab(replacement)
     			if newprefab.components.stackable then 
     				newprefab.components.stackable:SetStackSize(stacksize)
     			end
				if item.components.perishable ~= nil and
               		newprefab.components.perishable ~= nil and
               		not item:HasTag("smallcreature") then
               		local new_percent = 1 - (1 - item.components.perishable:GetPercent()) * .5
               		newprefab.components.perishable:SetPercent(new_percent)
           		end
     			inst.components.container:RemoveItemBySlot(i)
     			item:Remove()
     			inst.components.container:GiveItem(newprefab, i)
					
				play_burn_animation = true
     		end 
		end 
	end 
		
	if play_burn_animation then
		inst.AnimState:PushAnimation("hi_pre", false)
    	inst.AnimState:PushAnimation("hi")
		inst.SoundEmitter:PlaySound("dontstarve/common/together/dragonfly_furnace/light")
	else
		inst.AnimState:PlayAnimation("hi_hit")
		inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/dragonling/angry")
	end
end

local function BuiltTimeLine1(inst)
    inst._task1 = nil
    inst.SoundEmitter:PlaySound("dontstarve/common/fireAddFuel")
end

local function BuiltTimeLine2(inst)
    inst._task2 = nil
    inst.SoundEmitter:PlaySound("dontstarve/common/together/dragonfly_furnace/light")
    inst.SoundEmitter:PlaySound("dontstarve/common/together/dragonfly_furnace/fire_LP", "loop")
end

local function onbuilt(inst)
    inst.AnimState:PlayAnimation("place")
    inst.AnimState:PushAnimation("hi_pre", false)
    inst.AnimState:PushAnimation("hi")
    inst.SoundEmitter:KillSound("loop")
    inst.SoundEmitter:PlaySound("dontstarve/common/together/dragonfly_furnace/place")
    if inst._task2 ~= nil then
        inst._task2:Cancel()
        if inst._task1 ~= nil then
            inst._task1:Cancel()
        end
    end
    inst._task1 = inst:DoTaskInTime(30 * FRAMES, BuiltTimeLine1)
    inst._task2 = inst:DoTaskInTime(40 * FRAMES, BuiltTimeLine2)
end

local function onsavesalad(inst, data)
    data.salad = true
end

local function makesalad(inst)
    inst.AnimState:SetMultColour(.1, 1, .1, 1)

    inst:AddComponent("named")
    inst.components.named:SetName("Salad Furnace")

    inst.OnSave = onsavesalad
end

local function onload(inst, data)
    if data ~= nil and data.salad then
        makesalad(inst)
    end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddLight()
    inst.entity:AddNetwork()

    MakeObstaclePhysics(inst, .5)

    inst.MiniMapEntity:SetIcon("dragonfly_furnace.png")

    inst.Light:Enable(true)
    inst.Light:SetRadius(1.0)
    inst.Light:SetFalloff(.9)
    inst.Light:SetIntensity(0.5)
    inst.Light:SetColour(235 / 255, 121 / 255, 12 / 255)

    inst.AnimState:SetBank("dragonfly_furnace")
    inst.AnimState:SetBuild("dragonfly_furnace")
    inst.AnimState:PlayAnimation("hi", true)
    inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
    inst.AnimState:SetLightOverride(0.4)

    inst:AddTag("structure")
    inst:AddTag("wildfireprotected")
    inst:AddTag("iceblocker")

    --cooker (from cooker component) added to pristine state for optimization
    inst:AddTag("cooker")

    --HASHEATER (from heater component) added to pristine state for optimization
    inst:AddTag("HASHEATER")

    inst.SoundEmitter:PlaySound("dontstarve/common/together/dragonfly_furnace/fire_LP", "loop")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    -----------------------	
	inst:AddComponent("container")
	inst.components.container:WidgetSetup("dragonflyfurnace", scaledfurnace)
    inst.components.container.onopenfn = onopen
    inst.components.container.onclosefn = onclose
    
	inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(6)
    inst.components.workable:SetOnFinishCallback(onworkfinished)
    inst.components.workable:SetOnWorkCallback(onworked)

    -----------------------
    inst:AddComponent("cooker")
    inst:AddComponent("lootdropper")

    -----------------------
    inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = getstatus

    -----------------------
    inst:AddComponent("heater")
    inst.components.heater.heat = 115

    -----------------------
    MakeHauntableWork(inst)

    inst:ListenForEvent("onbuilt", onbuilt)
    inst.OnLoad = onload

    return inst
end

local function saladfurnacefn()
    local inst = fn()

    inst:SetPrefabName("dragonflyfurnace")

    if not TheWorld.ismastersim then
        return inst
    end

    makesalad(inst)

    return inst
end

return Prefab("dragonflyfurnace", fn, assets, prefabs),
       Prefab("saladfurnace", saladfurnacefn, assets, prefabs),
       MakePlacer("dragonflyfurnace_placer", "dragonfly_furnace", "dragonfly_furnace", "idle")
