--[[
>--->> Lazy Furnace <<---<
current version: 10-208516
release data: 17:21, 3 Mar
]]--

local require = GLOBAL.require
local containers = require "containers"
local Vector3 = GLOBAL.Vector3
local STRINGS = GLOBAL.STRINGS
local FOODTYPE = GLOBAL.FOODTYPE
local SpawnPrefab = GLOBAL.SpawnPrefab

--if somebody can teach me about things like replica/component 
--        please write to tykvesh@gmail.com. Thanks!

--replaced dragonfurnace.lua instead
--[[scaledfurnace =
{
    widget =
    {
        slotpos =
        {
            Vector3(-37.5, 32 + 4, 0), 
            Vector3(37.4, 32 + 4, 0),
            Vector3(-37.5, -(32 + 4), 0), 
            Vector3(37.5, -(32 + 4), 0),
        },
        animbank = "ui_bundle_2x2",
        animbuild = "ui_bundle_2x2",
        pos = Vector3(0, 200, 0),
        side_align_tip = 120,
		buttoninfo  =
		{
			text = STRINGS.ACTIONS.COOK, --"Burn",
			position = Vector3(0, -100, 0),
			fn = function(inst)
				if inst.components.container ~= nil then
        			inst.components.container:Close()
    			elseif inst.replica.container ~= nil and not inst.replica.container:IsBusy() then
        			inst.replica.container:Close() --doesn't trigger burn function :\
    			end
			end,
			validfn = function(inst)
				local button_check = false
				if inst.components.container ~= nil then
        			for i = 1, inst.components.container:GetNumSlots() do
	        			local item = inst.components.container:GetItemInSlot(i)
	     				if item then 
	     					if item.components.cookable or item.components.burnable then 
		     					button_check = true
		     				end  
						end
					end
    			elseif inst.replica.container ~= nil and not inst.replica.container:IsBusy() then
        			button_check = false --button always unavaliable for client (HOW TO trigger this sh..?)
    			end
    			return inst.replica.container ~= nil and button_check
			end,
		}
    },
    type = "chest",
	itemtestfn = function(container, item, slot)
	    if item.prefab == "rabbit" then --there some problems with attempt to cook rabbits, so..
	        return false
	    end
		
		if item.components.cookable or item.components.burnable then
	        return true
	    end
		
		for k, v in pairs(FOODTYPE) do --keep burned things inside
	        if item:HasTag("edible_"..v) then
	            return true
	        end
	    end
				
	    return false
	end,
}

local oldwidgetsetup = containers.widgetsetup
function containers.widgetsetup(container, prefab, data, ...)
	if container.inst.prefab == "dragonflyfurnace" or prefab == "dragonflyfurnace" then
        for k, v in pairs(scaledfurnace) do
            container[k] = v
        end
        container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
        return
	end
	
    return oldwidgetsetup(container, prefab, data, ...)
end

AddPrefabPostInit("dragonflyfurnace", function(inst)
	local function onworkfinished(inst)
	    inst.components.lootdropper:DropLoot()
    	if inst.components.container ~= nil then
            inst.components.container:DropEverything()
            inst.components.container:Close()
        end
		local fx = SpawnPrefab("collapse_big")
    	fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
    	fx:SetMaterial("metal")
    	inst:Remove()
	end
	
	local function onopen(inst)
    	inst.AnimState:PlayAnimation("hi_hit")
		inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/dragonling/angry")
	end
	
	local function onclose(inst)
        local play_burn_animation = false
				
		for i = 1, inst.components.container:GetNumSlots() do --stealed from packim (shipwrecked dlc)
	        local item = inst.components.container:GetItemInSlot(i)
	     	if item then 
	     		local replacement = nil 
		     	if item.components.cookable then 
		     		replacement = item.components.cookable.product --GetProduct unavaliable for DST
		     	elseif item.components.burnable then 
		     		replacement = "ash"
		     	end  
		     	if replacement then 
	     			local stacksize = 1 
	     			if item.components.stackable then 
	     				stacksize = item.components.stackable:StackSize()
	     			end 
	     			local newprefab = SpawnPrefab(replacement)
	     			if newprefab.components.stackable then 
	     				newprefab.components.stackable:SetStackSize(stacksize)
	     			end
					if item.components.perishable ~= nil and
                		newprefab.components.perishable ~= nil and
                		not item:HasTag("smallcreature") then
                		local new_percent = 1 - (1 - item.components.perishable:GetPercent()) * .5
                		newprefab.components.perishable:SetPercent(new_percent)
            		end
	     			inst.components.container:RemoveItemBySlot(i)
	     			item:Remove()
	     			inst.components.container:GiveItem(newprefab, i)
					
					play_burn_animation = true
	     		end 
		     end 
		end 
		
		if play_burn_animation then
			inst.AnimState:PushAnimation("hi_pre", false)
    		inst.AnimState:PushAnimation("hi")
			inst.SoundEmitter:PlaySound("dontstarve/common/together/dragonfly_furnace/light")
		else
			inst.AnimState:PlayAnimation("hi_hit")
			inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/together/dragonling/angry")
		end
	end 
	
	inst:AddComponent("container")
    inst.components.container:WidgetSetup("dragonflyfurnace", scaledfurnace)
    inst.components.container.onopenfn = onopen
    inst.components.container.onclosefn = onclose
	
	inst.components.workable:SetOnFinishCallback(onworkfinished)
end)]]