local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

    Asset( "IMAGE", "images/saveslot_portraits/wharang.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/wharang.xml" ),
    Asset( "IMAGE", "images/selectscreen_portraits/wharang.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wharang.xml" ),
    Asset( "IMAGE", "images/selectscreen_portraits/wharang_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wharang_silho.xml" ),
    Asset( "IMAGE", "bigportraits/wharang.tex" ),
    Asset( "ATLAS", "bigportraits/wharang.xml" ),
	Asset( "IMAGE", "images/minimapicons/wharang.tex" ),
	Asset( "ATLAS", "images/minimapicons/wharang.xml" ),
	Asset( "IMAGE", "images/minimapicons/wharang_evil.tex" ),
	Asset( "ATLAS", "images/minimapicons/wharang_evil.xml" ),
	Asset( "SOUNDPACKAGE" , "sound/foxpointup.fev" ),
	Asset( "SOUND" , "sound/foxpointup.fsb" ),
	
	Asset( "ANIM", "anim/wharang.zip" ),
	Asset( "ANIM", "anim/wharangW.zip" ),	
}

local prefabs =
{
	 "wharang_spirit",
	 "wharang_spirit_evil",
}

local start_inv = 
{
	 "mihobell",
	 "handfan",
	 --"foxtail1",
	 "sakurahat",
}

local function RandomTalk(sayings) 
    return sayings[math.random(#sayings)]
end

local function SoulHeat_Collect(inst)
	local max_soulheart = TUNING.SOULHEART_MAX
	local collect_soul = math.min(inst.soulheart, max_soulheart)

	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.health.maxhealth = math.ceil (TUNING.WHARANG_HEALTH_S + collect_soul * TUNING.WHARANG_HEALTH_PLUS) --280
	inst.components.hunger.max = math.ceil (TUNING.WHARANG_HUNGER_S + collect_soul * TUNING.WHARANG_HUNGER_PLUS) --185
	inst.components.sanity.max = math.ceil (TUNING.WHARANG_SANITY_S + collect_soul * TUNING.WHARANG_SANITY_PLUS) --450

	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)

end

local function SanityFn(inst)
	local x,y,z = inst.Transform:GetWorldPosition()	
	local delta = 0
	local max_rad = 10
	local ents = TheSim:FindEntities(x,y,z, max_rad, {"fire"})
    for k,v in pairs(ents) do 
    	if v.components.burnable and v.components.burnable.burning then
    		local sz = TUNING.SANITYAURA_TINY
    		local rad = v.components.burnable:GetLargestLightRadius() or 1
    		sz = sz * ( math.min(max_rad, rad) / max_rad )
			local distsq = inst:GetDistanceSqToInst(v)
			delta = delta + sz/math.max(1, distsq)
    	end
    end
    
    return delta
end

local function MonsterAttackAura(target)
	if (target:HasTag("monster") and not target:HasTag("shadowcreature")) then
		return true
	end
	return false
end

local function EvilAura(inst, dt)
	if inst.strength == "wharang_san_5" then
    local auraRange = 2.5
	local hits = inst.components.combat:DoAreaAttack(inst, auraRange, inst, MonsterAttackAura) end
end

local function StormCaller(inst)
	if inst.components.sanity.current <= 25 and not GetSeasonManager():IsRaining() then
		GetSeasonManager():StartPrecip()
		if inst.components.sanity.current <= 25 then
		end
	end
	if inst.components.sanity.current >= 50 and GetSeasonManager():IsRaining() and inst.rainstartedatsanity <= 25 then
		GetSeasonManager():StopPrecip()
	end
	if not GetSeasonManager():IsRaining() then
	end
end

local function SoulHeart_Get_FX(inst)
	inst.components.talker:Say((GetString(inst.prefab,"ANNOUNCE_SHOW_COLLECT_SOULHEART")).."\n".. (inst.soulheart))
	inst.SoundEmitter:PlaySound("foxpointup/foxpoint/pointup")
	SpawnPrefab("sparklefx").Transform:SetPosition(inst:GetPosition():Get())
	SpawnPrefab("wharang_multifireworkfx").Transform:SetPosition(inst.Transform:GetWorldPosition())
	
	inst.HUD.controls.status.heart:PulseGreen();inst.HUD.controls.status.stomach:PulseGreen();inst.HUD.controls.status.brain:PulseGreen()
	inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7);inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7);inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
end
local function SoulHeart_Get_SPIRIT(inst, data)
	if data.inst:HasTag("smallcreature") and not data.inst:HasTag("monster") then
		local fx = SpawnPrefab("wharang_spiritfx")
		fx.Transform:SetPosition(data.inst:GetPosition():Get());fx.Transform:SetScale(.5,.5,.5)
	elseif data.inst:HasTag("largecreature") and not data.inst:HasTag("monster") then
		local fx = SpawnPrefab("wharang_spiritfx")
		fx.Transform:SetPosition(data.inst:GetPosition():Get());fx.Transform:SetScale(1.2,1.2,1.2)
	elseif data.inst:HasTag("monster") then
		local fx = SpawnPrefab("wharang_spirit_evilfx")
		fx.Transform:SetPosition(data.inst:GetPosition():Get());fx.Transform:SetScale(.7,.7,.7)
	else
		local fx = SpawnPrefab("wharang_spiritfx")
		fx.Transform:SetPosition(data.inst:GetPosition():Get());fx.Transform:SetScale(.7,.7,.7)
	end
end

local function SoulHeat_OnKill(inst, data)
local shadow_spawn = .01

	if data.cause == inst.prefab  and data.inst:HasTag("monster") and not data.inst:HasTag("veggie") and not data.inst:HasTag("structure") and not data.inst:HasTag("companion") then
		if math.random() < shadow_spawn and data.inst:HasTag("monster") then
			SpawnPrefab("shadowbeak").Transform:SetPosition(inst.Transform:GetWorldPosition())
			SpawnPrefab("sanity_raise").Transform:SetPosition(inst.Transform:GetWorldPosition())
		end
	end

local time = data.inst.components.health.destroytime or 2

	if data.cause == inst.prefab
		and not data.inst:HasTag("prey") and not data.inst:HasTag("veggie") and not data.inst:HasTag("insect") and not data.inst:HasTag("structure") and not data.inst:HasTag("player")
		and not data.inst:HasTag("ghost") and not data.inst:HasTag("birchnutdrake") and not data.inst:HasTag("shadow") and not data.inst:HasTag("companion") and not data.inst.components.health.nofadeout then
		
		if data.inst.prefab == "tentacle_pillar_arm" then
			if math.random() < TUNING.SOULHEART_FROM_BABYTENTACLE_CHANCE then
				inst.soulheart = inst.soulheart + 1;SoulHeat_Collect(inst);SoulHeart_Get_FX(inst)
				inst:DoTaskInTime(time, function() SoulHeart_Get_SPIRIT(inst, data) end) end
		elseif data.inst:HasTag("leif") then
			if math.random() < TUNING.SOULHEART_FROM_LEIF_CHANCE then
				inst.soulheart = inst.soulheart + 1;SoulHeat_Collect(inst);SoulHeart_Get_FX(inst)
				inst:DoTaskInTime(time, function() SoulHeart_Get_SPIRIT(inst, data) end) end
		elseif data.inst:HasTag("warg") then
			if math.random() < TUNING.SOULHEART_FROM_VARG_CHANCE then
				inst.soulheart = inst.soulheart + 1;SoulHeat_Collect(inst);SoulHeart_Get_FX(inst)
				inst:DoTaskInTime(time, function() SoulHeart_Get_SPIRIT(inst, data) end) end
		elseif data.inst:HasTag("spiderqueen") then
			if math.random() < TUNING.SOULHEART_FROM_SPIDERQUEEN_CHANCE then
				inst.soulheart = inst.soulheart + 1;SoulHeat_Collect(inst);SoulHeart_Get_FX(inst)
				inst:DoTaskInTime(time, function() SoulHeart_Get_SPIRIT(inst, data) end) end
		elseif data.inst:HasTag("minotaur") then
			if math.random() < TUNING.SOULHEART_FROM_MINOTAUR_CHANCE then
				inst.soulheart = inst.soulheart + 1;SoulHeat_Collect(inst);SoulHeart_Get_FX(inst)
				inst:DoTaskInTime(time, function() SoulHeart_Get_SPIRIT(inst, data) end) end
		elseif data.inst:HasTag("manrabbit") or data.inst:HasTag("merm") or data.inst:HasTag("rocky") or data.inst:HasTag("pig") then
			if math.random() < TUNING.SOULHEART_FROM_MANFRIEND_CHANCE then
				inst.soulheart = inst.soulheart + 1;SoulHeat_Collect(inst);SoulHeart_Get_FX(inst)
				inst:DoTaskInTime(time, function() SoulHeart_Get_SPIRIT(inst, data) end) end
		elseif data.inst:HasTag("spider") then
			if math.random() < TUNING.SOULHEART_FROM_SPIDER_CHANCE then
				inst.soulheart = inst.soulheart + 1;SoulHeat_Collect(inst);SoulHeart_Get_FX(inst)
				inst:DoTaskInTime(time, function() SoulHeart_Get_SPIRIT(inst, data) end) end
		elseif data.inst:HasTag("hound") then
			if math.random() < TUNING.SOULHEART_FROM_HOUND_CHANCE then
				inst.soulheart = inst.soulheart + 1;SoulHeat_Collect(inst);SoulHeart_Get_FX(inst)
				inst:DoTaskInTime(time, function() SoulHeart_Get_SPIRIT(inst, data) end) end
		elseif data.inst:HasTag("epic") then
			if math.random() < TUNING.SOULHEART_FROM_BOSS_CHANCE then
				inst.soulheart = inst.soulheart + 1;SoulHeat_Collect(inst);SoulHeart_Get_FX(inst)
				inst:DoTaskInTime(time, function() SoulHeart_Get_SPIRIT(inst, data) end) end
		elseif data.inst:HasTag("prey") or data.inst:HasTag("bird") or data.inst:HasTag("insect") then
			if math.random() < TUNING.SOULHEART_FROM_PREY_CHANCE then
				inst.soulheart = inst.soulheart + 1;SoulHeat_Collect(inst);SoulHeart_Get_FX(inst)
				inst:DoTaskInTime(time, function() SoulHeart_Get_SPIRIT(inst, data) end) end
		end
	end
end

local function SoulHeat_OnEat(inst, food)

	if math.random() < TUNING.SOULHEART_FROM_MEAT and food and food.components.edible.foodtype == "MEAT" then
		inst.soulheart = inst.soulheart + 1;SoulHeat_Collect(inst);SoulHeart_Get_FX(inst)

		local pos = Vector3(inst.Transform:GetWorldPosition());pos.y = pos.y + 1
		
		if inst.components.eater and (food.prefab == "monstermeat" or food.prefab == "cookedmonstermeat" or food.prefab == "monstermeat_dried" or food.prefab == "monsterlasagna") then
			local spirit_evil = SpawnPrefab("wharang_spirit_evilfx");spirit_evil.Transform:SetPosition(pos:Get());spirit_evil.Transform:SetScale(.5,.5,.5)
		else
			local spirit = SpawnPrefab("wharang_spiritfx");spirit.Transform:SetPosition(pos:Get());spirit.Transform:SetScale(.5,.5,.5)
		end
	end
	
	if food and food.components.edible.foodtype == "MEAT" then
		if inst.soulheart >= TUNING.SOULHEART_COLLET_1 then if math.random() < TUNING.WHARANG_EAT_PRANK_1 then
			local pos = Vector3(inst.Transform:GetWorldPosition());pos.z = pos.z + math.random();pos.x = pos.x + math.random()
			local item = {"crow","feather_crow","spider","fish","froglegs","rabbit","bee","eel","butterfly","pigskin","tentaclespots","stinger"}
			local randomitem = item[math.random(#item)]
			SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition());SpawnPrefab(randomitem).Transform:SetPosition(pos:Get()) end
		end
		if inst.soulheart >= TUNING.SOULHEART_COLLET_2 then if math.random() < TUNING.WHARANG_EAT_PRANK_2 then
			local pos = Vector3(inst.Transform:GetWorldPosition());pos.z = pos.z + math.random();pos.x = pos.x + math.random()
			local item = {"rope","cutstone","boards","papyrus","charcoal","ash","twigs","rocks","cutgrass","cutreeds","log","nitre"}
			local randomitem = item[math.random(#item)]
			SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition());SpawnPrefab(randomitem).Transform:SetPosition(pos:Get()) end
		end
		if inst.soulheart >= TUNING.SOULHEART_COLLET_3 then if math.random() < TUNING.WHARANG_EAT_PRANK_3 then
			local pos = Vector3(inst.Transform:GetWorldPosition());pos.z = pos.z + math.random();pos.x = pos.x + math.random()
			local item = {"silk","beefalowool","manrabbit_tail","beardhair","slurper_pelt","slurtleslime","honeycomb"}
			local randomitem = item[math.random(#item)]
			SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition());SpawnPrefab(randomitem).Transform:SetPosition(pos:Get()) end
		end
		if inst.soulheart >= TUNING.SOULHEART_COLLET_4 then if math.random() < TUNING.WHARANG_EAT_PRANK_4 then
			local pos = Vector3(inst.Transform:GetWorldPosition());pos.z = pos.z + math.random();pos.x = pos.x + math.random()
			local item = {"spoiled_food","wetgoop","powcake","monsterlasagna","meatballs","honeyham","honeycomb","taffy","unagi","honey","cutlichen"}
			local randomitem = item[math.random(#item)]
			SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition());SpawnPrefab(randomitem).Transform:SetPosition(pos:Get()) end
		end
		if inst.soulheart >= TUNING.SOULHEART_COLLET_5 then if math.random() < TUNING.WHARANG_EAT_PRANK_5 then
			local pos = Vector3(inst.Transform:GetWorldPosition());pos.z = pos.z + math.random();pos.x = pos.x + math.random()
			local item = {"gears","petals_evil","foliage","nightmarefuel","goldnugget","thulecite","thulecite_pieces","redgem","bluegem","yellowgem"}
			local randomitem = item[math.random(#item)]
			SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition());SpawnPrefab(randomitem).Transform:SetPosition(pos:Get()) end
		end
	end
end

-------------------------------------------Party
local function Show_Party(inst, dt)
	if inst:HasTag("FireFoxAttack") then
		if not inst:HasTag("PartyEnd") then
			inst.party_time = inst.party_time - dt
			if inst.party_time <= 0 then
				inst.party_time = .35
				local nightmare = SpawnPrefab("wharang_ground_firefx")
				nightmare.Transform:SetPosition(inst.Transform:GetWorldPosition())
				nightmare.Transform:SetScale(.25,.25,.25)
	    	end
	    end
	end
end

local function PartyEnd(inst)
	if inst.PartyTime > 0 then
		inst.PartyTime = inst.PartyTime-1
	else
		inst:RemoveTag("PartyEnd")
		inst.components.talker:Say(GetString(inst.prefab,"ANNOUNCE_CAN_PARTY"))
		if inst.party_task then inst.party_task:Cancel() inst.party_task = nil end
	end
end

local function Start_Fire_Party(inst, data)
local other = data.target
if other
and not other:HasTag("veggie")
and not other:HasTag("structure")
and not other:HasTag("companion") then

	if inst:HasTag("FireFoxAttack") then
		if not inst:HasTag("PartyEnd") then
			 inst.components.sanity:DoDelta(TUNING.SOULHEART_FIREWORK_DELTA_SAN)
			 inst.components.playercontroller:ShakeCamera(inst, "FULL", 0.5, 0.02, 1.5, 30)
			 inst.components.groundpounderds.groundpoundfx = "wharang_ground_firefx"
			 inst.components.groundpounderds.groundpoundringfx = "wharang_ringfx"
			if (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
			 inst.components.groundpounderds.numRings = TUNING.SOULHEART_FIREWORK_RANK_1_RING
			 inst.components.groundpounderds.damageRings = TUNING.SOULHEART_FIREWORK_RANK_1_RING_DAM
			 inst.components.groundpounderds.groundpounddamagemult = TUNING.SOULHEART_FIREWORK_RANK_1_MULT_DAM
			 inst.PartyTime = TUNING.SOULHEART_FIREWORK_RANK_1_TIME
			elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
			 inst.components.groundpounderds.numRings = TUNING.SOULHEART_FIREWORK_RANK_2_RING
			 inst.components.groundpounderds.damageRings = TUNING.SOULHEART_FIREWORK_RANK_2_RING_DAM
			 inst.components.groundpounderds.groundpounddamagemult = TUNING.SOULHEART_FIREWORK_RANK_2_MULT_DAM
			 inst.Bonus_Party_1 = inst:DoPeriodicTask(1, function() inst.components.groundpounderds:GroundPound() if inst.Bonus_Party_1 then inst.Bonus_Party_1:Cancel() inst.Bonus_Party_1 = nil end end)
			 inst.PartyTime = TUNING.SOULHEART_FIREWORK_RANK_2_TIME
			elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
			 inst.components.groundpounderds.numRings = TUNING.SOULHEART_FIREWORK_RANK_3_RING
			 inst.components.groundpounderds.damageRings = TUNING.SOULHEART_FIREWORK_RANK_3_RING_DAM
			 inst.components.groundpounderds.groundpounddamagemult = TUNING.SOULHEART_FIREWORK_RANK_3_MULT_DAM
			 inst.Bonus_Party_2 = inst:DoPeriodicTask(1, function() inst.components.groundpounderds:GroundPound() if inst.Bonus_Party_2 then inst.Bonus_Party_2:Cancel() inst.Bonus_Party_2 = nil end end)
			 inst.PartyTime = TUNING.SOULHEART_FIREWORK_RANK_3_TIME
			elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) then
			 inst.components.groundpounderds.numRings = TUNING.SOULHEART_FIREWORK_RANK_4_RING
			 inst.components.groundpounderds.damageRings = TUNING.SOULHEART_FIREWORK_RANK_4_RING_DAM
			 inst.components.groundpounderds.groundpounddamagemult = TUNING.SOULHEART_FIREWORK_RANK_4_MULT_DAM
			 inst.Bonus_Party_3 = inst:DoPeriodicTask(.5, function() inst.components.groundpounderds:GroundPound() if inst.Bonus_Party_3 then inst.Bonus_Party_3:Cancel() inst.Bonus_Party_3 = nil end end)
			 inst.Bonus_Party_4 = inst:DoPeriodicTask(1, function() inst.components.groundpounderds:GroundPound() if inst.Bonus_Party_4 then inst.Bonus_Party_4:Cancel() inst.Bonus_Party_4 = nil end end)
			 inst.PartyTime = TUNING.SOULHEART_FIREWORK_RANK_4_TIME
			end
			 inst.components.groundpounderds:GroundPound()
			 inst:AddTag("PartyEnd");inst:RemoveTag("FireFoxAttack")
			 inst.party_task = inst:DoPeriodicTask(1/10, function() PartyEnd(inst) end)
		elseif inst:HasTag("PartyEnd") then
		end
	end
end
end

local function TheEvilWhite(inst, dt)
    if inst.strength == "wharang_san_5" then
    	inst.nightmare_time = inst.nightmare_time - dt
    	if inst.nightmare_time <= 0 then
    		inst.nightmare_time = 1
			local pos = Vector3(inst.Transform:GetWorldPosition())
			pos.y = pos.y + .5
			local nightmare = SpawnPrefab("statue_transition_2")
			nightmare.Transform:SetPosition(pos:Get())
    	end
    end
end





local function Wharang_Staus__Day_Yokai_San1(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN1_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN1_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN1_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN1_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN1_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN1_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN1_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN1_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN1_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN1_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN1_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN1_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN1_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN1_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN1_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN1_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN1_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN1_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN1_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN1_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN1_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN1_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN1_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN1_SOUL5_ABS
	end
end
local function Wharang_Staus__Day_Yokai_San2(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN2_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN2_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN2_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN2_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN2_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN2_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN2_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN2_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN2_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN2_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN2_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN2_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN2_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN2_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN2_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN2_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN2_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN2_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN2_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN2_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN2_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN2_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN2_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN2_SOUL5_ABS
	end
end
local function Wharang_Staus__Day_Yokai_San3(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN3_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN3_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN3_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN3_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN3_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN3_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN3_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN3_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN3_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN3_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN3_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN3_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN3_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN3_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN3_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN3_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN3_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN3_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN3_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN3_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN3_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN3_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN3_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN3_SOUL5_ABS
	end
end
local function Wharang_Staus__Day_Yokai_San4(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN4_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN4_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN4_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN4_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN4_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN4_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN4_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN4_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN4_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN4_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN4_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN4_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN4_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN4_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN4_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN4_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN4_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN4_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN4_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN4_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_Y_SAN4_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_Y_SAN4_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_Y_SAN4_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_Y_SAN4_SOUL5_ABS
	end
end
local function Wharang_Staus__Day_White_San5(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_W_SAN5_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_W_SAN5_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_W_SAN5_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_W_SAN5_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_W_SAN5_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_W_SAN5_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_W_SAN5_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_W_SAN5_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_W_SAN5_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_W_SAN5_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_W_SAN5_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_W_SAN5_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_W_SAN5_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_W_SAN5_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_W_SAN5_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_W_SAN5_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_W_SAN5_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_W_SAN5_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_W_SAN5_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_W_SAN5_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DAY_W_SAN5_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DAY_W_SAN5_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DAY_W_SAN5_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_DAY_W_SAN5_SOUL5_ABS
	end
end
local function Wharang_Staus__Dsk_Yokai_San1(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN1_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN1_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN1_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN1_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN1_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN1_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN1_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN1_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN1_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN1_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN1_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN1_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN1_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN1_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN1_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN1_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN1_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN1_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN1_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN1_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN1_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN1_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN1_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN1_SOUL5_ABS
	end
end
local function Wharang_Staus__Dsk_Yokai_San2(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN2_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN2_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN2_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN2_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN2_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN2_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN2_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN2_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN2_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN2_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN2_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN2_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN2_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN2_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN2_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN2_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN2_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN2_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN2_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN2_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN2_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN2_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN2_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN2_SOUL5_ABS
	end
end
local function Wharang_Staus__Dsk_Yokai_San3(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN3_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN3_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN3_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN3_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN3_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN3_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN3_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN3_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN3_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN3_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN3_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN3_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN3_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN3_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN3_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN3_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN3_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN3_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN3_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN3_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN3_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN3_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN3_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN3_SOUL5_ABS
	end
end
local function Wharang_Staus__Dsk_Yokai_San4(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN4_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN4_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN4_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN4_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN4_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN4_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN4_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN4_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN4_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN4_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN4_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN4_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN4_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN4_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN4_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN4_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN4_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN4_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN4_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN4_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_Y_SAN4_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_Y_SAN4_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_Y_SAN4_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_Y_SAN4_SOUL5_ABS
	end
end
local function Wharang_Staus__Dsk_White_San5(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_W_SAN5_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_W_SAN5_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_W_SAN5_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_W_SAN5_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_W_SAN5_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_W_SAN5_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_W_SAN5_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_W_SAN5_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_W_SAN5_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_W_SAN5_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_W_SAN5_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_W_SAN5_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_W_SAN5_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_W_SAN5_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_W_SAN5_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_W_SAN5_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_W_SAN5_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_W_SAN5_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_W_SAN5_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_W_SAN5_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_DSK_W_SAN5_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_DSK_W_SAN5_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_DSK_W_SAN5_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_DSK_W_SAN5_SOUL5_ABS
	end
end
local function Wharang_Staus__Noct_Yokai_San1(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN1_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN1_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN1_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN1_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN1_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN1_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN1_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN1_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN1_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN1_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN1_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN1_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN1_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN1_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN1_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN1_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN1_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN1_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN1_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN1_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN1_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN1_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN1_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN1_SOUL5_ABS
	end
end
local function Wharang_Staus__Noct_Yokai_San2(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN2_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN2_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN2_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN2_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN2_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN2_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN2_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN2_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN2_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN2_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN2_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN2_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN2_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN2_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN2_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN2_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN2_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN2_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN2_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN2_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN2_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN2_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN2_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN2_SOUL5_ABS
	end
end
local function Wharang_Staus__Noct_Yokai_San3(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN3_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN3_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN3_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN3_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN3_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN3_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN3_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN3_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN3_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN3_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN3_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN3_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN3_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN3_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN3_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN3_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN3_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN3_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN3_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN3_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN3_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN3_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN3_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN3_SOUL5_ABS
	end
end
local function Wharang_Staus__Noct_Yokai_San4(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN4_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN4_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN4_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN4_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN4_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN4_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN4_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN4_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN4_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN4_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN4_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN4_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN4_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN4_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN4_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN4_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN4_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN4_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN4_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN4_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_Y_SAN4_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_Y_SAN4_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_Y_SAN4_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_Y_SAN4_SOUL5_ABS
	end
end
local function Wharang_Staus__Noct_White_San5(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_W_SAN5_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_W_SAN5_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_W_SAN5_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_W_SAN5_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_W_SAN5_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_W_SAN5_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_W_SAN5_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_W_SAN5_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_W_SAN5_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_W_SAN5_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_W_SAN5_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_W_SAN5_SOUL5_ABS
	end
end

local function Wharang_Staus__Full_White_San1(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN1_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN1_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN1_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN1_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN1_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN1_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN1_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN1_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN1_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN1_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN1_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN1_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN1_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN1_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN1_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN1_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN1_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN1_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN1_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN1_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN1_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN1_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN1_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN1_SOUL5_ABS
	end
end
local function Wharang_Staus__Full_White_San2(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN2_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN2_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN2_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN2_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN2_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN2_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN2_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN2_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN2_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN2_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN2_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN2_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN2_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN2_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN2_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN2_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN2_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN2_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN2_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN2_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN2_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN2_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN2_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN2_SOUL5_ABS
	end
end
local function Wharang_Staus__Full_White_San3(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN3_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN3_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN3_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN3_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN3_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN3_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN3_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN3_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN3_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN3_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN3_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN3_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN3_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN3_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN3_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN3_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN3_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN3_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN3_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN3_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN3_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN3_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN3_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN3_SOUL5_ABS
	end
end
local function Wharang_Staus__Full_White_San4(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN4_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN4_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN4_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN4_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN4_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN4_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN4_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN4_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN4_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN4_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN4_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN4_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN4_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN4_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN4_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN4_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN4_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN4_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN4_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN4_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_FULL_W_SAN4_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_FULL_W_SAN4_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_FULL_W_SAN4_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_FULL_W_SAN4_SOUL5_ABS
	end
end
local function Wharang_Staus__Full_White_San5(inst)
	if (TUNING.SOULHEART_COLLET_0 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_1) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL0_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL0_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_W_SAN5_SOUL0_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_W_SAN5_SOUL0_ABS
	elseif (TUNING.SOULHEART_COLLET_1 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_2) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL1_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL1_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_W_SAN5_SOUL1_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_W_SAN5_SOUL1_ABS
	elseif (TUNING.SOULHEART_COLLET_2 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_3) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL2_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL2_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_W_SAN5_SOUL2_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_W_SAN5_SOUL2_ABS
	elseif (TUNING.SOULHEART_COLLET_3 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_4) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL3_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL3_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_W_SAN5_SOUL3_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_W_SAN5_SOUL3_ABS
	elseif (TUNING.SOULHEART_COLLET_4 <= inst.soulheart) and (inst.soulheart < TUNING.SOULHEART_COLLET_5) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL4_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL4_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_W_SAN5_SOUL4_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_W_SAN5_SOUL4_ABS
	elseif (TUNING.SOULHEART_COLLET_5 == inst.soulheart) then
		inst.components.locomotor.runspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL5_SPD;inst.components.locomotor.walkspeed=TUNING.WHARANG_NOCT_W_SAN5_SOUL5_SPD-2
		inst.components.combat.damagemultiplier=TUNING.WHARANG_NOCT_W_SAN5_SOUL5_ATK;inst.components.health.absorb=TUNING.WHARANG_NOCT_W_SAN5_SOUL5_ABS
	end
end

local function WharangStats(inst)
	if GetClock():IsDay() and not GetWorld():IsCave() then
		if inst.strength == "wharang_san_1" then		inst:AddTag("yokai_form");inst:RemoveTag("white_form");Wharang_Staus__Day_Yokai_San1(inst)
		elseif inst.strength == "wharang_san_2" then	inst:AddTag("yokai_form");inst:RemoveTag("white_form");Wharang_Staus__Day_Yokai_San2(inst)
		elseif inst.strength == "wharang_san_3" then	inst:AddTag("yokai_form");inst:RemoveTag("white_form");Wharang_Staus__Day_Yokai_San3(inst)
		elseif inst.strength == "wharang_san_4" then	inst:AddTag("yokai_form");inst:RemoveTag("white_form");Wharang_Staus__Day_Yokai_San4(inst)
		elseif inst.strength == "wharang_san_5" then	inst:AddTag("white_form");inst:RemoveTag("yokai_form");Wharang_Staus__Day_White_San5(inst)
		end
	elseif GetClock():IsDusk() or GetWorld():IsCave() then
		if inst.strength == "wharang_san_1" then		inst:AddTag("yokai_form");inst:RemoveTag("white_form");Wharang_Staus__Dsk_Yokai_San1(inst)
		elseif inst.strength == "wharang_san_2" then	inst:AddTag("yokai_form");inst:RemoveTag("white_form");Wharang_Staus__Dsk_Yokai_San2(inst)
		elseif inst.strength == "wharang_san_3" then	inst:AddTag("yokai_form");inst:RemoveTag("white_form");Wharang_Staus__Dsk_Yokai_San3(inst)
		elseif inst.strength == "wharang_san_4" then	inst:AddTag("yokai_form");inst:RemoveTag("white_form");Wharang_Staus__Dsk_Yokai_San4(inst)
		elseif inst.strength == "wharang_san_5" then	inst:AddTag("white_form");inst:RemoveTag("yokai_form");Wharang_Staus__Dsk_White_San5(inst)
		end
	elseif (GetClock():IsNight() and not (GetClock():GetMoonPhase() == "full")) then
		if inst.strength == "wharang_san_1" then		inst:AddTag("yokai_form");inst:RemoveTag("white_form");Wharang_Staus__Noct_Yokai_San1(inst)
		elseif inst.strength == "wharang_san_2" then	inst:AddTag("yokai_form");inst:RemoveTag("white_form");Wharang_Staus__Noct_Yokai_San2(inst)
		elseif inst.strength == "wharang_san_3" then	inst:AddTag("yokai_form");inst:RemoveTag("white_form");Wharang_Staus__Noct_Yokai_San3(inst)
		elseif inst.strength == "wharang_san_4" then	inst:AddTag("yokai_form");inst:RemoveTag("white_form");Wharang_Staus__Noct_Yokai_San4(inst)
		elseif inst.strength == "wharang_san_5" then	inst:AddTag("white_form");inst:RemoveTag("yokai_form");Wharang_Staus__Noct_White_San5(inst)
		end
	elseif (GetClock():IsNight() and (GetClock():GetMoonPhase() == "full")) then --full
		if inst.strength == "wharang_san_1" then		inst:AddTag("white_form");inst:RemoveTag("yokai_form");Wharang_Staus__Full_White_San1(inst)
		elseif inst.strength == "wharang_san_2" then	inst:AddTag("white_form");inst:RemoveTag("yokai_form");Wharang_Staus__Full_White_San2(inst)
		elseif inst.strength == "wharang_san_3" then	inst:AddTag("white_form");inst:RemoveTag("yokai_form");Wharang_Staus__Full_White_San3(inst)
		elseif inst.strength == "wharang_san_4" then	inst:AddTag("white_form");inst:RemoveTag("yokai_form");Wharang_Staus__Full_White_San4(inst)
		elseif inst.strength == "wharang_san_5" then	inst:AddTag("white_form");inst:RemoveTag("yokai_form");Wharang_Staus__Full_White_San5(inst)
		end
	end

	if inst:HasTag("yokai_form") then inst.AnimState:SetBuild("wharang")
		inst.MiniMapEntity:SetIcon("wharang.tex")
		inst.soundsname = "winnie"
		inst.components.eater:SetOmnivore()
		inst.components.talker.colour = Vector3(255/255, 157/255, 154/255)
		inst.components.temperature.inherentinsulation = 30
	elseif inst:HasTag("white_form") then inst.AnimState:SetBuild("wharangW")
		inst.MiniMapEntity:SetIcon("wharang_evil.tex")
		inst.soundsname = "wharang_evilwhite"
		inst.components.eater:SetCarnivore()
		inst.components.talker.colour = Vector3(54/255, 198/255, 250/255)
		inst.components.temperature.inherentinsulation = math.huge
	end
end

local function FormChange(inst)
	SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
	SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
end

local function WharangChange(inst, data)

	if inst.strength == "wharang_san_1" then
		if inst.components.sanity:GetPercent() < TUNING.WHARANG_SANCHANGE_2 then inst.strength = "wharang_san_2"
			FormChange(inst);inst.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_SAN_DOWN"))
			--print("1")
		end
		
	elseif inst.strength == "wharang_san_2" then
		if inst.components.sanity:GetPercent() < TUNING.WHARANG_SANCHANGE_3 then inst.strength = "wharang_san_3"
			FormChange(inst);inst.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_SAN_DOWN"))
			--print("2")
		elseif inst.components.sanity:GetPercent() >= TUNING.WHARANG_SANCHANGE_1 then inst.strength = "wharang_san_1"
			FormChange(inst);inst.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_SAN_UP"))
		end
		
	elseif inst.strength == "wharang_san_3" then
		if inst.components.sanity:GetPercent() < TUNING.WHARANG_SANCHANGE_4 then inst.strength = "wharang_san_4"
			FormChange(inst);inst.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_SAN_DOWN"))
			--print("3")
		elseif inst.components.sanity:GetPercent() >= TUNING.WHARANG_SANCHANGE_2 then inst.strength = "wharang_san_2"
			FormChange(inst);inst.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_SAN_UP"))
		end
		
	elseif inst.strength == "wharang_san_4" then
		if inst.components.sanity:GetPercent() < TUNING.WHARANG_SANCHANGE_5 then inst.strength = "wharang_san_5"
			FormChange(inst);inst.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_SAN_GO_EVIL"))
			--print("4")
		elseif inst.components.sanity:GetPercent() >= TUNING.WHARANG_SANCHANGE_3 then
			inst.strength = "wharang_san_3"
			FormChange(inst);inst.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_SAN_UP"))
		end
		
	elseif inst.strength == "wharang_san_5" then
		if inst.components.sanity:GetPercent() >= TUNING.WHARANG_SANCHANGE_4 then inst.strength = "wharang_san_4"
			FormChange(inst);inst.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_SAN_NO_EVIL"))
		end
		
		
	else
		if inst.components.sanity:GetPercent() >= TUNING.WHARANG_SANCHANGE_1 then inst.strength = "wharang_san_1"
		elseif inst.components.sanity:GetPercent() < TUNING.WHARANG_SANCHANGE_2 then inst.strength = "wharang_san_2"
		elseif inst.components.sanity:GetPercent() < TUNING.WHARANG_SANCHANGE_3 then inst.strength = "wharang_san_3"
		elseif inst.components.sanity:GetPercent() < TUNING.WHARANG_SANCHANGE_4 then inst.strength = "wharang_san_4"
		elseif inst.components.sanity:GetPercent() < TUNING.WHARANG_SANCHANGE_5 then inst.strength = "wharang_san_5"
	end
end
	WharangStats(inst)
end

local function Wharang_FlameBody1(inst, data)
local firefox = 1 -- 100%
	if inst.strength == "wharang_san_1" then
		if math.random() < firefox and data.attacker and data.attacker.components.burnable and data.attacker.components.health and not data.attacker:HasTag("thorny") then
			inst.components.talker:Say(RandomTalk(FLAMEHURT));inst.components.sanity:DoDelta(-4)
			data.attacker.components.burnable:Ignite()
			SpawnPrefab("foxfire").Transform:SetPosition(data.attacker.Transform:GetWorldPosition())
		end
		if data.attacker and data.attacker.components.burnable and data.attacker.components.burnable:IsBurning() then data.attacker.components.burnable:Extinguish() end
	end
end
local function Wharang_FlameBody2(inst, data)
local firefox = 1 -- 100%
	if inst.strength == "wharang_san_2" or inst.strength == "wharang_san_3" then
		if math.random() < firefox and data.attacker and data.attacker.components.burnable and data.attacker.components.health and not data.attacker:HasTag("thorny") then
			inst.components.talker:Say(RandomTalk(FLAMEHURT));inst.components.sanity:DoDelta(-2)
			data.attacker.components.health:DoDelta(-2)
			data.attacker.components.burnable:Ignite()
			SpawnPrefab("foxfire").Transform:SetPosition(inst.Transform:GetWorldPosition())
		end
		if data.attacker and data.attacker.components.burnable and data.attacker.components.burnable:IsBurning() then data.attacker.components.burnable:Extinguish() end
	end
end
local function Wharang_FlameBody3(inst, data)
local firefox = 1 -- 100%
	if inst.strength == "wharang_san_4" then
		if math.random() < firefox and data.attacker and data.attacker.components.burnable and data.attacker.components.health and not data.attacker:HasTag("thorny") then
			inst.components.talker:Say(RandomTalk(FLAMEHURT));inst.components.sanity:DoDelta(-1)
			data.attacker.components.health:DoDelta(-3)
			data.attacker.components.burnable:Ignite()
			SpawnPrefab("foxfire").Transform:SetPosition(inst.Transform:GetWorldPosition())
		end
		if data.attacker and data.attacker.components.burnable and data.attacker.components.burnable:IsBurning() then data.attacker.components.burnable:Extinguish() end
	end
end
local function Wharang_FlameBody(inst, data)
local icefox = 1 -- 100%
	if inst.strength == "wharang_san_5" then
		if math.random() < icefox and data.attacker and data.attacker.components.freezable and data.attacker.components.health and not data.attacker:HasTag("thorny") then
			inst.components.talker:Say(RandomTalk(FRZOENHURT));inst.components.sanity:DoDelta(-1)
			data.attacker.components.health:DoDelta(-1)
			data.attacker.components.freezable:AddColdness(1);data.attacker.components.freezable:SpawnShatterFX()
			SpawnPrefab("foxfire").Transform:SetPosition(inst.Transform:GetWorldPosition())
		end
	end
end

-------------------------------------------Light
local function HungerFire(inst, data)
local Light = inst.entity:AddLight()

	if GetClock():IsNight() or GetWorld():IsCave() then
		if inst:HasTag("yokai_form") and not inst:HasTag("white_form") then
			if inst.components.hunger:GetPercent() <= TUNING.WHARANG_HUNGER_NIGHTVISION then
				Light:SetRadius(0);Light:SetFalloff(0);Light:SetIntensity(0);Light:SetColour(0,0,0);Light:Enable(false)
				inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * .8)
			elseif inst.components.hunger:GetPercent() > TUNING.WHARANG_HUNGER_NIGHTVISION then
				inst.Light:SetRadius(1.1);inst.Light:SetFalloff(.7);inst.Light:SetIntensity(.5);inst.Light:SetColour(255/255,20/255,20/255);inst.Light:Enable(true)
				inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1)
			end
		elseif inst:HasTag("white_form") and not inst:HasTag("yokai_form") then
			inst.Light:SetRadius(1.1);inst.Light:SetFalloff(.7);inst.Light:SetIntensity(.5);inst.Light:SetColour(20/255,255/255,255/255);inst.Light:Enable(true)
			inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1)
		end
	else
		Light:SetRadius(0);Light:SetFalloff(0);Light:SetIntensity(0);Light:SetColour(0,0,0);Light:Enable(false)
		inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * .8)
	end
end

local function Regen(inst)
    inst.components.health:DoDelta(1)
end

local function onpreload(inst, data)
	if data then
		if data.level then
			inst.soulheart = data.level
			SoulHeat_Collect(inst)

			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
	end
	if data.timeout then
        inst.PartyTime = data.timeout
		if inst.PartyTime > 0 then
			if not inst.party_task then
				inst.party_task = inst:DoPeriodicTask(1, function() PartyEnd(inst) end)
				inst:AddTag("PartyEnd")
			end
		else
			if inst.party_task then inst.party_task:Cancel() inst.party_task = nil end
			inst:RemoveTag("PartyEnd")
		end
    end
end

local function onsave(inst, data)
	data.level = inst.soulheart
	data.timeout = (inst.PartyTime)
end

-------------------------------------------
local fn = function(inst)
	
	inst.soundsname = "winnie"
    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "wharang.tex" )
	-------------------Fox Point
	inst.soulheart = 0
	SoulHeat_Collect(inst)
	table.insert(inst.components.eater.foodprefs, "MEAT")
	-------------------Strength
	inst.strength = "wharang_san_1"
	-------------------Eater
	inst:AddComponent("eater")
    inst.components.eater:SetCanEatHorrible() 
    inst.components.eater:SetOnEatFn(SoulHeat_OnEat)
	inst.components.eater.EatMEAT = inst.components.eater.Eat
	function inst.components.eater:Eat( food )
		if self:CanEat(food) then
			if food.prefab == "meat" or food.prefab == "smallmeat" or food.prefab == "batwing" or food.prefab == "froglegs" or food.prefab == "plantmeat" then
					food.components.edible.sanityvalue = 0
			elseif food.prefab == "monstermeat" then
					food.components.edible.healthvalue = 0
					food.components.edible.sanityvalue = -30
			elseif food.prefab == "cookedmonstermeat" then
					food.components.edible.healthvalue = 0
					food.components.edible.sanityvalue = -20
			elseif food.prefab == "monstermeat_dried" then
					food.components.edible.healthvalue = 0
					food.components.edible.sanityvalue = -15
			elseif food.prefab == "drumstick" then
					food.components.edible.healthvalue = 2
					food.components.edible.hungervalue = 15
					food.components.edible.sanityvalue = 5
			elseif food.prefab == "drumstick_cooked" then
					food.components.edible.healthvalue = 5
					food.components.edible.hungervalue = 18
					food.components.edible.sanityvalue = 5
			elseif food.prefab == "turkeydinner" then
					food.components.edible.healthvalue = 40
					food.components.edible.sanityvalue = 10
			elseif food.prefab == "monsterlasagna" then
					food.components.edible.healthvalue = 0
					food.components.edible.sanityvalue = -40
			end
		end
	return inst.components.eater:EatMEAT(food)
	end
	-------------------MAX
	inst.components.health:SetMaxHealth(TUNING.WHARANG_HEALTH_S)
	inst.components.hunger:SetMax(TUNING.WHARANG_HUNGER_S)
	inst.components.sanity:SetMax(TUNING.WHARANG_SANITY_S)
	-------------------
	--inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * .8)
	inst.components.health.fire_damage_scale = 0
	inst.components.sanity.night_drain_mult = 0
	inst.components.sanity.neg_aura_mult = 2
	inst.components.sanity.custom_rate_fn = SanityFn
	inst.components.builder.magic_bonus = 2
	-------------------Tag
	inst:AddTag("notgumi")
	inst:AddTag("wharang")
	-------------------Save&Load
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
	-------------------Rain
	--inst.rainstartedatsanity = 150
	inst:DoPeriodicTask(60,Regen)
	inst:DoPeriodicTask(1/10, function() TheEvilWhite(inst, 1/10) end)
	inst:DoPeriodicTask(1/10, function() Show_Party(inst, 1/10) end)
	inst.nightmare_time = 1
	inst.party_time = .35
	-------------------Event
	inst:ListenForEvent( "entity_death", function(wrld, data) SoulHeat_OnKill(inst, data) end, GetWorld())--KILL!
    inst:ListenForEvent( "daytime", function() WharangStats(inst) end , GetWorld())
	inst:ListenForEvent( "dusktime", function() WharangStats(inst) end , GetWorld())
    inst:ListenForEvent( "nighttime", function() WharangStats(inst) end , GetWorld())
	inst:ListenForEvent( "daytime", function() HungerFire(inst) end , GetWorld())--Light Day
	inst:ListenForEvent( "nighttime", function() HungerFire(inst) end , GetWorld())--Light Night
	inst:ListenForEvent( "sanitydelta", WharangChange)
	inst:ListenForEvent( "hungerdelta", HungerFire)--Light
	inst:ListenForEvent( "attacked", Wharang_FlameBody1)--Hurt
	inst:ListenForEvent( "attacked", Wharang_FlameBody2)--Hurt
	inst:ListenForEvent( "attacked", Wharang_FlameBody3)--Hurt
	inst:ListenForEvent( "attacked", Wharang_FlameBody)--E.W Hurt
	inst:ListenForEvent( "onhitother", Start_Fire_Party)
	-------------------
    WharangStats(inst)
	-------------------
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(4)
    inst.updateTask = inst:DoPeriodicTask(1, EvilAura, nil, 1)
	-------------------
	inst:AddComponent("groundpounderds")
	-------------------
	RECIPETABS['YINYANG'] = {str = "YINYANG", sort= 99, icon = "yinyangtab.tex", icon_atlas = "images/tabs/yinyangtab.xml"}
	TUNING.SANITY_TINY = 2.5
	TUNING.HOUND_DAMAGE = 30
	TUNING.FIREHOUND_DAMAGE = 40
	TUNING.ICEHOUND_DAMAGE = 40
	TUNING.DEERCLOPS_DAMAGE = 100
	-------------------

	-------------------
	if IsDLCEnabled(REIGN_OF_GIANTS) then
		--print("RoG support enabled")
		TUNING.MOOSE_DAMAGE = 100
		TUNING.MOSSLING_DAMAGE = 30
		TUNING.DRAGONFLY_DAMAGE = 100
		TUNING.BEARGER_DAMAGE = 230
		TUNING.BEARGER_HEALTH = 3500
		-------------------
		inst.components.temperature.overheattemp = 80
	end
	
	if IsDLCEnabled(CAPY_DLC) then
		inst.components.temperature.overheattemp = 80
		inst.components.poisonable.duration = 80
	else
		inst:AddComponent("reader")
	end
end

FLAMEHURT = {
"Ow! Do not hurt me!",
"Do not hit me!",
"Ouch! Stop it!",
"You'll get burned!",
"You're gonna kill me?!",
"I'm telling mama!",
"This is not funny!",
"No!",
"Stop it!",
"Oww!",
}

FRZOENHURT = {
"Poor little me...",
"You hurt me...",
"I'm crying...",
"You make me cry...",
"I can't understand you...",
"Take your hands off me!",
"Stay away from me!",
"Nooo...",
"Why...?",
"I'm sad...",
}

return MakePlayerCharacter("wharang", prefabs, assets, fn, start_inv)