require "prefabutil"

local assets = 
{
	Asset("ANIM", "anim/shadowbeak.zip"),
}

local function ShadowSanityAura(inst, observer)
	
	if inst.components.follower and inst.components.follower.leader == observer then
		return -TUNING.SANITYAURA_TINY
	end
	
	return 0
end

local function OnNewTarget(inst, data)
    if data.target and data.target:HasTag("player") then
end
end

local function OnAttacked(inst, data)
    local attacker = data and data.attacker
    if attacker and attacker:HasTag("player") then
        inst.components.health:SetVal(0)
    else
    inst.components.combat:SetTarget(data.attacker)
    inst.components.combat:ShareTarget(data.attacker, 30, function(dude) return dude:HasTag("companion") end, 1)
end
end

local function FollowPlayer(inst)
	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
end

local function KeepTarget(inst, target)
    return inst.components.combat:CanTarget(target) and (not inst:HasTag("companion") or inst:IsNear(target, 20))
end

local function shadowbeak(data)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local physics = inst.entity:AddPhysics()
	local sound = inst.entity:AddSoundEmitter()
	inst.Transform:SetScale(.3,.3,.3)
	inst.Transform:SetFourFaced()
	inst:AddTag("shadowcreature")
	inst:AddTag("shadow")
	inst:AddTag("wharangpet")
	
	inst:SetStateGraph("SGshadowbeak")
    	
	MakeCharacterPhysics(inst, 10, 1)
	RemovePhysicsColliders(inst)
	inst.Physics:SetCollisionGroup(COLLISION.SANITY)
	inst.Physics:CollidesWith(COLLISION.SANITY)      

    inst.AnimState:SetBank("shadowcreature2")
    inst.AnimState:SetBuild("shadowbeak")
	
	anim:SetMultColour(1, 1, 1, 0.5)
	inst:AddComponent("locomotor")
	inst.components.locomotor.walkspeed = 20
	inst.components.locomotor.runspeed = 20

	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(1)
	inst.components.health:StartRegen(-1, 60)
	
    inst:AddComponent("combat")
    inst.components.combat:SetRange(2, 2.5)
    inst.components.combat:SetAttackPeriod(3)
	inst.components.combat:SetDefaultDamage(5)
	inst.components.combat:SetKeepTargetFunction(KeepTarget)
	inst:ListenForEvent("attacked", OnAttacked)
    inst:ListenForEvent("newcombattarget", OnNewTarget)
	
    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = ShadowSanityAura
	
	inst:AddComponent("follower")
	inst:AddComponent("knownlocations")
	inst:AddComponent("inspectable")
	
	    local sounds = 
    {
        attack = "dontstarve/sanity/creature2/attack",
        attack_grunt = "dontstarve/sanity/creature2/attack_grunt",
        death = "dontstarve/sanity/creature2/die",
        idle = "dontstarve/sanity/creature2/idle",
        taunt = "dontstarve/sanity/creature2/taunt",
        appear = "dontstarve/sanity/creature2/appear",
        disappear = "dontstarve/sanity/creature2/dissappear",
    }

	local player = GetPlayer()
	if player and player.components.leader then
		player.components.leader:AddFollower(inst)
	end
	
	inst:AddComponent("talker")
	inst.components.talker.font = TALKINGFONT
    inst.components.talker.fontsize = 20
    inst.components.talker.offset = Vector3(0,-400,0)
	
	local brain = require "brains/shadowbeakbrain"
    inst:SetBrain(brain)
	
    return inst
    end

	
return Prefab( "common/shadowbeak", shadowbeak, assets)