
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

	        Asset( "ANIM", "anim/xjj.zip" ),
        Asset( "ANIM", "anim/ghost_xjj_build.zip" ),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
"xiaotai","datai",
}






local function xuexian(inst)

    if inst.components.hunger:GetPercent() < 0.2 and inst.components.health:GetPercent() > 0 then
	inst.components.health.maxhealth=28
		inst.components.talker:Say("电量过低!", 2.2,true)
		else
	inst.components.health.maxhealth=128	
	end
	
	end

local function health_droped(inst)
inst.components.health:StartRegen(-1, 8)
inst.components.sanity.dapperness = -TUNING.DAPPERNESS_HUGE * 2
inst.components.hunger.hungerrate = TUNING.WILSON_HUNGER_RATE * 2.8
end

local function health_stoped(inst)
inst.components.health:StartRegen(0, 8)
inst.components.sanity.dapperness = 0
inst.components.hunger.hungerrate = TUNING.WILSON_HUNGER_RATE * 1

end

local function oneath(inst, data)
local food = data and data.food
if food and food.prefab == "yaoshui" then
health_stoped(inst)
inst.components.talker:Say("病毒已被杀灭!", 2.2,true)
inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
end
if food and food.prefab == "honeyham" then
inst.components.hunger:DoDelta(300)
inst.components.sanity:DoDelta(300)
inst.components.health:DoDelta(300)

end

end

local function onkilledother(inst, data)
	local chance = 0.05
	local victim = data.victim
	local x, y, z = victim.Transform:GetWorldPosition()
		if victim.components.freezable and victim:HasTag("monster") then
		if math.random() < 0.06 then
			health_droped(inst)
			inst.SoundEmitter:PlaySound("dontstarve/sanity/creature2/taunt")
	local x, y, z = inst.Transform:GetWorldPosition()
	--local fx = SpawnPrefab("lightning")
	--fx.Transform:SetPosition(x, y, z)
	SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
			inst.components.talker:Say("机体发现有病毒入侵!", 2.2,true)
end end 
		if victim.components.freezable or victim:HasTag("monster") then
		
		if math.random() < chance then
	SpawnPrefab("xinp").Transform:SetPosition(x,y,z)
			
end end
end



-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	inst.components.locomotor.walkspeed = 5
	inst.components.locomotor.runspeed = 7
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 

	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "xjj.tex" )
		inst.transformed = true 
	inst:AddComponent("keyhandler")
    inst.components.keyhandler:AddActionListener("xjj", TUNING.XJJ.KEYTWO, "KaiDeng")
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(128)
	inst.components.hunger:SetMax(128)
	inst.components.sanity:SetMax(228)
	inst.components.locomotor.walkspeed = 5
	inst.components.locomotor.runspeed = 7
	inst.components.combat.min_attack_period = 0.6
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst:ListenForEvent("killed", onkilledother)
	inst:ListenForEvent("oneat", oneath)
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
	    local rtox = 5
    inst:DoPeriodicTask(rtox, function() xuexian(inst, rtox) end)
	
	
	
end

return MakePlayerCharacter("xjj", prefabs, assets, common_postinit, master_postinit, start_inv)
