/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.Base64Wrapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Properties;

public class SystemUtils {
    private static volatile boolean isWebstartHandlerMode;
    private static boolean protocolHandlersSet;
    private static final String COMMON_PROTOCOL_HANDLER = "com.sun.deploy.net.protocol";
    private static final String[] HANDLED_PROTOCOLS;

    public static final long microTime() {
        return System.nanoTime() / 1000L;
    }

    public static String getJarPath(Class<?> clazz) {
        String string;
        block6: {
            String string2 = "/" + clazz.getName().replace('.', '/') + ".class";
            URL uRL = Object.class.getResource(string2);
            if (uRL == null) {
                return null;
            }
            string = null;
            if (uRL.getProtocol().equals("jar")) {
                try {
                    URL uRL2 = new URL(uRL.getFile());
                    int n = uRL2.getFile().lastIndexOf("!");
                    if (n != -1) {
                        string = uRL2.getFile().substring(0, n);
                        break block6;
                    }
                    string = uRL2.getFile();
                }
                catch (Exception exception) {
                    string = "SHOULD NEVER HAPPEN";
                }
            } else {
                int n = uRL.getPath().length() - string2.length();
                string = uRL.getPath().substring(0, n);
            }
        }
        return new File(URLDecoder.decode(string)).getPath();
    }

    public static String priviledgedGetSystemProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string);
            }
        });
    }

    public static boolean priviledgedIsDirectory(final File file) {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isDirectory();
            }
        });
        return bl;
    }

    public static boolean isPathFromCache(String string) {
        String string2 = SystemUtils.getCanonicalPath(Config.getCacheDirectory());
        String string3 = SystemUtils.getCanonicalPath(Config.getSystemCacheDirectory());
        String string4 = SystemUtils.getCanonicalPath(string);
        if (string4 != null) {
            return string2 != null && string4.startsWith(string2) || string3 != null && string4.startsWith(string3);
        }
        return false;
    }

    private static String getCanonicalPath(String string) {
        try {
            return new File(string).getCanonicalPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getSimpleName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getSimpleName();
        }
        catch (Throwable throwable) {
            return clazz.getName();
        }
    }

    public static int getThreadLocalInt(ThreadLocal<Integer> threadLocal) {
        Integer n = null;
        if (threadLocal.get() instanceof Integer) {
            n = threadLocal.get();
        }
        if (n == null) {
            n = 0;
            threadLocal.set(n);
        }
        return n;
    }

    public static void setThreadLocalInt(ThreadLocal<Integer> threadLocal, int n) {
        threadLocal.set(n);
    }

    public static boolean deleteRecursive(File file) throws FileNotFoundException {
        boolean bl = true;
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                bl = bl && SystemUtils.deleteRecursive(fileArray[i]);
            }
        }
        return bl && file.delete();
    }

    public static byte[] readBytes(InputStream inputStream, long l) throws IOException {
        byte[] byArray;
        if (l > 0x100000L) {
            throw new IOException("File too large");
        }
        BufferedInputStream bufferedInputStream = null;
        bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        if (l <= 0L) {
            l = 10240L;
        }
        byte[] byArray2 = new byte[(int)l];
        int n = 0;
        int n2 = bufferedInputStream.read(byArray2, n, byArray2.length - n);
        while (n2 != -1) {
            if (byArray2.length == (n += n2)) {
                byArray = new byte[byArray2.length * 2];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                byArray2 = byArray;
            }
            n2 = bufferedInputStream.read(byArray2, n, byArray2.length - n);
        }
        bufferedInputStream.close();
        inputStream.close();
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static String encodeString(String string) {
        return Base64Wrapper.encodeToString(string.getBytes());
    }

    public static String getChecksum(byte[] byArray, String string) {
        String string2 = null;
        if (string == null) {
            string = "SHA-256";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            messageDigest.update(byArray, 0, byArray.length);
            string2 = Base64Wrapper.encodeToString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.ignored(noSuchAlgorithmException);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileChecksum(File file, String string) {
        String string2 = null;
        BufferedInputStream bufferedInputStream = null;
        if (string == null) {
            string = "SHA-256";
        }
        try {
            int n;
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[8192];
            for (int i = byArray.length; i > 0 && (n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1; i -= n) {
                messageDigest.update(byArray, 0, n);
            }
            string2 = Base64Wrapper.encodeToString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.ignored(noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string2;
    }

    public static void installPluginProtocolHandlers() {
        SystemUtils.installProtocolHandlers();
        isWebstartHandlerMode = false;
    }

    public static void installWebstartProtocolHandlers() {
        SystemUtils.installProtocolHandlers();
        isWebstartHandlerMode = true;
    }

    private static synchronized void installProtocolHandlers() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (!protocolHandlersSet) {
                    String string = "java.protocol.handler.pkgs";
                    String string2 = System.getProperty(string);
                    String string3 = string2 == null ? SystemUtils.COMMON_PROTOCOL_HANDLER : string2 + "|" + SystemUtils.COMMON_PROTOCOL_HANDLER;
                    System.setProperty(string, string3);
                    protocolHandlersSet = true;
                    URL.setURLStreamHandlerFactory(null);
                    for (String string4 : HANDLED_PROTOCOLS) {
                        try {
                            new URL(string4 + ":");
                        }
                        catch (Exception exception) {
                            Trace.ignored(exception);
                        }
                    }
                }
                return null;
            }
        });
    }

    public static void setHttpsProtocols(Properties properties) {
        if (properties.get("https.protocols") == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (Config.getBooleanProperty("deployment.security.TLSv1.2")) {
                stringBuilder.append("TLSv1.2");
            }
            if (Config.getBooleanProperty("deployment.security.TLSv1.1")) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("TLSv1.1");
            }
            if (Config.getBooleanProperty("deployment.security.TLSv1")) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("TLSv1");
            }
            if (Config.getBooleanProperty("deployment.security.SSLv3")) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("SSLv3");
            }
            if (Config.getBooleanProperty("deployment.security.SSLv2Hello")) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("SSLv2Hello");
            }
            properties.put("https.protocols", stringBuilder.toString());
        }
    }

    public static boolean isWebstartHandlerMode() {
        return isWebstartHandlerMode;
    }

    public static int parsePercent(String string, int n) throws NumberFormatException {
        if (string.endsWith("%")) {
            String string2 = string.substring(0, string.length() - 1);
            int n2 = Integer.parseInt(string2);
            return n * Math.min(n2, 100) / 100;
        }
        return Integer.parseInt(string);
    }

    public static String convertDebugParamForRelaunch(String string) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray = string.split(",")) {
            try {
                if (string2.startsWith("address=")) {
                    String[] stringArray2 = string2.split("=");
                    if (stringArray2.length == 2) {
                        String[] stringArray3 = stringArray2[1].split(":");
                        int n = Integer.parseInt(stringArray3[stringArray3.length - 1]);
                        int n2 = n + 1;
                        stringArray2[1] = stringArray3.length == 1 ? "" + n2 : stringArray3[0] + ":" + n2;
                    }
                    string2 = stringArray2[0] + "=" + stringArray2[1];
                }
            }
            catch (NumberFormatException numberFormatException) {
                Trace.ignored(numberFormatException);
            }
            stringBuilder.append(string2);
            stringBuilder.append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static boolean isJdwpDtSocketServerDebugParam(String string) {
        return string != null && string.startsWith("-agentlib:jdwp") && string.indexOf("=transport=dt_socket") > 0 && string.indexOf(",server=y") > 0 && string.indexOf(",address=") > 0;
    }

    static {
        HANDLED_PROTOCOLS = new String[]{"about", "chrome", "https", "javascript", "jnlp", "jnlps"};
    }
}

