/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.Base64Wrapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Properties;

public class SystemUtils {
    private static volatile boolean isWebstartHandlerMode;
    private static boolean protocolHandlersSet;
    private static final String COMMON_PROTOCOL_HANDLER = "com.sun.deploy.net.protocol";
    private static final String[] HANDLED_PROTOCOLS;

    public static final long microTime() {
        return System.nanoTime() / 1000L;
    }

    public static String getJarPath(Class<?> clazz) {
        String path;
        block6: {
            String resource = "/" + clazz.getName().replace('.', '/') + ".class";
            URL pathURL = Object.class.getResource(resource);
            if (pathURL == null) {
                return null;
            }
            path = null;
            if (pathURL.getProtocol().equals("jar")) {
                try {
                    URL tmp = new URL(pathURL.getFile());
                    int end = tmp.getFile().lastIndexOf("!");
                    if (end != -1) {
                        path = tmp.getFile().substring(0, end);
                        break block6;
                    }
                    path = tmp.getFile();
                }
                catch (Exception e) {
                    path = "SHOULD NEVER HAPPEN";
                }
            } else {
                int end = pathURL.getPath().length() - resource.length();
                path = pathURL.getPath().substring(0, end);
            }
        }
        return new File(URLDecoder.decode(path)).getPath();
    }

    public static String priviledgedGetSystemProperty(final String key) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }

    public static boolean priviledgedIsDirectory(final File f) {
        Boolean isDirectory = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return f.isDirectory();
            }
        });
        return isDirectory;
    }

    public static boolean isPathFromCache(String path) {
        String userCache = SystemUtils.getCanonicalPath(Config.getCacheDirectory());
        String systemCache = SystemUtils.getCanonicalPath(Config.getSystemCacheDirectory());
        String canonPath = SystemUtils.getCanonicalPath(path);
        if (canonPath != null) {
            return userCache != null && canonPath.startsWith(userCache) || systemCache != null && canonPath.startsWith(systemCache);
        }
        return false;
    }

    private static String getCanonicalPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getSimpleName(Class<?> c) {
        if (c == null) {
            return null;
        }
        try {
            return c.getSimpleName();
        }
        catch (Throwable e) {
            return c.getName();
        }
    }

    public static int getThreadLocalInt(ThreadLocal<Integer> integerThreadLocal) {
        Integer value = null;
        if (integerThreadLocal.get() instanceof Integer) {
            value = integerThreadLocal.get();
        }
        if (value == null) {
            value = 0;
            integerThreadLocal.set(value);
        }
        return value;
    }

    public static void setThreadLocalInt(ThreadLocal<Integer> threadLocal, int value) {
        threadLocal.set(value);
    }

    public static boolean deleteRecursive(File path) throws FileNotFoundException {
        boolean ret = true;
        if (path == null || !path.exists()) {
            return true;
        }
        if (path.isDirectory()) {
            File[] lst = path.listFiles();
            for (int i = 0; i < lst.length; ++i) {
                ret = ret && SystemUtils.deleteRecursive(lst[i]);
            }
        }
        return ret && path.delete();
    }

    public static byte[] readBytes(InputStream is, long size) throws IOException {
        byte[] bb;
        if (size > 0x100000L) {
            throw new IOException("File too large");
        }
        BufferedInputStream bis = null;
        bis = is instanceof BufferedInputStream ? (BufferedInputStream)is : new BufferedInputStream(is);
        if (size <= 0L) {
            size = 10240L;
        }
        byte[] b = new byte[(int)size];
        int bytesRead = 0;
        int n = bis.read(b, bytesRead, b.length - bytesRead);
        while (n != -1) {
            if (b.length == (bytesRead += n)) {
                bb = new byte[b.length * 2];
                System.arraycopy(b, 0, bb, 0, b.length);
                b = bb;
            }
            n = bis.read(b, bytesRead, b.length - bytesRead);
        }
        bis.close();
        is.close();
        if (bytesRead != b.length) {
            bb = new byte[bytesRead];
            System.arraycopy(b, 0, bb, 0, bytesRead);
            b = bb;
        }
        return b;
    }

    public static String encodeString(String raw) {
        return Base64Wrapper.encodeToString(raw.getBytes());
    }

    public static String getChecksum(byte[] buffer, String algorithm) {
        String ret = null;
        if (algorithm == null) {
            algorithm = "SHA-256";
        }
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(buffer, 0, buffer.length);
            ret = Base64Wrapper.encodeToString(digest.digest());
        }
        catch (NoSuchAlgorithmException nsae) {
            Trace.ignored(nsae);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileChecksum(File f, String algorithm) {
        String ret = null;
        BufferedInputStream bis = null;
        if (algorithm == null) {
            algorithm = "SHA-256";
        }
        try {
            int n;
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            bis = new BufferedInputStream(new FileInputStream(f));
            byte[] buffer = new byte[8192];
            for (int left = buffer.length; left > 0 && (n = bis.read(buffer, 0, buffer.length)) != -1; left -= n) {
                digest.update(buffer, 0, n);
            }
            ret = Base64Wrapper.encodeToString(digest.digest());
        }
        catch (NoSuchAlgorithmException nsae) {
            Trace.ignored(nsae);
        }
        catch (IOException ioe) {
            Trace.ignored(ioe);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException nsae) {}
            }
        }
        return ret;
    }

    public static void installPluginProtocolHandlers() {
        SystemUtils.installProtocolHandlers();
        isWebstartHandlerMode = false;
    }

    public static void installWebstartProtocolHandlers() {
        SystemUtils.installProtocolHandlers();
        isWebstartHandlerMode = true;
    }

    private static synchronized void installProtocolHandlers() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (!protocolHandlersSet) {
                    String name = "java.protocol.handler.pkgs";
                    String oldValue = System.getProperty(name);
                    Object newValue = oldValue == null ? SystemUtils.COMMON_PROTOCOL_HANDLER : oldValue + "|com.sun.deploy.net.protocol";
                    System.setProperty(name, (String)newValue);
                    protocolHandlersSet = true;
                    URL.setURLStreamHandlerFactory(null);
                    for (String s : HANDLED_PROTOCOLS) {
                        try {
                            new URL(s + ":");
                        }
                        catch (Exception e) {
                            Trace.ignored(e);
                        }
                    }
                }
                return null;
            }
        });
    }

    public static void setHttpsProtocols(Properties props) {
        if (props.get("https.protocols") == null) {
            StringBuilder protocolsStr = new StringBuilder();
            if (Config.getBooleanProperty("deployment.security.TLSv1.2")) {
                protocolsStr.append("TLSv1.2");
            }
            if (Config.getBooleanProperty("deployment.security.TLSv1.1")) {
                if (protocolsStr.length() != 0) {
                    protocolsStr.append(",");
                }
                protocolsStr.append("TLSv1.1");
            }
            if (Config.getBooleanProperty("deployment.security.TLSv1")) {
                if (protocolsStr.length() != 0) {
                    protocolsStr.append(",");
                }
                protocolsStr.append("TLSv1");
            }
            if (Config.getBooleanProperty("deployment.security.SSLv3")) {
                if (protocolsStr.length() != 0) {
                    protocolsStr.append(",");
                }
                protocolsStr.append("SSLv3");
            }
            if (Config.getBooleanProperty("deployment.security.SSLv2Hello")) {
                if (protocolsStr.length() != 0) {
                    protocolsStr.append(",");
                }
                protocolsStr.append("SSLv2Hello");
            }
            props.put("https.protocols", protocolsStr.toString());
        }
    }

    public static boolean isWebstartHandlerMode() {
        return isWebstartHandlerMode;
    }

    public static int parsePercent(String src, int total) throws NumberFormatException {
        if (src.endsWith("%")) {
            String num = src.substring(0, src.length() - 1);
            int percent = Integer.parseInt(num);
            return total * Math.min(percent, 100) / 100;
        }
        return Integer.parseInt(src);
    }

    /*
     * WARNING - void declaration
     */
    public static String convertDebugParamForRelaunch(String arg) {
        String[] parts;
        StringBuilder sb = new StringBuilder();
        for (String string : parts = arg.split(",")) {
            void var6_6;
            try {
                if (string.startsWith("address=")) {
                    String[] addressParts = string.split("=");
                    if (addressParts.length == 2) {
                        String[] hostPortPair = addressParts[1].split(":");
                        int port = Integer.parseInt(hostPortPair[hostPortPair.length - 1]);
                        int newPort = port + 1;
                        addressParts[1] = hostPortPair.length == 1 ? "" + newPort : hostPortPair[0] + ":" + newPort;
                    }
                    String string2 = addressParts[0] + "=" + addressParts[1];
                }
            }
            catch (NumberFormatException nfe) {
                Trace.ignored(nfe);
            }
            sb.append((String)var6_6);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static boolean isJdwpDtSocketServerDebugParam(String args) {
        return args != null && args.startsWith("-agentlib:jdwp") && args.indexOf("=transport=dt_socket") > 0 && args.indexOf(",server=y") > 0 && args.indexOf(",address=") > 0;
    }

    static {
        HANDLED_PROTOCOLS = new String[]{"about", "chrome", "https", "javascript", "jnlp", "jnlps"};
    }
}

