/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SafeThreadFactory;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InvocationEvent;
import java.lang.reflect.InvocationTargetException;
import sun.awt.SunToolkit;

public class AWTAppContext
implements AppContext {
    private static final String DEPLOY_AWT_APPCONTEXT_KEY = "DEPLOY_AWT_APPCONTEXT";
    private sun.awt.AppContext awtAppContext = null;

    private AWTAppContext(sun.awt.AppContext ac) {
        this.awtAppContext = ac;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + (this.awtAppContext != null ? this.awtAppContext.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof AWTAppContext) {
            return this == (AWTAppContext)o;
        }
        return false;
    }

    public static synchronized AWTAppContext getInstance() {
        sun.awt.AppContext awtAC = sun.awt.AppContext.getAppContext();
        if (awtAC == null) {
            return null;
        }
        AWTAppContext ac = (AWTAppContext)awtAC.get(DEPLOY_AWT_APPCONTEXT_KEY);
        if (ac == null) {
            ac = new AWTAppContext(awtAC);
            awtAC.put(DEPLOY_AWT_APPCONTEXT_KEY, ac);
        }
        return ac;
    }

    public static AWTAppContext createAppContext() {
        sun.awt.AppContext awtAC = SunToolkit.createNewAppContext();
        AWTAppContext ac = new AWTAppContext(awtAC);
        awtAC.put(DEPLOY_AWT_APPCONTEXT_KEY, ac);
        return ac;
    }

    @Override
    public Object get(Object key) {
        return this.awtAppContext.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.awtAppContext.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.awtAppContext.remove(key);
    }

    public sun.awt.AppContext getAWTAppContext() {
        return this.awtAppContext;
    }

    @Override
    public void invokeLater(Runnable runnable) {
        SunToolkit.postEvent(this.awtAppContext, new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock lock = new AWTInvocationLock();
        InvocationEvent event = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable, lock, true);
        AWTInvocationLock aWTInvocationLock = lock;
        synchronized (aWTInvocationLock) {
            SunToolkit.postEvent(this.awtAppContext, event);
            lock.wait();
        }
        Exception eventException = event.getException();
        if (eventException != null) {
            throw new InvocationTargetException(eventException);
        }
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.awtAppContext.getThreadGroup();
    }

    @Override
    public void dispose() {
        this.awtAppContext.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroy(long timeToWait) {
        ThreadGroup ftg = this.awtAppContext.getThreadGroup();
        final Window[][] windowBox = new Window[1][];
        final Object enumeratorLock = new Object();
        Thread windowEnumerator = SafeThreadFactory.createThread(ftg, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                windowBox[0] = Window.getOwnerlessWindows();
                Object object = enumeratorLock;
                synchronized (object) {
                    enumeratorLock.notifyAll();
                }
            }
        }, "Window enumerator");
        Object object = enumeratorLock;
        synchronized (object) {
            windowEnumerator.start();
            try {
                enumeratorLock.wait(timeToWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Window[] windows = windowBox[0];
        AppContextDisposer disposer = new AppContextDisposer(this.awtAppContext);
        SafeThreadFactory.createThread(disposer).start();
        AppContextDisposer appContextDisposer = disposer;
        synchronized (appContextDisposer) {
            try {
                disposer.wait(timeToWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (windows != null) {
            for (int i = 0; i < windows.length; ++i) {
                if (!windows[i].isDisplayable()) continue;
                Trace.println("Plugin2Manager calling stopFailed() because of displayable window " + windows[i]);
                return false;
            }
        }
        return true;
    }

    private class AppContextDisposer
    implements Runnable {
        private sun.awt.AppContext appContext;
        private boolean completed = false;

        private AppContextDisposer(sun.awt.AppContext appContext) {
            this.appContext = appContext;
        }

        public synchronized boolean isFailed() {
            return !this.completed;
        }

        @Override
        public synchronized void run() {
            try {
                this.appContext.dispose();
                this.completed = true;
            }
            catch (Exception ex) {
                Trace.println("Plugin2Manager calling stopFailed() because of exception during AppContext.dispose()");
            }
            catch (Throwable t) {
                Trace.ignored(t);
            }
            this.notifyAll();
        }
    }
}

