/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.MSCryptoDSASignature;
import com.sun.deploy.security.WIExplorerMyKeyStore;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecurityPermission;

public final class MSCryptoProvider
extends Provider {
    private static final long serialVersionUID = 2851292589714761768L;
    private static final String info = "SunDeploy-MSCrypto Provider (implements DSA)";
    private static final AccessControlContext ACC_INSTANCE;

    public MSCryptoProvider() {
        super("SunDeploy-MSCrypto", 1.5, info);
        final MSCryptoProvider p = this;
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                MSCryptoProvider.this.putService(new ProviderService(p, "Signature", "DSA", "com.sun.deploy.security.MSCryptoDSASignature$SHA1withDSA"));
                MSCryptoProvider.this.putService(new ProviderService(p, "Signature", "RawDSA", "com.sun.deploy.security.MSCryptoDSASignature$NONEwithDSA"));
                MSCryptoProvider.this.putService(new ProviderService(p, "KeyStore", "WIExplorerMy", "com.sun.deploy.security.WIExplorerMyKeyStore"));
                return null;
            }
        }, ACC_INSTANCE);
    }

    static {
        Permissions perms = new Permissions();
        SecurityPermission perm = new SecurityPermission("putProviderProperty.SunDeploy-MSCrypto");
        ((PermissionCollection)perms).add(perm);
        ACC_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }

    private static final class ProviderService
    extends Provider.Service {
        ProviderService(Provider p, String type, String algo, String cn) {
            super(p, type, algo, cn, null, null);
        }

        @Override
        public Object newInstance(Object ctrParamObj) throws NoSuchAlgorithmException {
            String type = this.getType();
            if (ctrParamObj != null) {
                throw new InvalidParameterException("constructorParameter not used with " + type + " engines");
            }
            String algo = this.getAlgorithm();
            try {
                if (algo.equals("DSA")) {
                    return new MSCryptoDSASignature.SHA1withDSA();
                }
                if (algo.equals("RawDSA")) {
                    return new MSCryptoDSASignature.NONEwithDSA();
                }
                if (algo.equals("WIExplorerMy")) {
                    return new WIExplorerMyKeyStore();
                }
            }
            catch (Exception ex) {
                throw new NoSuchAlgorithmException("Error constructing " + type + " for " + algo + " using SunDeploy-MSCrypto", ex);
            }
            throw new ProviderException("No impl for " + algo + " " + type);
        }
    }
}

