/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Platform;
import com.sun.deploy.security.CredentialManager;
import com.sun.deploy.trace.Trace;

public final class MSCredentialManager
extends CredentialManager {
    private static boolean isEncryptionSupported;
    private static long sessionId;

    MSCredentialManager() {
    }

    public static synchronized CredentialManager getInstance() {
        if (instance == null) {
            instance = new MSCredentialManager();
        }
        return instance;
    }

    @Override
    protected boolean isPasswordEncryptionSupported() {
        return isEncryptionSupported;
    }

    @Override
    protected byte[] encryptPassword(char[] pass) {
        byte[] buffer = new byte[]{};
        try {
            if (pass.length > 0) {
                buffer = MSCredentialManager.encryptMSPassword(pass);
            }
        }
        catch (Exception e) {
            Trace.securityPrintException(e);
        }
        return buffer;
    }

    @Override
    protected long getLoginSessionId() {
        return sessionId;
    }

    @Override
    protected char[] decryptPassword(byte[] pass) {
        char[] result = null;
        try {
            result = MSCredentialManager.decryptMSPassword(pass);
        }
        catch (Exception e) {
            Trace.securityPrintException(e);
        }
        return result;
    }

    private static native byte[] encryptMSPassword(char[] var0);

    private static native char[] decryptMSPassword(byte[] var0);

    private static native boolean isEncryptionAvailable();

    private static native long getLoginUID();

    static {
        Platform.get().loadDeployNativeLib();
        isEncryptionSupported = false;
        sessionId = -1L;
        String osName = System.getProperty("os.name").toLowerCase();
        if ((osName.indexOf("windows") == -1 || osName.indexOf("98") == -1) && osName.indexOf("me") == -1 && osName.indexOf("nt") == -1) {
            isEncryptionSupported = MSCredentialManager.isEncryptionAvailable();
            sessionId = MSCredentialManager.getLoginUID();
        }
    }
}

