/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.trace.Trace;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.PasswordAuthentication;
import java.util.StringTokenizer;

public final class CredentialInfo
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = -8876394562451934715L;
    private String userName = "";
    private char[] password = new char[0];
    private byte[] encryptedPassword = new byte[0];
    private String domain = "";
    private long sessionId = -1L;
    private boolean isPasswordSaved = false;

    public Object clone() {
        CredentialInfo info = new CredentialInfo();
        info.userName = this.userName;
        info.domain = this.domain;
        info.sessionId = this.sessionId;
        info.isPasswordSaved = this.isPasswordSaved;
        info.password = new char[this.password.length];
        info.encryptedPassword = new byte[this.encryptedPassword.length];
        System.arraycopy(this.password, 0, info.password, 0, this.password.length);
        System.arraycopy(this.encryptedPassword, 0, info.encryptedPassword, 0, this.encryptedPassword.length);
        return info;
    }

    public void setSessionId(long id) {
        this.sessionId = id;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public boolean isPasswordSaveApproved() {
        return this.isPasswordSaved;
    }

    public void setPasswordSaveApproval(boolean value) {
        this.isPasswordSaved = value;
    }

    public void setUserName(String name) {
        if (name == null) {
            this.userName = "";
        } else if (name.indexOf("\\".toString()) > -1) {
            StringTokenizer st = new StringTokenizer(name, "\\");
            this.domain = st.nextToken();
            this.userName = st.nextToken();
        } else {
            this.userName = name;
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setDomain(String domainName) {
        this.domain = domainName == null ? "" : domainName;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setPassword(char[] pass) {
        if (pass == null) {
            pass = new char[]{};
            this.setEncryptedPassword(null);
        }
        this.password = new char[pass.length];
        System.arraycopy(pass, 0, this.password, 0, this.password.length);
    }

    public char[] getPassword() {
        char[] pass = new char[this.password.length];
        System.arraycopy(this.password, 0, pass, 0, this.password.length);
        return pass;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            out.writeObject(this.userName);
            out.writeLong(this.sessionId);
            out.writeObject(this.domain);
            out.writeInt(this.encryptedPassword.length);
            for (int i = 0; i < this.encryptedPassword.length; ++i) {
                out.writeByte(this.encryptedPassword[i]);
            }
        }
        catch (Exception e) {
            Trace.securityPrintException(e);
        }
    }

    public boolean isCredentialEmpty() {
        return this.userName.length() <= 0 && this.domain.length() <= 0;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.userName = (String)in.readObject();
            this.sessionId = in.readLong();
            this.domain = (String)in.readObject();
            this.encryptedPassword = new byte[in.readInt()];
            for (int i = 0; i < this.encryptedPassword.length; ++i) {
                this.encryptedPassword[i] = in.readByte();
            }
        }
        catch (Exception e) {
            Trace.securityPrintException(e);
        }
    }

    protected byte[] getEncryptedPassword() {
        byte[] pass = new byte[this.encryptedPassword.length];
        System.arraycopy(this.encryptedPassword, 0, pass, 0, this.encryptedPassword.length);
        return pass;
    }

    protected void setEncryptedPassword(byte[] buffer) {
        if (buffer == null) {
            buffer = new byte[]{};
        }
        this.encryptedPassword = new byte[buffer.length];
        System.arraycopy(buffer, 0, this.encryptedPassword, 0, buffer.length);
    }

    public static CredentialInfo passAuthToCredentialInfo(PasswordAuthentication pa) {
        CredentialInfo info = new CredentialInfo();
        if (pa != null) {
            if (pa.getUserName().contains("\\")) {
                StringTokenizer st = new StringTokenizer(pa.getUserName(), "\\");
                info.domain = st.nextToken();
                info.userName = st.nextToken();
            } else {
                info.userName = pa.getUserName();
            }
            info.password = pa.getPassword();
        }
        return info;
    }

    public PasswordAuthentication getPasswordAuthentication() {
        Object name = this.userName;
        if (this.domain != null && !this.domain.trim().equals("")) {
            name = this.domain + "\\" + this.userName;
        }
        return new PasswordAuthentication((String)name, this.password);
    }
}

