/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.proxy.BrowserProxyConfig;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyUtils;
import com.sun.deploy.trace.Trace;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;

public final class UserDefinedProxyConfig
implements BrowserProxyConfig {
    @Override
    public BrowserProxyInfo getBrowserProxyInfo() {
        Trace.msgNetPrintln("net.proxy.loading.userdef");
        BrowserProxyInfo info = new BrowserProxyInfo();
        info.setType(3);
        Config.get().refreshIfNeeded();
        int proxyType = Config.getProxyType();
        if (proxyType == 0) {
            info.setType(0);
        } else if (proxyType == 1 || proxyType == 2) {
            info.setType(1);
            if (proxyType == 2) {
                String autoConfigURL = Config.getProxyAutoConfig();
                Trace.msgNetPrintln("net.proxy.browser.autoConfigURL", new Object[]{autoConfigURL});
                if (autoConfigURL != null && !"".equals(autoConfigURL.trim())) {
                    info.setType(2);
                    info.setAutoConfigURL(autoConfigURL);
                }
            }
            StringBuffer buffer = new StringBuffer();
            boolean hasProxies = false;
            boolean useSameProxy = Config.isProxySame();
            String httpHost = Config.getProxyHttpHost();
            if (httpHost != null && httpHost.trim().length() > 0) {
                hasProxies = true;
                if (!useSameProxy) {
                    buffer.append("http=");
                }
                buffer.append(httpHost);
                int httpPort = Config.getProxyHttpPort();
                if (httpPort > 0) {
                    buffer.append(":" + httpPort);
                }
            }
            if (!useSameProxy) {
                String socksHost;
                String ftpHost;
                String httpsHost = Config.getProxyHttpsHost();
                if (httpsHost != null && httpsHost.trim().length() > 0) {
                    if (hasProxies) {
                        buffer.append(";");
                    }
                    hasProxies = true;
                    buffer.append("https=");
                    buffer.append(httpsHost);
                    int httpsPort = Config.getProxyHttpsPort();
                    if (httpsPort > 0) {
                        buffer.append(":" + httpsPort);
                    }
                }
                if ((ftpHost = Config.getProxyFtpHost()) != null && ftpHost.trim().length() > 0) {
                    if (hasProxies) {
                        buffer.append(";");
                    }
                    hasProxies = true;
                    buffer.append("ftp=");
                    buffer.append(ftpHost);
                    int ftpPort = Config.getProxyFtpPort();
                    if (ftpPort > 0) {
                        buffer.append(":" + ftpPort);
                    }
                }
                if ((socksHost = Config.getProxySocksHost()) != null && socksHost.trim().length() > 0) {
                    if (hasProxies) {
                        buffer.append(";");
                    }
                    hasProxies = true;
                    buffer.append("socks=");
                    buffer.append(socksHost);
                    int socksPort = Config.getProxySocksPort();
                    if (socksPort > 0) {
                        buffer.append(":" + socksPort);
                    }
                }
            }
            String proxyList = buffer.toString();
            Trace.msgNetPrintln("net.proxy.browser.proxyList", new Object[]{proxyList});
            if (proxyList != null && !"".equals(proxyList.trim())) {
                ProxyUtils.parseProxyServer(proxyList, info);
            }
            Object proxyOverride = Config.getProxyBypass();
            if (Config.isProxyBypassLocal()) {
                proxyOverride = proxyOverride != null ? (String)proxyOverride + ";<local>" : "<local>";
            }
            Trace.msgNetPrintln("net.proxy.browser.proxyOverride", new Object[]{proxyOverride});
            if (proxyOverride != null && !"".equals(((String)proxyOverride).trim())) {
                StringTokenizer st = new StringTokenizer((String)proxyOverride, ";");
                ArrayList<String> list = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().toLowerCase(Locale.ENGLISH).trim();
                    if (item == null) continue;
                    list.add(item);
                }
                info.setOverrides(list);
            }
        }
        Trace.msgNetPrintln("net.proxy.loading.done");
        return info;
    }

    @Override
    public void getSystemProxy(BrowserProxyInfo bpi) {
    }
}

