/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.proxy;

import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.NSRegistry;
import com.sun.deploy.trace.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class NSPreferences {
    private static String parseValue(String line) {
        int i2;
        int i1 = line.indexOf(",");
        if (i1 != -1 && (i2 = line.lastIndexOf(")")) != -1 && i1 + 1 < i2) {
            return line.substring(i1 + 1, i2).trim();
        }
        return null;
    }

    private static String parseString(String line) {
        String value = NSPreferences.parseValue(line);
        if (value != null && value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return null;
    }

    private static int parseInt(String line) {
        String value = NSPreferences.parseValue(line);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static List<String> parseList(String line) {
        StringTokenizer st = new StringTokenizer(NSPreferences.parseString(line), ", ");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add("*" + st.nextToken());
        }
        return list;
    }

    private static boolean isKeyword(String line, String keyword) {
        int i = line.indexOf("(");
        return i != -1 && line.substring(i + 1, line.length()).startsWith("\"" + keyword + "\"");
    }

    private static boolean getDeaultValue(File file) {
        boolean _isSystemChecked = false;
        try {
            if (file.exists()) {
                String aline;
                BufferedReader allIn = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
                while ((aline = allIn.readLine()) != null) {
                    if (!aline.startsWith("pref") || !NSPreferences.isKeyword(aline, "config.use_system_prefs")) continue;
                    _isSystemChecked = NSPreferences.parseValue(aline).equals("true");
                    break;
                }
                allIn.close();
            }
        }
        catch (IOException e) {
            Trace.ignoredException(e);
        }
        return _isSystemChecked;
    }

    private static boolean getDefaultValueOfUseSystemPrefs() {
        return NSPreferences.getDeaultValue(new File("/usr/lib/mozilla/greprefs/all.js"));
    }

    protected static void parseFile(File file, BrowserProxyInfo info, float version, boolean checkSystemPrefs) {
        block44: {
            BufferedReader in = null;
            try {
                String line;
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
                String httpHost = null;
                String autoConfigURL = null;
                int proxyType = 5;
                int httpPort = -1;
                boolean isSystemChecked = NSPreferences.getDefaultValueOfUseSystemPrefs();
                info.setType(4);
                while ((line = in.readLine()) != null) {
                    URL u3;
                    if (!line.startsWith("user_pref")) continue;
                    if (NSPreferences.isKeyword(line, "network.proxy.type")) {
                        proxyType = NSPreferences.parseInt(line);
                        switch (proxyType) {
                            case 0: {
                                info.setType(0);
                                break;
                            }
                            case 1: {
                                info.setType(1);
                                break;
                            }
                            case 2: {
                                info.setType(2);
                                break;
                            }
                            case 4: {
                                info.setType(2);
                                info.setAutoProxyDetectionEnabled(true);
                                break;
                            }
                            case 5: {
                                info.setType(4);
                                break;
                            }
                            default: {
                                info.setType(4);
                            }
                        }
                        Trace.msgNetPrintln("net.proxy.browser.proxyEnable", new Object[]{proxyType});
                        continue;
                    }
                    if (NSPreferences.isKeyword(line, "network.proxy.http")) {
                        httpHost = NSPreferences.parseString(line);
                        try {
                            URL u2 = new URL(httpHost);
                            httpHost = u2.getHost();
                        }
                        catch (MalformedURLException u2) {
                            // empty catch block
                        }
                        Trace.netPrintln("    network.proxy.http=" + httpHost);
                        info.setHttpHost(httpHost);
                        continue;
                    }
                    if (NSPreferences.isKeyword(line, "network.proxy.http_port")) {
                        httpPort = NSPreferences.parseInt(line);
                        Trace.netPrintln("    network.proxy.http_port=" + httpPort);
                        info.setHttpPort(httpPort);
                        continue;
                    }
                    if (NSPreferences.isKeyword(line, "network.proxy.ssl")) {
                        String host = NSPreferences.parseString(line);
                        try {
                            u3 = new URL(host);
                            host = u3.getHost();
                        }
                        catch (MalformedURLException u3) {
                            // empty catch block
                        }
                        Trace.netPrintln("    network.proxy.ssl=" + host);
                        info.setHttpsHost(host);
                        continue;
                    }
                    if (NSPreferences.isKeyword(line, "network.proxy.ssl_port")) {
                        int port = NSPreferences.parseInt(line);
                        Trace.netPrintln("    network.proxy.ssl_port=" + port);
                        info.setHttpsPort(port);
                        continue;
                    }
                    if (NSPreferences.isKeyword(line, "network.proxy.ftp")) {
                        String host = NSPreferences.parseString(line);
                        try {
                            u3 = new URL(host);
                            host = u3.getHost();
                        }
                        catch (MalformedURLException u4) {
                            // empty catch block
                        }
                        Trace.netPrintln("    network.proxy.ftp=" + host);
                        info.setFtpHost(host);
                        continue;
                    }
                    if (NSPreferences.isKeyword(line, "network.proxy.ftp_port")) {
                        int port = NSPreferences.parseInt(line);
                        Trace.netPrintln("    network.proxy.ftp_port=" + port);
                        info.setFtpPort(port);
                        continue;
                    }
                    if (NSPreferences.isKeyword(line, "network.proxy.gopher")) {
                        String host = NSPreferences.parseString(line);
                        try {
                            u3 = new URL(host);
                            host = u3.getHost();
                        }
                        catch (MalformedURLException u5) {
                            // empty catch block
                        }
                        Trace.netPrintln("    network.proxy.gopher=" + host);
                        info.setGopherHost(host);
                        continue;
                    }
                    if (NSPreferences.isKeyword(line, "network.proxy.gopher_port")) {
                        int port = NSPreferences.parseInt(line);
                        Trace.netPrintln("    network.proxy.gopher_port=" + port);
                        info.setGopherPort(port);
                        continue;
                    }
                    if (NSPreferences.isKeyword(line, "network.proxy.socks")) {
                        String host = NSPreferences.parseString(line);
                        try {
                            u3 = new URL(host);
                            host = u3.getHost();
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        Trace.netPrintln("    network.proxy.socks=" + host);
                        info.setSocksHost(host);
                        continue;
                    }
                    if (NSPreferences.isKeyword(line, "network.proxy.socks_port")) {
                        int port = NSPreferences.parseInt(line);
                        Trace.netPrintln("    network.proxy.socks_port=" + port);
                        info.setSocksPort(port);
                        continue;
                    }
                    if (NSPreferences.isKeyword(line, "network.proxy.no_proxies_on")) {
                        Trace.msgNetPrintln("net.proxy.browser.proxyOverride", new Object[]{NSPreferences.parseString(line)});
                        info.setOverrides(NSPreferences.parseList(line));
                        continue;
                    }
                    if (NSPreferences.isKeyword(line, "network.proxy.autoconfig_url")) {
                        autoConfigURL = NSPreferences.parseString(line);
                        Trace.msgNetPrintln("net.proxy.browser.autoConfigURL", new Object[]{autoConfigURL});
                        info.setAutoConfigURL(autoConfigURL);
                        continue;
                    }
                    if (!NSPreferences.isKeyword(line, "config.use_system_prefs")) continue;
                    if (NSPreferences.parseValue(line).equals("true")) {
                        isSystemChecked = true;
                        continue;
                    }
                    isSystemChecked = false;
                }
                in.close();
                if (checkSystemPrefs && isSystemChecked) {
                    info.setType(4);
                    return;
                }
                if (proxyType == -1 && System.getProperty("os.name").equals("SunOS") && version >= 6.0f) {
                    info.setType(2);
                    return;
                }
                if (proxyType == -1 && System.getProperty("os.name").equals("Linux") && version >= 4.0f) {
                    info.setType(0);
                    return;
                }
                if (proxyType == -1 && System.getProperty("os.name").indexOf("Windows") != -1 && version >= 4.0f && version < 5.0f) {
                    info.setType(0);
                    return;
                }
                if (httpHost != null && httpPort == -1 && System.getProperty("os.name").indexOf("Windows") != -1 && version >= 6.0f) {
                    httpPort = 8080;
                    info.setHttpPort(8080);
                }
                if (System.getProperty("os.name").indexOf("Windows") != -1 && version >= 6.0f && proxyType == -1) {
                    proxyType = 0;
                    info.setType(0);
                }
                if (proxyType == -1 && autoConfigURL != null) {
                    info.setType(2);
                }
                if (proxyType == 4 && version >= 6.0f) {
                    info.setType(2);
                    info.setAutoProxyDetectionEnabled(true);
                }
            }
            catch (IOException exc1) {
                if (in == null) break block44;
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static File getNS6PrefsFile(File registryFile) throws IOException {
        return new File(NSPreferences.getNS6UserProfileDirectory(registryFile), "prefs.js");
    }

    public static String getNS6UserProfileDirectory(File registryFile) throws IOException {
        NSRegistry reg = new NSRegistry().open(registryFile);
        String path = null;
        String currProfileName = null;
        if (reg != null) {
            currProfileName = reg.get("Common/Profiles/CurrentProfile");
            if (currProfileName != null) {
                path = reg.get("Common/Profiles/" + currProfileName + "/directory");
            }
            reg.close();
        }
        if (path == null) {
            throw new IOException();
        }
        return path;
    }

    public static String getFireFoxUserProfileDirectory(File iniFile) throws IOException {
        Object currProfileName = null;
        String line = null;
        String path = null;
        boolean isRelative = true;
        boolean readingProfile0 = false;
        String IS_RELATIVE = "isrelative=";
        String PATH_PROFILES = "path=";
        if (iniFile.exists()) {
            BufferedReader in = new BufferedReader(new FileReader(iniFile));
            while ((line = in.readLine()) != null) {
                if (line.trim().toLowerCase().equals("[profile0]")) {
                    readingProfile0 = true;
                    continue;
                }
                if (readingProfile0 && line.toLowerCase().startsWith("isrelative=")) {
                    try {
                        int val = Integer.parseInt(line.substring("isrelative=".length()));
                        isRelative = val != 0;
                    }
                    catch (NumberFormatException e) {
                        isRelative = true;
                    }
                    continue;
                }
                if (!readingProfile0 || !line.toLowerCase().startsWith("path=")) continue;
                currProfileName = line.substring("path=".length());
                break;
            }
        }
        if (currProfileName != null) {
            if (isRelative) {
                int x = iniFile.toString().length() - 12;
                path = iniFile.toString().substring(0, x) + currProfileName;
            } else {
                path = currProfileName;
            }
        }
        if (path == null) {
            throw new IOException();
        }
        return path;
    }
}

