/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.ArgumentParsingUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class Property
implements Cloneable {
    private static final boolean DEBUG = false;
    public static final String JNLP_PACK_ENABLED = "jnlp.packEnabled";
    public static final String JNLP_VERSION_ENABLED = "jnlp.versionEnabled";
    public static final String JNLP_CONCURRENT_DOWNLOADS = "jnlp.concurrentDownloads";
    public static final int CONCURRENT_DOWNLOADS_DEF = Config.getIntProperty("deployment.javaws.concurrentDownloads") == -1 ? 4 : Config.getIntProperty("deployment.javaws.concurrentDownloads");
    String key;
    String value;
    boolean isSecure;
    private static List<Object> jnlpProps = Arrays.asList("jnlp.packEnabled", "jnlp.versionEnabled", "jnlp.concurrentDownloads");

    public Property(String spec) {
        spec = spec.trim();
        if (!spec.startsWith("-D") || spec.length() < 3) {
            throw new IllegalArgumentException("Property invalid");
        }
        int endKey = spec.indexOf("=");
        if (endKey < 0) {
            this.key = spec.substring(2);
            this.value = "";
        } else {
            this.key = spec.substring(2, endKey);
            this.value = spec.substring(endKey + 1);
        }
        this.isSecure = Config.isSecureProperty(this.key, this.value);
    }

    public static Property createProperty(String spec) {
        Property prop = null;
        try {
            prop = new Property(spec);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return prop;
    }

    public Property(String key, String value) {
        this.key = key;
        this.value = value != null ? value : new String("");
        this.isSecure = Config.isSecureProperty(this.key, this.value);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String toString() {
        if (this.value.length() == 0) {
            return "-D" + this.key;
        }
        return "-D" + this.key + "=" + this.value;
    }

    public void addTo(Properties props) {
        props.setProperty(this.key, this.value);
    }

    public Object clone() {
        return new Property(this.key, this.value);
    }

    public boolean equals(Object o) {
        int hashThis;
        if (!(o instanceof Property)) {
            return false;
        }
        Property op = (Property)o;
        int hashTheirs = op.hashCode();
        return hashTheirs == (hashThis = this.hashCode());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public static boolean isJnlpProperty(String spec) {
        try {
            Property p = new Property(spec);
            return Property.isJnlpPropertyKey(p.getKey());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isJnlpPropertyKey(String key) {
        return key != null && jnlpProps.contains(key);
    }

    public static List<Property> getJnlpProperties(String javaArgs) {
        List<String> args = ArgumentParsingUtil.decodeArgumentList(javaArgs);
        ArrayList<Property> result = new ArrayList<Property>();
        for (int i = 0; i < args.size(); ++i) {
            String spec = args.get(i);
            try {
                Property p = new Property(spec);
                if (!p.getKey().startsWith("jnlp.")) continue;
                result.add(p);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean collectsJnlpPropertyIntoAppContext(String key, String value) {
        if (Property.isJnlpPropertyKey(key)) {
            Property.collectsJnlpProperties(key, value, ToolkitStore.get().getAppContext());
            return true;
        }
        return false;
    }

    public static void collectsJnlpProperties(String javaArgs, AppContext appContext) {
        List<Property> props = Property.getJnlpProperties(javaArgs);
        for (int i = 0; i < props.size(); ++i) {
            Property p = props.get(i);
            Property.collectsJnlpProperties(p.getKey(), p.getValue(), appContext);
        }
    }

    private static void collectsJnlpProperties(String key, String value, AppContext appContext) {
        if (appContext == null) {
            return;
        }
        Comparable<Boolean> v = null;
        if (key.equals(JNLP_CONCURRENT_DOWNLOADS)) {
            int count = 0;
            try {
                count = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Trace.println(e.getLocalizedMessage() + " " + key, TraceLevel.NETWORK);
            }
            if (count <= 0) {
                count = CONCURRENT_DOWNLOADS_DEF;
            }
            if (count > 10) {
                count = 10;
            }
            v = count;
        } else if (key.equals(JNLP_PACK_ENABLED) || key.equals(JNLP_VERSION_ENABLED)) {
            v = Boolean.valueOf(value);
        }
        appContext.put(key, v);
    }

    public static boolean isPackEnabled() {
        return Property.isPackEnabled(ToolkitStore.get().getAppContext());
    }

    public static boolean isPackEnabled(AppContext appContext) {
        return Property.booleanValue(appContext, JNLP_PACK_ENABLED);
    }

    public static boolean isVersionEnabled() {
        return Property.isVersionEnabled(ToolkitStore.get().getAppContext());
    }

    public static boolean isVersionEnabled(AppContext appContext) {
        return Property.booleanValue(appContext, JNLP_VERSION_ENABLED);
    }

    public static int getConcurrentDownloads() {
        return Property.getConcurrentDownloads(ToolkitStore.get().getAppContext());
    }

    public static int getConcurrentDownloads(AppContext appContext) {
        int count = Property.intValue(appContext, JNLP_CONCURRENT_DOWNLOADS);
        if (count <= 0) {
            count = CONCURRENT_DOWNLOADS_DEF;
        }
        return count;
    }

    private static boolean booleanValue(AppContext appContext, String name) {
        if (appContext == null) {
            return false;
        }
        Object o = appContext.get(name);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        return false;
    }

    private static int intValue(AppContext appContext, String name) {
        if (appContext == null) {
            return -1;
        }
        Object o = appContext.get(name);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            try {
                return Integer.valueOf((String)o);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }
}

