/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import java.lang.reflect.Method;
import java.nio.Buffer;

public abstract class BufferWrapper {
    private final Buffer buffer;

    public BufferWrapper(Buffer buffer) {
        this.buffer = buffer;
    }

    public int limit() {
        return this.buffer.limit();
    }

    public Buffer limit(int newLimit) {
        Buffer result = this.buffer;
        if (Config.isJavaVersionAtLeast9()) {
            result = this.buffer.limit(newLimit);
        } else {
            try {
                Method m = this.buffer.getClass().getMethod("limit", Integer.TYPE);
                result = (Buffer)m.invoke((Object)this.buffer, newLimit);
            }
            catch (Throwable t) {
                Trace.ignored(t);
            }
        }
        return result;
    }

    public Buffer position(int position) {
        Buffer result = this.buffer;
        if (Config.isJavaVersionAtLeast9()) {
            result = this.buffer.position(position);
        } else {
            try {
                Method m = this.buffer.getClass().getMethod("position", Integer.TYPE);
                result = (Buffer)m.invoke((Object)this.buffer, position);
            }
            catch (Throwable t) {
                Trace.ignored(t);
            }
        }
        return result;
    }

    public Buffer mark() {
        if (Config.isJavaVersionAtLeast9()) {
            return this.buffer.mark();
        }
        return BufferWrapper.invokeNoArgMethod(this.buffer, "mark");
    }

    public Buffer reset() {
        if (Config.isJavaVersionAtLeast9()) {
            return this.buffer.reset();
        }
        return BufferWrapper.invokeNoArgMethod(this.buffer, "reset");
    }

    public Buffer clear() {
        if (Config.isJavaVersionAtLeast9()) {
            return this.buffer.clear();
        }
        return BufferWrapper.invokeNoArgMethod(this.buffer, "clear");
    }

    public Buffer flip() {
        if (Config.isJavaVersionAtLeast9()) {
            return this.buffer.flip();
        }
        return BufferWrapper.invokeNoArgMethod(this.buffer, "flip");
    }

    public Buffer rewind() {
        if (Config.isJavaVersionAtLeast9()) {
            return this.buffer.rewind();
        }
        return BufferWrapper.invokeNoArgMethod(this.buffer, "rewind");
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public int position() {
        return this.buffer.position();
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    protected static Buffer invokeNoArgMethod(Buffer buffer, String methodName) {
        Buffer result = buffer;
        try {
            Method m = buffer.getClass().getMethod(methodName, new Class[0]);
            result = (Buffer)m.invoke((Object)buffer, new Object[0]);
        }
        catch (Throwable t) {
            Trace.ignored(t);
        }
        return result;
    }
}

