/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.trace;

import com.sun.deploy.trace.TraceLevel;

final class TraceMessage {
    private final TraceLevel level;
    private final String msg;
    private final boolean newline;
    private final long ts = System.currentTimeMillis();

    TraceMessage(TraceLevel level, String msg) {
        this(level, msg, false);
    }

    TraceMessage(TraceLevel level, String msg, boolean newline) {
        this.level = level;
        this.msg = msg;
        this.newline = newline;
    }

    public String toString() {
        return new StringBuffer().append(this.level).append(": ").append(this.msg).toString();
    }

    public TraceLevel getLevel() {
        return this.level;
    }

    public String getMessage() {
        StringBuffer message = new StringBuffer();
        if (this.level.equals(TraceLevel.DEFAULT)) {
            message.append(this.msg);
        } else {
            message.append(this.level).append(": ").append(this.msg);
        }
        if (this.newline) {
            message.append('\n');
        }
        return message.toString();
    }

    public String getMsg() {
        return this.msg;
    }

    public long getTimestamp() {
        return this.ts;
    }
}

