/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.TrustDeciderDialog;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;

class X509Util {
    private static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";

    X509Util() {
    }

    static Principal getIssuerPrincipal(Certificate cert) {
        try {
            return ((X509Certificate)cert).getIssuerX500Principal();
        }
        catch (NoSuchMethodError nsme) {
            Trace.println("NoSuchMethodError: X509Certificate.getIssuerX500Principal(): " + nsme, TraceLevel.SECURITY);
            return ((X509Certificate)cert).getIssuerDN();
        }
    }

    static Principal getSubjectPrincipal(Certificate cert) {
        try {
            return ((X509Certificate)cert).getSubjectX500Principal();
        }
        catch (NoSuchMethodError nsme) {
            Trace.println("NoSuchMethodError: X509Certificate.getSubjectX500Principal(): " + nsme, TraceLevel.SECURITY);
            return ((X509Certificate)cert).getSubjectDN();
        }
    }

    static List<String> getExtendedKeyUsage(Certificate cert) throws CertificateParsingException {
        return ((X509Certificate)cert).getExtendedKeyUsage();
    }

    static int showSecurityDialog(Certificate[] certs, URL codeLocation, int start, int end, boolean rootCANotValid, int certValidity, Date timeStamp, AppInfo ainfo, boolean revStatusUnknown) throws CertificateException {
        int ret = TrustDeciderDialog.showDialog(certs, codeLocation, start, end, rootCANotValid, certValidity, timeStamp, ainfo, false, null, revStatusUnknown);
        return ret;
    }
}

