/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedDialog;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.BlockedVersionException;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;

public class SecureStaticVersioning {
    public static final int REASON_CONFIG = 0;
    public static final int REASON_UNSIGNED = 1;
    public static final int REASON_UNAVAIL = 2;
    public static final int REASON_FX = 3;
    public static final int REASON_INVALID = 4;

    private static boolean promptUse(Component parent, AppInfo ainfo, DeploymentRuleSet drs, LocalApplicationProperties lap, String version) throws BlockedException {
        if (!SecureStaticVersioning.isTrustedNotSelfSigned(ainfo) && drs.isSSVModeNever()) {
            SecureStaticVersioning.useLatest(ainfo, drs, version, 0);
            return false;
        }
        if (lap != null && "ssv.latest.allowed".equals(lap.get("ssv.version.allowed"))) {
            return false;
        }
        if (SecureStaticVersioning.showSSV2Dialog(parent, ainfo, version)) {
            if (lap != null) {
                lap.put("ssv.version.allowed", version);
                try {
                    lap.store();
                }
                catch (IOException ioe) {
                    Trace.ignoredException(ioe);
                }
            }
            return true;
        }
        if (lap != null) {
            lap.put("ssv.version.allowed", "ssv.latest.allowed");
            try {
                lap.store();
            }
            catch (IOException ioe) {
                Trace.ignoredException(ioe);
            }
        }
        return false;
    }

    public static boolean canUse(AppInfo ai, DeploymentRuleSet drs, String version) throws BlockedException {
        String ruleVersion = drs.getVersionString();
        if (drs.isRuleRun()) {
            if (ruleVersion == null || SecureStaticVersioning.satisfiesDRSVersion(ruleVersion, version)) {
                return true;
            }
            if (SecureStaticVersioning.satisfiesDRSVersion(ruleVersion)) {
                return false;
            }
            String msg = ResourceManager.getString("deployment.blocked.ruleset.version", drs.getVersionString(), version);
            BlockedDialog.show(ai, msg, null, null, null, drs);
        }
        if (!SecureStaticVersioning.isOlderVersion(version) || SecurityBaseline.satisfiesSecurityBaseline(version)) {
            return true;
        }
        LocalApplicationProperties lap = SecureStaticVersioning.getLap(ai);
        if (lap != null && version.equals(lap.get("ssv.version.allowed"))) {
            return true;
        }
        return SecureStaticVersioning.promptUse(null, ai, drs, lap, version);
    }

    public static void checkVersionAllowed(DeploymentRuleSet drs) {
        String ruleVersion = drs.getVersionString();
        if (ruleVersion != null && !SecureStaticVersioning.satisfiesDRSVersion(ruleVersion)) {
            throw new BlockedVersionException("Required JRE " + ruleVersion + " not running", null);
        }
    }

    private static boolean isTrustedNotSelfSigned(AppInfo ai) {
        String selfsigned;
        int jarMode;
        int mode = ai.getSecurity();
        if (mode == 0 && (jarMode = DeployManifestChecker.getPermissionRequestType(ai.getEMURL(), ai.getEMVersion())) != 1) {
            mode = 2;
        }
        return mode == 2 && !"true".equals(selfsigned = (String)ToolkitStore.get().getAppContext().get("self-signed"));
    }

    public static void resetAcceptedVersion(URL href, AppInfo ai) {
        LocalApplicationProperties lap = Cache.getLocalApplicationProperties(href);
        if (lap != null) {
            lap.put("ssv.version.allowed", null);
            SandboxSecurity.resetAcceptedVersion(lap, ai);
        }
    }

    private static boolean isOlderVersion(String version) {
        VersionID requested;
        VersionID thisPlus = new VersionID(SecurityBaseline.getCurrentVersion() + "+");
        return !thisPlus.match(requested = new VersionID(version));
    }

    private static LocalApplicationProperties getLap(AppInfo ai) {
        return Cache.getLocalApplicationProperties(ai.getLapURL());
    }

    private static boolean showSSV2Dialog(Component parent, AppInfo ai, String version) throws BlockedException {
        String title = ResourceManager.getString("deployment.ssv2.title");
        String top = ResourceManager.getString("deployment.ssv2.masthead");
        String risk = ResourceManager.getString("deployment.ssv2.risk");
        String more = ResourceManager.getString("deployment.ssv2.moreText");
        URL moreURL = null;
        try {
            moreURL = new URL("http://java.com/access_old_java");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String choice = ResourceManager.getString("deployment.ssv2.choice");
        String choice1 = ToolkitStore.isToolkitType(ToolkitStore.ToolkitType.FX_TOOLKIT) ? ResourceManager.getString("deployment.ssv2.choice1.fx") : ResourceManager.getString("deployment.ssv2.choice1");
        String choice2 = ResourceManager.getString("deployment.ssv2.choice2", version);
        String run = ResourceManager.getString("deployment.ssv2.run.button");
        String cancel = ResourceManager.getString("common.cancel_btn");
        int result = ToolkitStore.getUI().showSSVDialog(parent, ai, title, top, risk, more, moreURL, choice, choice1, choice2, run, cancel);
        if (result == 0) {
            return true;
        }
        if (result == 2) {
            return false;
        }
        throw new BlockedException("User declined to run with latest available Java version.", null, null, null, true);
    }

    private static void showCannotUseDialog(Component parent, AppInfo ai, LocalApplicationProperties lap, String version, int reason) throws BlockedException {
        if (lap != null && "ssv.latest.allowed".equals(lap.get("ssv.version.allowed"))) {
            return;
        }
        String title = ResourceManager.getString("deployment.ssv2.nodl.title");
        String key = null;
        switch (reason) {
            case 0: {
                key = "deployment.ssv2.nodl.blocked";
                break;
            }
            case 3: {
                key = "deployment.ssv2.nodl.fx";
                break;
            }
            case 4: {
                key = "deployment.ssv2.nodl.invalid";
                break;
            }
            default: {
                key = "deployment.ssv2.nodl.masthead";
            }
        }
        String msg = ResourceManager.getString(key, version);
        String ok = ResourceManager.getString("deployment.ssv2.nodl.button");
        String cancel = ResourceManager.getString("common.cancel_btn");
        String moreText = ResourceManager.getString("deployment.ssv2.moreText");
        URL moreURL = null;
        try {
            moreURL = new URL("http://java.com/access_old_java");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int result = ToolkitStore.getUI().showMessageDialog(parent, ai, 2, title, msg, null, null, ok, cancel, null, moreURL, moreText, 0);
        if (result != 0) {
            throw new BlockedException("User declined to run with latest available Java version.", null, null, null, true);
        }
        if (lap != null) {
            lap.put("ssv.version.allowed", "ssv.latest.allowed");
            try {
                lap.store();
            }
            catch (IOException ioe) {
                Trace.ignoredException(ioe);
            }
        }
    }

    public static boolean useLatest(AppInfo ai, DeploymentRuleSet drs, String version, int reason) throws BlockedException {
        if (drs.isRuleRun()) {
            String ruleVersion = drs.getVersionString();
            if (ruleVersion == null || SecureStaticVersioning.satisfiesDRSVersion(ruleVersion)) {
                return true;
            }
            String msg = ResourceManager.getString("deployment.blocked.ruleset.version", drs.getVersionString(), version);
            BlockedDialog.show(ai, msg, null, null, null, drs);
        }
        SecureStaticVersioning.showCannotUseDialog(null, ai, SecureStaticVersioning.getLap(ai), version, reason);
        return true;
    }

    public static boolean satisfiesDRSVersion(String ruleVersion) {
        JREInfo home = JREInfo.getHomeJRE();
        if (home != null) {
            return SecureStaticVersioning.satisfiesDRSVersion(ruleVersion, home.getProduct());
        }
        return false;
    }

    public static boolean satisfiesDRSVersion(String ruleVersion, String requestedVersion) {
        int index = requestedVersion.indexOf("-");
        String string = requestedVersion = index > 0 ? requestedVersion.substring(0, index) : requestedVersion;
        if (ruleVersion.startsWith("SECURE-")) {
            VersionString vs;
            String ver = ruleVersion.substring("SECURE-".length());
            if (ver.endsWith("+") ? !(vs = new VersionString(ver)).contains(requestedVersion) : !requestedVersion.startsWith(ver)) {
                return false;
            }
            return SecurityBaseline.satisfiesBaselineStrictly(requestedVersion);
        }
        if (ruleVersion.equals("SECURE")) {
            return SecurityBaseline.satisfiesBaselineStrictly(requestedVersion);
        }
        VersionString vs = new VersionString(ruleVersion);
        return vs.contains(requestedVersion);
    }
}

