/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.AuthKey;
import com.sun.deploy.security.BrowserAuthenticator;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.security.CredentialManager;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.ComponentRef;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;

public class DeployAuthenticator
extends Authenticator
implements AuthKey {
    private static final String SCHEME_NTLM = "NTLM";
    private static final String SCHEME_DIGEST = "DIGEST";
    private static final String SCHEME_BASIC = "BASIC";
    private static final String SCHEME_NEGOTIATE = "NEGOTIATE";
    private final long CANCEL_DURATION = 3000L;
    private final int ACTIVE = 1;
    private final int CANCEL = 2;
    protected ComponentRef parentComponent = null;
    private ThreadLocal<InetAddress> repeatSiteTL = new ThreadLocal();
    private CredentialManager cm;
    private boolean cmInitialized;
    private StateMonitor stateMonitor = new StateMonitor();

    private CredentialManager getCredentialManager() {
        if (!this.cmInitialized) {
            this.cmInitialized = true;
            this.cm = ServiceManager.getService().getCredentialManager();
        }
        return this.cm;
    }

    private BrowserAuthenticator getBrowserAuthenticator() {
        Service service = ServiceManager.getService();
        return service.getBrowserAuthenticator();
    }

    @Override
    protected synchronized PasswordAuthentication getPasswordAuthentication() {
        String scheme = this.getRequestingScheme();
        if (scheme.equalsIgnoreCase(SCHEME_NEGOTIATE)) {
            return null;
        }
        PasswordAuthentication pa = null;
        if (this.stateMonitor.getState(CredentialManager.buildConnectionKey(this)) == 2) {
            return null;
        }
        try {
            String siteName;
            InetAddress site = this.getRequestingSite();
            boolean repeating = false;
            if (site != null) {
                if (site.equals(this.repeatSiteTL.get())) {
                    repeating = true;
                } else {
                    this.repeatSiteTL.set(site);
                }
                siteName = site.toString();
            } else {
                this.repeatSiteTL.set(null);
                siteName = this.getHost();
                if (siteName == null || siteName.length() == 0) {
                    siteName = this.getMessage("net.authenticate.unknownSite");
                }
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("Firewall authentication: site=");
            buffer.append(this.getRequestingSite());
            buffer.append(":" + this.getRequestingPort());
            buffer.append(", protocol=");
            buffer.append(this.getRequestingProtocol());
            buffer.append(", prompt=");
            buffer.append(this.getRequestingPrompt());
            buffer.append(", scheme=");
            buffer.append(scheme);
            Trace.netPrintln(buffer.toString());
            CredentialInfo cred = new CredentialInfo();
            CredentialInfo info = null;
            if (this.getCredentialManager() != null) {
                cred = this.getCredentialManager().getCredential(this);
            }
            if (cred.isCredentialEmpty() || !this.getCredentialManager().isCredentialValid(cred)) {
                cred = CredentialInfo.passAuthToCredentialInfo(this.getBrowserCredential());
                if (this.getCredentialManager() != null) {
                    cred.setSessionId(this.getCredentialManager().getLoginSessionId());
                }
            }
            if (this.getCredentialManager() == null || !this.getCredentialManager().isCredentialValid(cred) || repeating) {
                info = this.openDialog(siteName, this.getRequestingPrompt(), scheme, cred);
                if (info != null) {
                    this.getCredentialManager().saveCredential(this, info);
                    pa = info.getPasswordAuthentication();
                } else {
                    this.stateMonitor.setCancel(CredentialManager.buildConnectionKey(this));
                }
            } else {
                pa = cred.getPasswordAuthentication();
            }
        }
        catch (Exception e) {
            Trace.netPrintException(e);
        }
        return pa;
    }

    private PasswordAuthentication getBrowserCredential() {
        PasswordAuthentication pa = null;
        BrowserAuthenticator browserAuthenticator = this.getBrowserAuthenticator();
        if (browserAuthenticator != null) {
            pa = browserAuthenticator.getAuthentication(this.getRequestingProtocol(), this.getHost(), this.getRequestingPort(), this.getRequestingScheme(), this.getRequestingPrompt(), this.getURL(), this.isProxy());
        }
        return pa;
    }

    private CredentialInfo openDialog(String site, String prompt, String scheme, CredentialInfo cred) {
        if (site == null) {
            site = "";
        }
        if (prompt == null || prompt.trim().equals("")) {
            prompt = "<default>";
        }
        boolean isDomainNeeded = false;
        String authDisplayString = null;
        String warning = null;
        if (scheme != null) {
            if (scheme.equalsIgnoreCase(SCHEME_BASIC)) {
                authDisplayString = this.getMessage("net.authenticate.basic.display.string");
                if (!"https".equals(this.getProtocolScheme()) || this.getRequestorType() != Authenticator.RequestorType.SERVER) {
                    warning = this.getMessage("net.authenticate.basic.display.warning");
                }
            } else if (scheme.equalsIgnoreCase(SCHEME_DIGEST)) {
                authDisplayString = this.getMessage("net.authenticate.digest.display.string");
            } else if (scheme.equalsIgnoreCase(SCHEME_NTLM)) {
                authDisplayString = this.getMessage("net.authenticate.ntlm.display.string");
                isDomainNeeded = true;
            } else {
                authDisplayString = this.getMessage("net.authenticate.unknown.display.string");
            }
        } else {
            authDisplayString = this.getMessage("net.authenticate.unknown.display.string");
        }
        String details = ResourceManager.getString("net.authenticate.text", prompt, site);
        CredentialInfo info = null;
        boolean isPasswordStorageAvailable = false;
        if (this.getCredentialManager() != null) {
            isPasswordStorageAvailable = this.getCredentialManager().isPasswordStorageSupported();
        }
        try {
            info = ToolkitStore.getUI().showPasswordDialog(this.parentComponent == null ? null : this.parentComponent.get(), this.getMessage("password.dialog.title"), details, true, isDomainNeeded, cred, isPasswordStorageAvailable, authDisplayString, warning);
        }
        catch (Exception e) {
            Trace.securityPrintException(e);
        }
        return info;
    }

    private String getMessage(String key) {
        return ResourceManager.getString(key);
    }

    public void setParentComponent(ComponentRef c) {
        this.parentComponent = c;
    }

    @Override
    public String getProtocolScheme() {
        return this.getRequestingProtocol();
    }

    @Override
    public String getHost() {
        try {
            return this.getRequestingHost();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return "";
        }
    }

    @Override
    public int getPort() {
        return this.getRequestingPort();
    }

    @Override
    public String getPath() {
        URL myURL = this.getURL();
        if (myURL != null) {
            return myURL.getPath();
        }
        return null;
    }

    @Override
    public boolean isProxy() {
        try {
            return this.getRequestorType() == Authenticator.RequestorType.PROXY;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
    }

    public URL getURL() {
        try {
            return this.getRequestingURL();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
    }

    @Override
    public String getScheme() {
        try {
            return this.getRequestingScheme();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
    }

    @Override
    public String getPrompt() {
        try {
            return this.getRequestingPrompt();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return null;
        }
    }

    private class StateMonitor {
        private int currentState = 1;
        private long timeOfLastCancel = 0L;
        private String siteKey = "";

        private StateMonitor() {
        }

        private void setCancel(String key) {
            this.currentState = 2;
            this.timeOfLastCancel = System.currentTimeMillis();
            this.siteKey = this.trimPath(key);
        }

        private int getState(String key) {
            int state = 1;
            if (this.currentState == 2) {
                if (System.currentTimeMillis() - this.timeOfLastCancel > 3000L) {
                    this.currentState = 1;
                } else if (key.startsWith(this.siteKey)) {
                    state = 2;
                }
            }
            return state;
        }

        public String trimPath(String key) {
            int i = key.lastIndexOf(47);
            String str = key.substring(0, i + 1);
            return str;
        }
    }
}

